/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv;

import java.io.Serializable;
import java.util.regex.Pattern;
import jp.sf.orangesignal.csv.QuotePolicy;
import jp.sf.orangesignal.csv.SerializationUtils;

public class CsvConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -505939515009014346L;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE = '\"';
    public static final char DEFAULT_ESCAPE = '\\';
    public static final int DEFAULT_SKIP_LINES = 0;
    public static final QuotePolicy DEFAULT_QUOTE_POLICY = QuotePolicy.ALL;
    private char separator;
    private char quote;
    private char escape;
    private boolean quoteDisabled;
    private boolean escapeDisabled;
    private String breakString;
    private String nullString;
    private boolean ignoreCaseNullString;
    private boolean ignoreLeadingWhitespaces;
    private boolean ignoreTrailingWhitespaces;
    private boolean ignoreEmptyLines;
    private Pattern[] ignoreLinePatterns;
    private int skipLines = 0;
    private QuotePolicy quotePolicy = DEFAULT_QUOTE_POLICY;
    private boolean utf8bomPolicy;
    private String lineSeparator = System.getProperty("line.separator");

    public CsvConfig() {
        this(',', '\"', '\\', true, true);
    }

    public CsvConfig(char separator) {
        this(separator, '\"', '\\', true, true);
    }

    public CsvConfig(char separator, char quote, char escape) {
        this(separator, quote, escape, false, false);
    }

    public CsvConfig(char separator, char quote, char escape, boolean quoteDisabled, boolean escapeDisabled) {
        this.separator = separator;
        this.quote = quote;
        this.escape = escape;
        this.quoteDisabled = quoteDisabled;
        this.escapeDisabled = escapeDisabled;
    }

    public void validate() throws IllegalArgumentException {
        if (this.separator == '\r' || this.separator == '\n') {
            throw new IllegalArgumentException("Invalid separator character");
        }
        if (!(this.quoteDisabled || this.quote != this.separator && this.quote != '\r' && this.quote != '\n')) {
            throw new IllegalArgumentException("Invalid quote character");
        }
        if (!(this.escapeDisabled || this.escape != this.separator && this.escape != '\r' && this.escape != '\n')) {
            throw new IllegalArgumentException("Invalid escape character");
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getQuote() {
        return this.quote;
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }

    public char getEscape() {
        return this.escape;
    }

    public void setEscape(char escape) {
        this.escape = escape;
    }

    public boolean isQuoteDisabled() {
        return this.quoteDisabled;
    }

    public void setQuoteDisabled(boolean disabled) {
        this.quoteDisabled = disabled;
    }

    public boolean isEscapeDisabled() {
        return this.escapeDisabled;
    }

    public void setEscapeDisabled(boolean disabled) {
        this.escapeDisabled = disabled;
    }

    public String getBreakString() {
        return this.breakString;
    }

    public void setBreakString(String breakString) {
        this.breakString = breakString;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.setNullString(nullString, false);
    }

    public void setNullString(String nullString, boolean ignoreCase) {
        this.nullString = nullString;
        this.ignoreCaseNullString = ignoreCase;
    }

    public boolean isIgnoreCaseNullString() {
        return this.ignoreCaseNullString;
    }

    public void setIgnoreCaseNullString(boolean ignoreCaseNullString) {
        this.ignoreCaseNullString = ignoreCaseNullString;
    }

    public boolean isIgnoreLeadingWhitespaces() {
        return this.ignoreLeadingWhitespaces;
    }

    public void setIgnoreLeadingWhitespaces(boolean ignore) {
        this.ignoreLeadingWhitespaces = ignore;
    }

    public boolean isIgnoreTrailingWhitespaces() {
        return this.ignoreTrailingWhitespaces;
    }

    public void setIgnoreTrailingWhitespaces(boolean ignore) {
        this.ignoreTrailingWhitespaces = ignore;
    }

    public boolean isIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public void setIgnoreEmptyLines(boolean ignore) {
        this.ignoreEmptyLines = ignore;
    }

    public Pattern[] getIgnoreLinePatterns() {
        return this.ignoreLinePatterns;
    }

    public void setIgnoreLinePatterns(Pattern ... ignoreLinePatterns) {
        this.ignoreLinePatterns = ignoreLinePatterns;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(int skipLines) {
        this.skipLines = skipLines;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public QuotePolicy getQuotePolicy() {
        return this.quotePolicy;
    }

    public void setQuotePolicy(QuotePolicy quotePolicy) {
        if (quotePolicy == null) {
            throw new IllegalArgumentException("QuotePolicy must not be null");
        }
        this.quotePolicy = quotePolicy;
    }

    public boolean isUtf8bomPolicy() {
        return this.utf8bomPolicy;
    }

    public void setUtf8bomPolicy(boolean utf8bomPolicy) {
        this.utf8bomPolicy = utf8bomPolicy;
    }

    public CsvConfig clone() {
        return (CsvConfig)SerializationUtils.clone(this);
    }
}

