<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software: you can redistribute it and/or
modify it under the terms of the GNU Affero General Public License
as published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
--%>
<%@ page
language     = "java"
pageEncoding = "UTF-8"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.framework.base.MospParams"
import = "jp.mosp.framework.constant.MospConst"
import = "jp.mosp.framework.utils.HtmlUtility"
import = "jp.mosp.platform.constant.PlatformConst"
import = "jp.mosp.platform.utils.PlatformUtility"
import = "jp.mosp.time.comparator.settings.HolidayRequestApproverNameComparator"
import = "jp.mosp.time.comparator.settings.HolidayRequestHolidayType1Comparator"
import = "jp.mosp.time.comparator.settings.HolidayRequestHolidayType2Comparator"
import = "jp.mosp.time.comparator.settings.HolidayRequestHolidayType3Comparator"
import = "jp.mosp.time.comparator.settings.HolidayRequestRequestDateComparator"
import = "jp.mosp.time.comparator.settings.HolidayRequestStateComparator"
import = "jp.mosp.time.constant.TimeConst"
import = "jp.mosp.time.input.action.HolidayRequestAction"
import = "jp.mosp.time.input.vo.HolidayRequestVo"
%><%
MospParams params = (MospParams)request.getAttribute(MospConst.ATT_MOSP_PARAMS);
HolidayRequestVo vo = (HolidayRequestVo)params.getVo();
%>
<div class="ListHeader">
	<table class="EmployeeLabelTable">
		<tr>
			<jsp:include page="<%= TimeConst.PATH_TIME_COMMON_INFO_JSP %>" flush="false" />
		</tr>
	</table>
</div>
<div class="List" id="divRemainder">
	<table class="ListTable" id="tblPaidHoliday">
		<tr>
			<td class="ListSelectTh" rowspan="4"><%= params.getName("PaidVacation") %><%= params.getName("Information") %></td>
			<td class="ListSelectTh" colspan="2"><%= params.getName("PreviousYear") %><%= params.getName("Times") %><%= params.getName("PaidVacation") %><%= params.getName("Remainder") %></td>
			<td class="ListSelectTh" colspan="2"><%= params.getName("ThisYear") %><%= params.getName("Times") %><%= params.getName("PaidVacation") %><%= params.getName("Remainder") %></td>
			<td class="ListSelectTh" colspan="2"><%= params.getName("PaidVacation") %><%= params.getName("Application") %><%= params.getName("Possible") %><%= params.getName("Remainder") %></td>
			<td class="ListSelectTh"><%= params.getName("Stock") %><%= params.getName("Remainder") %><%= params.getName("Days") %></td>
		</tr>
		<tr>
			<td class="SelectTd" id="lblFormerDay"><%= HtmlUtility.escapeHTML(vo.getLblFormerDay()) %><%= params.getName("Day") %></td>
			<td class="SelectTd" id="lblFormerTime"><%= HtmlUtility.escapeHTML(vo.getLblFormerTime()) %><%= params.getName("Time") %></td>
			<td class="SelectTd" id="lblCurrentDay"><%= HtmlUtility.escapeHTML(vo.getLblCurrentDay()) %><%= params.getName("Day") %></td>
			<td class="SelectTd" id="lblCurrentTime"><%= HtmlUtility.escapeHTML(vo.getLblCurrentTime()) %><%= params.getName("Time") %></td>
			<td class="SelectTd" id="lblTotalDay"><%= HtmlUtility.escapeHTML(vo.getLblTotalDay()) %><%= params.getName("Day") %></td>
			<td class="SelectTd" id="lblTotalTime"><%= HtmlUtility.escapeHTML(vo.getLblTotalTime()) %><%= params.getName("Time") %></td>
			<td class="SelectTd" id="lblPaidHolidayStock"><%= HtmlUtility.escapeHTML(vo.getLblPaidHolidayStock()) %><%= params.getName("Day") %></td>
		</tr>
		<tr>
			<td class="ListSelectTh" colspan="2"><%= params.getName("NextTime") %><%= params.getName("Giving") %><%= params.getName("Schedule") %><%= params.getName("FrontParentheses") %><%= params.getName("Automatic") %><%= params.getName("BackParentheses") %></td>
			<td class="ListSelectTh" colspan="2"><%= params.getName("NextTime") %><%= params.getName("Giving") %><%= params.getName("Schedule") %><%= params.getName("Days") %><%= params.getName("FrontParentheses") %><%= params.getName("Automatic") %><%= params.getName("BackParentheses") %></td>
			<td class="ListSelectTh" colspan="2"><%= params.getName("NextTime") %><%= params.getName("Giving") %><%= params.getName("Schedule") %><%= params.getName("FrontParentheses") %><%= params.getName("ManualOperation") %><%= params.getName("BackParentheses") %></td>
			<td class="ListSelectTh"><%= params.getName("NextTime") %><%= params.getName("Giving") %><%= params.getName("Schedule") %><%= params.getName("Days") %><%= params.getName("FrontParentheses") %><%= params.getName("ManualOperation") %><%= params.getName("BackParentheses") %></td>
		</tr>
		<tr>
			<td class="SelectTd" id="lblNextGivingDate" colspan="2"><%= HtmlUtility.escapeHTML(vo.getLblNextGivingDate()) %></td>
			<td class="SelectTd" id="lblNextGivingAmount" colspan="2"><%= HtmlUtility.escapeHTML(vo.getLblNextGivingAmount()) %><%= params.getName("Day") %></td>
			<td class="SelectTd" id="lblNextManualGivingDate" colspan="2"><%= HtmlUtility.escapeHTML(vo.getLblNextManualGivingDate()) %></td>
			<td class="SelectTd" id="lblNextManualGivingAmount"><%= HtmlUtility.escapeHTML(vo.getLblNextManualGivingAmount()) %></td>
		</tr>
	</table>
<%
if (vo.getAryLblGivingDate().length > 0) {
%>
	<table class="ListTable" id="tblSpecialHoliday">
		<tr>
			<td class="ListSelectTh"><%= params.getName("GrantDate") %>
			<td class="ListSelectTh"><%= params.getName("Vacation") %><%= params.getName("Classification") %></td>
			<td class="ListSelectTh" id="tdVacationName"><%= params.getName("Vacation") %><%= params.getName("Name") %></td>
			<td class="ListSelectTh"><%= params.getName("Application") %><%= params.getName("Possible") %><%= params.getName("Days") %></td>
			<td class="ListSelectTh"><%= params.getName("Acquisition") %><%= params.getName("TimeLimit") %></td>
		</tr>
<% for (int i = 0; i < vo.getAryLblGivingDate().length; i++) { %>
		<tr>
			<td class="SelectTd" id="lblGivingDate"><%= HtmlUtility.escapeHTML(vo.getAryLblGivingDate()[i]) %></td>
			<td class="SelectTd" id="lblSpecialHolidayType"><%= HtmlUtility.escapeHTML(vo.getAryLblSpecialHolidayType()[i]) %></td>
			<td class="SelectTd" id="lblSpecialHolidayName"><%= HtmlUtility.escapeHTML(vo.getAryLblSpecialHolidayName()[i]) %></td>
			<td class="SelectTd" id="lblRemainder"><%= HtmlUtility.escapeHTML(vo.getAryLblRemainder()[i]) %></td>
			<td class="SelectTd" id="lblLimit"><%= HtmlUtility.escapeHTML(vo.getAryLblLimit()[i]) %></td>
		</tr>
<% } %>
	</table>
<%
}
%>
</div>
<div class="List">
	<table class="InputTable">
		<tr>
			<th class="EditTableTh" colspan="4">
				<jsp:include page="<%= TimeConst.PATH_TIME_APPLY_INFO_JSP %>" flush="false" />
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Vacation") %><%= params.getName("Year") %><%= params.getName("Month") %><%= params.getName("Day") %></td>
			<td class="InputTd" colspan="3">
				<select class="Number4PullDown" id="pltEditStartYear" name="pltEditStartYear">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditStartYear(), vo.getPltEditStartYear()) %>
				</select>
				<%= params.getName("Year") %>&nbsp;
				<select class="Number2PullDown" id="pltEditStartMonth" name="pltEditStartMonth">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditStartMonth(), vo.getPltEditStartMonth()) %>
				</select>
				<%= params.getName("Month") %>&nbsp;
				<select class="Number2PullDown" id="pltEditStartDay" name="pltEditStartDay">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditStartDay(), vo.getPltEditStartDay()) %>
				</select>
				<%= params.getName("Day") %>
				<%= params.getName("Wave") %>
				<select class="Number4PullDown" id="pltEditEndYear" name="pltEditEndYear">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditEndYear(), vo.getPltEditEndYear()) %>
				</select>
				<%= params.getName("Year") %>&nbsp;
				<select class="Number2PullDown" id="pltEditEndMonth" name="pltEditEndMonth">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditEndMonth(), vo.getPltEditEndMonth()) %>
				</select>
				<%= params.getName("Month") %>&nbsp;
				<select class="Number2PullDown" id="pltEditEndDay" name="pltEditEndDay">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditEndDay(), vo.getPltEditEndDay()) %>
				</select>
				<%= params.getName("Day") %>&nbsp;
				<button type="Button" class="Name2Button" id="btnHolidayDate" onclick="submitForm(event, null, checkDateExtra, '<%= HolidayRequestAction.CMD_SET_ACTIVATION_DATE %>');"><%= vo.getModeActivateDate().equals(PlatformConst.MODE_ACTIVATE_DATE_FIXED) ? params.getName("Change") : params.getName("Decision") %></button>
			</td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Vacation") %><%= params.getName("Classification") %></td>
			<td class="InputTd">
				<select class="PullDown" id="pltEditHolidayType" name="pltEditHolidayType1">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditHolidayType1(), vo.getPltEditHolidayType1()) %>
				</select>
				<select class="Name4PullDown" id="pltEditStatusWithPay" name="pltEditStatusWithPay">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditHolidayType2WithPay(), vo.getPltEditStatusWithPay()) %>
				</select>
				<select class="Name3PullDown" id="pltEditStatusSpecial" name="pltEditStatusSpecial">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditHolidayType2Special(), vo.getPltEditStatusSpecial()) %>
				</select>
				<select class="Name3PullDown" id="pltEditSpecialOther" name="pltEditSpecialOther">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditHolidayType2Other(), vo.getPltEditSpecialOther()) %>
				</select>
				<select class="Name3PullDown" id="pltEditSpecialAbsence" name="pltEditSpecialAbsence">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditHolidayType2Absence(), vo.getPltEditSpecialAbsence()) %>
				</select>
				<select class="Name3PullDown" id="pltEditHolidayRange1" name="pltEditHolidayRangePaidHoliday">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditHolidayRangePaidHoliday(), vo.getPltEditHolidayRangePaidHoliday()) %>
				</select>
				<select class="Name3PullDown" id="pltEditHolidayRange2" name="pltEditHolidayRange">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditHolidayRange(), vo.getPltEditHolidayRange()) %>
				</select>
			</td>
			<td class="TitleTd"><%= params.getName("Time") %><%= params.getName("Rest") %><%= params.getName("Application") %><%= params.getName("Time") %></td>
			<td class="InputTd">
				<select class="Number2PullDown" id="pltEditStartHour" name="pltEditStartHour">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditStartHour(), vo.getPltEditStartHour()) %>
				</select>&nbsp;:
				<select class="Number2PullDown" id="pltEditStartMinute" name="pltEditStartMinute">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditStartMinute(), vo.getPltEditStartMinute()) %>
				</select>&nbsp;
				<%= params.getName("Wave") %>&nbsp;
				<select class="Number2PullDown" id="pltEditEndHour" name="pltEditEndHour">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditEndHour(), vo.getPltEditEndHour()) %>
				</select>&nbsp;:
				<select class="Number2PullDown" id="pltEditEndMinute" name="pltEditEndMinute">
					<%= HtmlUtility.getSelectOption(vo.getAryPltEditEndMinute(), vo.getPltEditEndMinute()) %>
				</select>
			</td>
		</tr>
		<tr>
			<td class="TitleTd"><label for="txtEditRequestReason"><%= params.getName("Vacation") %><%= params.getName("Reason") %></label></td>
			<td class="InputTd" colspan="3">
				<input type="text" class="Name21TextBox" id="txtEditRequestReason" name="txtEditRequestReason" value="<%= HtmlUtility.escapeHTML(vo.getTxtEditRequestReason()) %>" />
			</td>
		</tr>
	</table>
	<jsp:include page="<%= TimeConst.PATH_TIME_APPLY_BUTTON_JSP %>" flush="false" />
	<jsp:include page="<%= TimeConst.PATH_TIME_APPROVER_PULLDOWN_JSP %>" flush="false" />
</div>
<div class="List">
	<table class="InputTable">
		<tr>
			<th class="ListTableTh" colspan="6">
				<span class="TitleTh"><%= params.getName("Search") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Vacation") %><%= params.getName("Classification") %></td>
			<td class="InputTd">
				<select class="PullDown" id="pltSearchHolidayType" name="pltSearchHolidayType">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSearchHolidayType1(), vo.getPltSearchHolidayType()) %>
				</select>
				<select class="Name3PullDown" id="pltSearchStatus" name="pltSearchSpecialHoliday">
				</select>
				<select class="Name3PullDown" id="pltSearchStatusWithPay" name="pltSearchStatusWithPay">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSearchHolidayType2WithPay(), vo.getPltSearchStatusWithPay()) %>
				</select>
				<select class="Name3PullDown" id="pltSearchStatusSpecial" name="pltSearchStatusSpecial">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSearchHolidayType2Special(), vo.getPltSearchStatusSpecial()) %>
				</select>
				<select class="Name3PullDown" id="pltSearchSpecialOther" name="pltSearchSpecialOther">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSearchHolidayType2Other(), vo.getPltSearchSpecialOther()) %>
				</select>
				<select class="Name3PullDown" id="pltSearchSpecialAbsence" name="pltSearchSpecialAbsence">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSearchHolidayType2Absence(), vo.getPltSearchSpecialAbsence()) %>
				</select>
				<select class="Name3PullDown" id="pltSearchHolidayRange" name="pltSearchHolidayLength">
				</select>
				<select class="Name3PullDown" id="pltSearchHolidayRange1" name="pltSearchHolidayRange1">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSearchHolidayRangePaidHoliday(), vo.getPltSearchHolidayRange1()) %>
				</select>
				<select class="Name3PullDown" id="pltSearchHolidayRange2" name="pltSearchHolidayRange2">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSearchHolidayRange(), vo.getPltSearchHolidayRange2()) %>
				</select>
			</td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd">
				<select class="Name3PullDown" id="pltSearchState" name="pltSearchState">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSearchState(), vo.getPltSearchState()) %>
				</select>
			</td>
			<td class="TitleTd"><%= params.getName("Display") %><%= params.getName("Period") %></td>
			<td class="InputTd">
				<select class="Number4PullDown" id="pltSearchYear" name="pltSearchYear">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSearchYear(), vo.getPltSearchYear()) %>
				</select>
				<%= params.getName("Year") %>
				<select class="Number2PullDown" id="pltSearchMonth" name="pltSearchMonth">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSearchMonth(), vo.getPltSearchMonth()) %>
				</select>
				<%= params.getName("Month") %>&nbsp;
				<button type="Button" class="Name2Button" id="btnRequestDate" onclick="submitTransfer(event, null, null, new Array('null', 'null', 'null' , 'null'), '<%= HolidayRequestAction.CMD_SET_VIEW_PERIOD %>');"><%= vo.getJsSearchModeActivateDate().equals(PlatformConst.MODE_ACTIVATE_DATE_FIXED) ? params.getName("Change") : params.getName("Decision") %></button>
			</td>
		</tr>
	</table>
	<table class="ButtonTable">
		<tr>
			<td class="ButtonTd" id="">
				<button type="button" class="Name2Button" id="btnSearch" onclick="submitForm(event, 'divSearch', null, '<%= HolidayRequestAction.CMD_SEARCH %>')"><%= params.getName("Search") %></button>
			</td>
		</tr>
	</table>
</div>
<%= HtmlUtility.getListInfoFlex(params, vo.getList(), vo.getPageCommand(), vo.getDataPerPage(), vo.getSelectIndex()) %>
<div class="FixList" id="divList">
	<table class="LeftListTable" id="list">
		<thead>
			<tr>
				<th class="ListSelectTh" id="thButton"></th>
				<th class="ListSortTh" id="thHolidayDate"		onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= HolidayRequestRequestDateComparator.class.getName() %>'), '<%= HolidayRequestAction.CMD_SORT %>')"><%= params.getName("Day") %><%= PlatformUtility.getSortMark(HolidayRequestRequestDateComparator.class.getName(), params) %></th>
				<th class="ListSortTh" id="thHolidayType"		onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= HolidayRequestHolidayType1Comparator.class.getName() %>'), '<%= HolidayRequestAction.CMD_SORT %>')"><%= params.getName("Vacation") %><%= params.getName("Type") %><%= PlatformUtility.getSortMark(HolidayRequestHolidayType1Comparator.class.getName(), params) %></th>
				<th class="ListSortTh" id="thHolidayRange"		onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= HolidayRequestHolidayType3Comparator.class.getName() %>'), '<%= HolidayRequestAction.CMD_SORT %>')"><%= params.getName("Range") %><%= PlatformUtility.getSortMark(HolidayRequestHolidayType3Comparator.class.getName(), params) %></th>
				<th class="ListSelectTh" id="thHolidayTime"><%= params.getName("Application") %><%= params.getName("Time") %></th>
				<th class="ListSelectTh" id="thHolidayReason"><%= params.getName("Vacation") %><%= params.getName("Reason") %></th>
				<th class="ListSortTh" id="thHolidayState"		onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= HolidayRequestStateComparator.class.getName() %>'), '<%= HolidayRequestAction.CMD_SORT %>')"><%= params.getName("State") %><%= PlatformUtility.getSortMark(HolidayRequestStateComparator.class.getName(), params) %></th>
				<th class="ListSortTh" id="thHolidayApprover"	onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= HolidayRequestApproverNameComparator.class.getName() %>'), '<%= HolidayRequestAction.CMD_SORT %>')"><%= params.getName("Approver") %><%= PlatformUtility.getSortMark(HolidayRequestApproverNameComparator.class.getName(), params) %></th>
				<th class="ListSelectTh" id="thSelect">
<%
if (!vo.getList().isEmpty()) {
%>
					<input type="checkbox" class="CheckBox" id="ckbSelect" onclick="doAllBoxChecked(this);">
<%
}
%>
				</th>
			</tr>
		</thead>
		<tbody>
<%
for (int i = 0; i < vo.getAryLblDate().length; i++) {
%>
			<tr>
				<td class="ListSelectTd">
<% if(!vo.getAryLblOnOff()[i].isEmpty()) { %>
					<button type="button" class="Name2Button" id="btnSelect" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_ACTIVATE_DATE %>', '<%= HtmlUtility.escapeHTML(vo.getAryLblDate()[i]) %>', '<%= TimeConst.PRM_TRANSFERRED_HOLIDAY_TYPE1 %>' , '<%= HtmlUtility.escapeHTML(vo.getAryHolidayType1()[i]) %>', '<%= TimeConst.PRM_TRANSFERRED_HOLIDAY_TYPE2 %>' , '<%= HtmlUtility.escapeHTML(vo.getAryHolidayType2()[i]) %>', '<%= TimeConst.PRM_TRANSFERRED_HOLIDAY_RANGE %>' , '<%= HtmlUtility.escapeHTML(vo.getAryHolidayType3()[i]) %>', '<%= TimeConst.PRM_TRANSFERRED_START_TIME %>' , '<%= vo.getAryLblHolidayTime()[i].substring(0, vo.getAryLblHolidayTime()[i].indexOf(params.getName("Wave"))) %>'),'<%= HolidayRequestAction.CMD_EDIT_MODE %>')"><%= params.getName("Select") %></button>
<% } %>
				</td>
				<td class="ListSelectTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryLblDate()[i]) %></td>
				<td class="ListSelectTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryLblHolidayType1()[i]) %>&nbsp;<%= HtmlUtility.escapeHTML(vo.getAryLblHolidayType2()[i]) %></td>
				<td class="ListSelectTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryLblHolidayType3()[i]) %></td>
				<td class="ListSelectTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryLblHolidayTime()[i]) %></td>
				<td class="ListInputTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryLblRequestReason()[i]) %></td>
				<td class="ListSelectTd">
					<a class="Link" id="linkApprovalHistory" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_INDEX %>', '<%= i %>'), '<%= HolidayRequestAction.CMD_TRANSFER %>');""><%= HtmlUtility.escapeHTML(vo.getAryLblState()[i]) %></a>
				</td>
				<td class="ListSelectTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryLblApprover()[i]) %></td>
				<td class="ListSelectTd">
<% if(vo.getAryLblState()[i].equals(params.getName("WorkPaper"))) { %>
					<input type="checkbox" class="CheckBox" name="ckbSelect" value="<%= HtmlUtility.escapeHTML(vo.getAryCkbHolidayRequestListId()[i]) %>" />
<% } %>
				</td>
			</tr>
<%
}
if (!vo.getList().isEmpty()) {
%>
			<tr>
				<td class="BottomTd" colspan="9">
					<span class="TableButtonSpan">
						<button type="button" class="Name4Button" id="btnUpdate" onclick="submitRegist(event, null, checkExtra, '<%= HolidayRequestAction.CMD_BATCH_UPDATE %>');"><%= params.getName("Application") %></button>
					</span>
				</td>
			</tr>
<%
}
%>
		</tbody>
	</table>
</div>
