Imports System.io

' DotNet-Core V1.0
' 
' Name:             NCoreLogfile
' Last Update:      12/1/2007
'
' NCoreLogfile is an error and evend logging system

' This routine writes log files to the users temporary folder, with the name of the current application
'
' Provides:
' NcoreLogfileLevel              An integer representing the minimum event significance to save
' NcoreLogfileMessage(msg,lvl)   Log a message with 'lvl' significance
' NcoreLogfileErrorOccured       if a serious (lvl 9,10) error occured this is true
'                                you may set this to false, do a bunch of commands, then test it to see
'                                if anything failed along the way.
'
' Log file has 10 levels, only events with importance higher or equal to the current level are saved
' eg... 
'   a level 1 event may be that a button was clicked on
'   a level 5 event may be that a data import was done
'   a level 7 event may be that a user changed system defaults
'   a level 9 event may be that the system tried to save a file, but failed because it was in use
'   a level 10 event may be that the systems ini files are corrupt.

' level 10 popus up an instant message.  the reccomended normal level is 5, 1 for debugging.

' Log levels
'1  - verbose only
'3  - trivial event
'5  - significant event
'7  - important event - noncritical
'9  - serious error, report a failure
'10 - dangerous immediate warning
'
'EG:
'   Logfile.NCoreLogfileMessage("CsvWriter could not initialiase file," + ex.Message, 9)
'
'
Module NCoreLogfile
    Public Logfile As NCoreLogfile = New NCoreLogfile

    Public Class NCoreLogfile
        Public NCoreLogfileLevel As Integer = 5
        Public NCoreLogfileLasterror As String
        Public NCoreLogfileSilentFail As Boolean = False
        Public NCoreLogfileErrorOccured As Boolean = False
        Public Sub New()
            Try
                NCoreLogfileMessage("*** Application starterd ***", 7)
            Catch ex As Exception
                doMessageBox("Logfile Error:" & ex.Message)
            End Try

        End Sub
        Protected Overrides Sub Finalize()

            Try
                NCoreLogfileMessage("*** Application Finished ***", 7)
            Catch ex As Exception
                doMessageBox("Logfile Error:" & ex.Message)
            End Try

            MyBase.Finalize()
        End Sub
        Public Sub NCoreLogfileMessage(ByVal Line As String, ByVal Importance As Integer)
            'This function handles Event Logging
            Try
                Dim NameSpc As String = Reflection.Assembly.GetExecutingAssembly().GetName().Name.ToString()

                'critical message occured 
                NCoreLogfileLasterror = Format(Now, "dd-MM-yy HH:mm:ss..,") + Line
                If Importance = 10 And NCoreLogfileSilentFail = False Then
                    MsgBox(Format(Now, "dd-MM-yy HH:mm:ss..,") + Line)
                End If

                If NCoreLogfileLevel <= Importance Then
                    ' we use APPEND to add lines to our logfile.
                    ' We open and close the file each time, on the basis that this will survive a crash.
                    Dim objStreamWriter As StreamWriter
                    objStreamWriter = New StreamWriter(Environ("temp") + "\" + NameSpc + ".log", True)
                    objStreamWriter.WriteLine(Format(Now, "dd-mm-yy HH:mm:ss..,") + Line)
                    objStreamWriter.Close()
                    objStreamWriter = Nothing
                End If
                If Importance > 8 Then NCoreLogfileErrorOccured = True

            Catch ex As Exception
                doMessageBox("Logfile Error:" & ex.Message)
            End Try
        End Sub
    End Class
End Module
