' DotNet-Core V1.1
' 
' Name:             NCoreGetItem
' Last Update:      17/10/2008
'
' NCoreGetItem is a splitter for strings, such as CSV lines etc.
'
' Provides:
' NCoreGetItem(String, Character, Position)     Gets item POSITION from STRING splitting on CHARACTER
' NcoreGetItemPos(line, findme, character) Finds the position of FINDME in LINE split by CHARACTER
' NcoreCountItems(ByVal lin As String, ByVal ch As String)
'
' note first position is 0
'
' Requires: NCoreLogFile
'
'EG:
'   A$=NcoreGetItem("Hello World"," ",1) = "World"
' 
'   a=NcoreCountitems(Hello World"," ") = 1

Module NCoreGetItemModule
    Public Function NCoreGetItem(ByVal lin As String, ByVal ch As String, ByVal pos As Integer) As String
        If lin Is Nothing Then Return "" : Exit Function
        If lin.Length > 0 Then  ' check the string isn't null (could cause a crash)
            Try
                If pos > NcoreCountItems(lin, ch) Then      ' check the position actually exists
                    Return ""
                    Exit Function
                End If
                Dim stringarray() As String = lin.Split(ch) ' split the string
                Return stringarray(pos)                     ' return the result
            Catch ex As Exception
                Logfile.NCoreLogfileMessage("NCoreGetItem Panic," + ex.Message, 9)

            End Try
        End If
        Return ""
    End Function
    Public Function NCoreGetItem(ByVal lin As String, ByVal ch As String, ByVal pos As Integer, ByVal brackets As String) As String

        Dim bracketarray As String = ""
        Dim part As String = ""
        Dim foundnum As Integer = 0
        For i As Integer = 1 To Len(lin)

            Dim c As String = Mid(lin, i, 1)
            If c = ch And bracketarray = "" Then
                If foundnum = pos Then Return part Else part = "" : foundnum = foundnum + 1
            Else
                part = part + c
            End If

            '    MsgBox(c)
            If c = Chr(34) And InStr(brackets, Chr(34)) > 0 Then
                If Right(bracketarray, 1) = Chr(34) And bracketarray <> "" Then
                    bracketarray = Left(bracketarray, Len(bracketarray) - 1)
                Else
                    bracketarray = bracketarray + Chr(34)
                End If
                'part = part + c
            ElseIf (c = "(" Or c = ")") And InStr(brackets, "(") > 0 Then
                If Right(bracketarray, 1) = "(" And c = ")" And bracketarray <> "" Then
                    bracketarray = Left(bracketarray, Len(bracketarray) - 1)
                Else
                    bracketarray = bracketarray + "("
                End If
                'part = part + c
            ElseIf (c = "{" Or c = "}") And InStr(brackets, "{") > 0 Then
                If Right(bracketarray, 1) = "{" And c = "}" And bracketarray <> "" Then
                    bracketarray = Left(bracketarray, Len(bracketarray) - 1)
                Else
                    bracketarray = bracketarray + "{"
                End If
                'part = part + c
            End If
           
        Next
        If foundnum = pos Then Return part
        If pos = -1 Then Return foundnum
        Return ""
    End Function
    Public Function NcoreGetItemPos(ByVal lin As String, ByVal findme As String, ByVal ch As String) As Integer
        If lin Is Nothing Then Exit Function
        If lin.Length > 0 Then
            Dim ps As Integer = InStr(ch + lin + ch, ch + findme + ch)
            NcoreGetItemPos = NcoreCountItems(Left(ch + lin + ch, ps), ch) - 1
        Else
            NcoreGetItemPos = -1
        End If
    End Function
    Public Function NcoreCountItems(ByVal lin As String, ByVal ch As String, ByVal brackets As String) As Integer
        Return NCoreGetItem(lin, ch, -1, brackets) + 1
    End Function
    Public Function NcoreCountItems(ByVal lin As String, ByVal ch As String) As Integer
        If lin Is Nothing Then Exit Function
        If lin.Length = 0 Then Exit Function
        Try
            Dim i, count As Integer
            For i = 0 To lin.Length - 1                             ' Look through the string counting all occurances of 'ch'
                Try
                    If lin.Chars(i) = ch Then count = count + 1
                Catch ex As Exception
                    MsgBox(ex.ToString)
                End Try

            Next
            Return count
        Catch ex As Exception
            Logfile.NCoreLogfileMessage("NCoreCountItems Panic," + ex.Message, 9)
        End Try

    End Function
    Function replaceone(ByVal ln$, ByVal A$, ByVal b$) As String
        Dim la, inpos As Integer
        Dim c$, d$
        c$ = ln$
        la = Len(A$)
        If InStr(c$, A$) > 0 Then
            inpos = InStr(c$, A$)
            d$ = Left$(c$, inpos - 1)
            d$ = d$ + b$
            d$ = d$ + rightstr(c$, Len(c$) - (inpos + (Len(A$) - 1)))
            c$ = d$
        End If
        replaceone = c$
    End Function
    Public Function ncoregetbetween(ByVal lin$, ByVal lf$, ByVal rt$) As String
        Dim aa, bb As Integer

        aa = InStr(lin$, lf$) + Len(lf$)
        bb = InStr(lin$, rt$)

        If aa = 0 Or bb = 0 Then
            ncoregetbetween = ""
        Else
            ncoregetbetween = Mid$(lin$, aa, bb - aa)
        End If

    End Function
End Module