﻿Imports System.IO
Module gameflash
    Public DataK(16384) As String
    Public DataH(16384) As String
    Public DataE(16384) As String
    Public DataEg(16384) As String
    Public DataEgCount(16384) As Integer
    Public DataScore(16384) As String
    Public minprob As Integer = -999
    Public maxprob As Integer = 999
    Public retestbias As Integer = 2
    Public Score As Integer = 0
    Public questions As Integer = 0
    Public answers As String
    Public qformx As Integer = -1
    Public threadans As Integer = -1
    Public qformy As Integer = -1
    Public MaxData As Integer = -1
    Public mylanguage As Integer = 1
    Public wordfile As String
    Public nothreads As Integer = 0
    Function GetExample(ByVal find As String, Optional ByVal findnum As Integer = 1, Optional ByVal onlyexact As Boolean = False) As String
        GetExample = ""
        Dim filen As String = "examples"
        If find = "" Then Return ""
        If System.IO.File.Exists(filen) = False Then Exit Function

        Dim found As Integer = 0

        Dim myeg As String = ""
        Dim sr As New System.IO.StreamReader(filen, System.Text.Encoding.GetEncoding("EUC-JP"))
        While Not sr.EndOfStream And found < 100
            Dim lin As String = sr.ReadLine
            If leftstr(lin, 2) = "A:" Then myeg = lin
            If (InStr(LCase(lin), find) > 0 And onlyexact = False) Or (InStr(LCase(myeg), find) > 0 And onlyexact = True) Then
                myeg = NCoreGetItem(Replace(Replace(myeg, "A:", "eg:"), "\", ""), "#", 0)
                If GetExample = "" Then GetExample = myeg
                found = found + 1
                If findnum = found Then
                    sr.Close()
                    Exit Function
                End If

            End If
        End While
        sr.Close()
        If findnum < 0 Then GetExample = CStr(found) : Exit Function

        If GetExample = "" Then GetExample = "No Example"


    End Function
    Public Sub findeg()

        If threadans = -1 Then Exit Sub
        Dim eg As String = ""
        Dim examples As Integer = DataEgCount(threadans)
        If examples = 0 Then examples = Val(GetExample(DataK(threadans), -1, False))
        If examples > 0 Then
            '        Dim oldtext As String = Label1.Text
            eg = GetExample(DataK(threadans), Int(Rnd() * examples) + 1, False)
            'If InStr(eg, DataK(ans)) > 0 Then DataEg(ans) = eg
            DataEg(threadans) = Trim(Replace(Replace(eg, "\", ""), "eg:", ""))
            DataEgCount(threadans) = examples
        Else
            DataEgCount(threadans) = -1
        End If
        threadans = -1
    End Sub
    Public Function rightstr(ByVal Lin As String, ByVal i As Integer)
        If i < 1 Then Return ""
        rightstr = Right(Lin, i)
    End Function
    Public Function leftstr(ByVal lin As String, ByVal i As Integer)
        If i < 1 Then Return ""
        leftstr = Left(lin, i)
    End Function
    Public inifile As String = "MouseFlash.ini"
    Public Sub domessagebox(ByVal lin)
        MsgBox(lin)
    End Sub
    Public Sub main()
        qformx = CInt(NCoreGetIniValue(inifile, "QFormX", "-1"))
        qformy = CInt(NCoreGetIniValue(inifile, "QFormY", "-1"))
        mylanguage = NCoreGetIniValue(inifile, "Language", 1)
        nothreads = NCoreGetIniValue(inifile, "nothreads", 1)
        Dim game As String = "quiz"
        Dim wordfile As String = ""
        Dim args As String() = Environment.GetCommandLineArgs()
        If Not args Is Nothing Then
            Try
                If args.GetUpperBound(0) > 0 Then

                    wordfile = args(1)
                    game = args(2)
                End If
            Catch ex As Exception

            End Try

        End If
        If wordfile = "" Then
            Dim d As New OpenFileDialog
            d.Filter = "Text files (*.txt)|*.txt"
            d.ShowDialog()
            wordfile = d.FileName
            d.Dispose()
        End If
        If wordfile = "" Then End
        loadFile(wordfile)
        'Dim fr As New Question(5)
        'fr.ShowDialog()
        'MsgBox(fr.myscore)
        Select Case LCase(game)
            Case "picgrid"
                Dim f As New PicGrid
                f.ShowDialog()
            Case "riflerange"
                Dim f As New RifleRange
                f.ShowDialog()

            Case Else
                For i As Integer = 1 To 4
                    Dim fr As New Question(25)
                    If fr.Terminate = True Then i = 999
                    fr.ShowDialog()
                    fr.Dispose()
                    Dim f As New FrmScore
                    f.Show()
                    f.Dispose()

                    'MsgBox(fr.myscore)
                Next
        End Select

        ncoreSetIniValue(IniType.IniUser, inifile, "QFormX", qformx)
        ncoreSetIniValue(IniType.IniUser, inifile, "QFormY", qformy)

        savescores()

    End Sub
    Public Sub colorlabel(ByVal labelx)
        Dim colord As Integer = Int(Rnd() * 6)
        Select Case colord
            Case 0
                labelx.ForeColor = Color.Magenta

            Case 1
                labelx.ForeColor = Color.Yellow
            Case 2
                labelx.ForeColor = Color.Cyan
            Case 3
                labelx.ForeColor = Color.Red
            Case 4
                labelx.ForeColor = Color.Lime
            Case 5
                labelx.ForeColor = Color.DeepSkyBlue
        End Select
    End Sub
    Public Sub savescores()
        If File.Exists(WordFile + ".scores") Then
            If File.Exists(WordFile + ".scores.bak") Then File.Delete(WordFile + ".scores.bak")
            Rename(WordFile + ".scores", WordFile + ".scores.bak")
        End If
        Dim sw As New System.IO.StreamWriter(WordFile + ".scores", False, System.Text.Encoding.Unicode)
        For i = 1 To MaxData
            '  If DataScore(i) <> 0 Then
            sw.WriteLine(DataK(i) + "\" + CStr(DataScore(i)) + "\" + DataEg(i) + "\" + CStr(DataEgCount(i)))
            'End If
        Next
        sw.Close()
        If File.Exists(WordFile + ".scores.bak") Then File.Delete(WordFile + ".scores.bak")
    End Sub
    Public Sub loadFile(ByVal filen As String, Optional ByVal downgrade As Boolean = False, Optional ByVal import As Boolean = False)
        If WordFile = "" Then
            WordFile = filen
          
        End If

        ' set the hotkey:
        'Dim htk As HotKey = New HotKey("My HotKey", Keys.Up, HotKey.HotKeyModifiers.MOD_CONTROL Or HotKey.HotKeyModifiers.MOD_SHIFT)

        Dim sr As New System.IO.StreamReader(filen)
        While sr.Peek >= 0
            Dim lin As String = Trim(sr.ReadLine)
            If Len(lin) > 0 And leftstr(lin, 1) <> "'" Then
                Dim kanjiword As String = Trim(NCoreGetItem(lin, "(", 0))
                Dim hiraganaword As String = Trim(ncoregetbetween(lin, "(", ")"))
                Dim englishword As String = Trim(NCoreGetItem(lin, ":", 2)) + Trim(NCoreGetItem(lin, ":", 3))

                If InStr(lin, ":") = 0 Then
                    lin = sr.ReadLine
                    englishword = Trim(Replace(Replace(lin, "Meaning:", ""), ":", ""))

                End If
                Dim newword As Boolean = True

                For i = 1 To MaxData
                    If DataK(i) = kanjiword And DataH(i) = hiraganaword Then
                        newword = False
                        If downgrade = True Then DataScore(i) = DataScore(i) - 5
                    End If
                    'duplicate check
                Next
                If newword = True Then
                    MaxData = MaxData + 1
                    DataK(MaxData) = kanjiword
                    DataH(MaxData) = hiraganaword
                    DataE(MaxData) = leftstr(englishword, 60)
                    If import = True Then
                        Dim sw As New StreamWriter(WordFile, True, System.Text.Encoding.Unicode)
                        Dim lin2 As String = kanjiword + " (" + Trim(hiraganaword) + ") : " + Trim(englishword)
                        sw.WriteLine(lin2)
                        sw.Close()
                    End If
                End If
            End If

        End While
        sr.Close()
        Dim filen2 = filen + ".scores"
        If File.Exists(filen + ".scores.bak") Then filen2 = filen + ".scores.bak" : MsgBox("Recovering Backup Scores")
        '  MsgBox(filen2)
        If Dir(filen2) <> "" Then
            sr = New System.IO.StreamReader(filen2)
            Dim done As Boolean = False
            While sr.Peek >= 0
                Dim lin As String
                '   Try
                lin = sr.ReadLine
                'Catch ex As Exception
                'done = False
                '      MsgBox("error")
                'End Try
                If done = False Then


                    Dim finds As String = NCoreGetItem(lin, "\", 0)
                    '  MsgBox(lin, , MaxData)
                    For i = 0 To MaxData
                        ' MsgBox(i)
                        If Trim(DataK(i)) = Trim(finds) Then

                            DataScore(i) = Val(NCoreGetItem(lin, "\", 1))
                            'MsgBox("got here")
                            DataEg(i) = leftstr(NCoreGetItem(NCoreGetItem(lin, "\", 2), Chr(9), 0), 60)
                            'MsgBox("got here2")
                            '  MsgBox(Val(NCoreGetItem(lin, "\", 3)))
                            DataEgCount(i) = Val(NCoreGetItem(lin, "\", 3))
                            'MsgBox("got here3")
                            If DataScore(i) < -20 Then DataScore(i) = -20
                            If DataScore(i) > 20 Then DataScore(i) = 20
                        End If

                    Next

                End If

                ' MsgBox(done)
            End While
            sr.Close()
        End If



    End Sub
End Module

