﻿Imports System.IO
Public Class MouseFlash

    Private ContextMenu1 = New System.Windows.Forms.ContextMenu
    Dim btf As Integer = 1
    Dim position As Integer = 1

    Dim answernum As Integer = 0
    Dim flashcount As Integer = 0 ' we can flicker the flashcard to make it noticable

    ' check how busy the pc is to see if we can waste some cpu
    '   Dim cpuusage As New System.Diagnostics.PerformanceCounter("Processor", "% Processor Time", "_Total")

    Dim mytransp As Single
    Dim plast As Point
    Dim needquiz As Boolean = False
    Dim autosave As Integer = 0
    Dim lastmove As Integer = 0
    Dim bbord As Integer = 3

    'we can use threads to lookup examples
    Dim threadans As Integer = -1
    Dim Thread1 As System.Threading.Thread
    Dim lastheight As Integer
    Dim mybmp As Bitmap = New Bitmap(320, 240, Imaging.PixelFormat.Format32bppArgb)
   
    Private Function abs(ByVal a)
        If a < 0 Then abs = -a Else abs = a
    End Function
    Private Sub TmrCursorMove_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TmrCursorMove.Tick
        ' move the flashcard to the curent cursor location
        If abs(plast.X - Cursor.Position.X) > 5 Or abs(plast.Y - Cursor.Position.Y) > 5 Then
            If needquiz = True Then
                needquiz = False
                TestMe()
                TestTimer.Enabled = True
            End If
            lastmove = 0
        Else
            If lastmove < 100000 Then lastmove = lastmove + 1
        End If
        plast = Cursor.Position
        Dim p As New Point
        Select Case position
            Case 1
                p.X = Cursor.Position.X + 10
                p.Y = Cursor.Position.Y + 10
            Case 2
                p.X = Cursor.Position.X + 10
                p.Y = Cursor.Position.Y - (Me.Height + 10)
            Case 3
                p.X = Cursor.Position.X - (Me.Width + 10)
                p.Y = Cursor.Position.Y + 10
            Case 4
                p.X = Cursor.Position.X - (Me.Width + 10)
                p.Y = Cursor.Position.Y - (Me.Height + 10)
            Case 5
                p = Nothing
            Case 6

                p = Me.Location
                If p.X < Cursor.Position.X - 200 Then p.X = Cursor.Position.X - 200
                If p.X > Cursor.Position.X + 200 Then p.X = Cursor.Position.X + 200
                If p.Y < Cursor.Position.Y - 200 Then p.Y = Cursor.Position.Y - 200
                If p.Y > Cursor.Position.Y + 200 Then p.Y = Cursor.Position.Y + 200

                If p.X < Cursor.Position.X - 50 Then p.X = p.X + 1
                If p.X > Cursor.Position.X + 50 Then p.X = p.X - 1
                If p.Y < Cursor.Position.Y - 50 Then p.Y = p.Y + 1
                If p.Y > Cursor.Position.Y + 50 Then p.Y = p.Y - 1
        End Select
        If position <> 5 Then Me.Location = p

    End Sub

    Private Sub MouseFlash_ContextMenuStripChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.ContextMenuStripChanged

    End Sub

    Private Sub MouseFlash_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        TmrCursorMove_Tick(sender, e)
        ncoreSetIniValue(IniType.IniGlobal, inifile, "Language", CStr(mylanguage))
        ncoreSetIniValue(IniType.IniGlobal, inifile, "Opacity", CStr(mytransp))
        ncoreSetIniValue(IniType.IniGlobal, inifile, "Timer", CStr(TmrCursorMove.Interval))
        ncoreSetIniValue(IniType.IniGlobal, inifile, "Update", CStr(TmrNewWord.Interval))
        ncoreSetIniValue(IniType.IniGlobal, inifile, "Position", CStr(position))
        ncoreSetIniValue(IniType.IniGlobal, inifile, "Fontscale", CStr(fontscale))
        ncoreSetIniValue(IniType.IniGlobal, inifile, "Flashing", CStr(flashing))

        ncoreSetIniValue(IniType.IniGlobal, inifile, "quizlength", CStr(quizlength))

        If TestTimer.Enabled = True Then
            ncoreSetIniValue(IniType.IniGlobal, inifile, "TestTimer", CStr(TestTimer.Interval / (60 * 1000)))
        Else
            ncoreSetIniValue(IniType.IniGlobal, inifile, "TestTimer", "-1")
        End If


        NotifyIcon1.Visible = False

        'save our scores
        savescores()
        'removehk(Me)
    End Sub
    Public Sub savescores()
        If File.Exists(WordFile + ".scores") Then
            If File.Exists(WordFile + ".scores.bak") Then File.Delete(WordFile + ".scores.bak")
            Rename(WordFile + ".scores", WordFile + ".scores.bak")
        End If
        Dim sw As New System.IO.StreamWriter(WordFile + ".scores", False, System.Text.Encoding.Unicode)
        For i = 1 To MaxData
            sw.WriteLine(DataK(i) + "\" + CStr(DataScore(i)) + "\" + DataEg(i) + "\" + CStr(DataEgCount(i)))
        Next
        sw.Close()

        If File.Exists(WordFile + ".scores.bak") Then File.Delete(WordFile + ".scores.bak")
    End Sub
    Public Sub loadFile(ByVal filen As String, Optional ByVal downgrade As Boolean = False, Optional ByVal import As Boolean = False)
        If WordFile = "" Then
            WordFile = filen
            'dohotkeys(Me)
        End If

        ' hotkeys were removed during linux Mono testing, they also seemed to cause problems with windows 8
        ' set the hotkey:
        'Dim htk As HotKey = New HotKey("My HotKey", Keys.Up, HotKey.HotKeyModifiers.MOD_CONTROL Or HotKey.HotKeyModifiers.MOD_SHIFT)

        Dim sr As New System.IO.StreamReader(filen)
        While sr.Peek >= 0
            Dim lin As String = Trim(sr.ReadLine)
            If Len(lin) > 0 And leftstr(lin, 1) <> "'" Then
                Dim kanjiword As String = Trim(NCoreGetItem(lin, "(", 0))
                Dim hiraganaword As String = Trim(ncoregetbetween(lin, "(", ")"))
                Dim englishword As String = Trim(NCoreGetItem(lin, ":", 2)) + Trim(NCoreGetItem(lin, ":", 3))

                If InStr(lin, ":") = 0 Then
                    lin = sr.ReadLine
                    englishword = Trim(Replace(Replace(lin, "Meaning:", ""), ":", ""))

                End If
                Dim newword As Boolean = True

                For i = 1 To MaxData
                    If DataK(i) = kanjiword And DataH(i) = hiraganaword Then
                        newword = False
                        If downgrade = True Then DataScore(i) = DataScore(i) - 5
                    End If
                    'duplicate check
                Next
                If newword = True Then
                    MaxData = MaxData + 1
                    DataK(MaxData) = kanjiword
                    DataH(MaxData) = hiraganaword
                    DataE(MaxData) = leftstr(englishword, 60)
                    If import = True Then
                        Dim sw As New StreamWriter(WordFile, True, System.Text.Encoding.Unicode)
                        Dim lin2 As String = kanjiword + " (" + Trim(hiraganaword) + ") : " + Trim(englishword)
                        sw.WriteLine(lin2)
                        sw.Close()
                    End If
                End If
            End If

        End While
        sr.Close()
        Dim filen2 = filen + ".scores"

        ' looks like we had a crash!
        If File.Exists(filen + ".scores.bak") Then filen2 = filen + ".scores.bak" : MsgBox("Recovering Backup Scores")
        If Dir(filen2) <> "" Then
            sr = New System.IO.StreamReader(filen2)
            Dim done As Boolean = False
            While sr.Peek >= 0
                Dim lin As String
                lin = sr.ReadLine
                If done = False Then

                    ' scores are matched by kanji, and also hold examples
                    ' format is
                    ' kanji\score\example
                    Dim finds As String = NCoreGetItem(lin, "\", 0)
                    For i = 0 To MaxData
                        If Trim(DataK(i)) = Trim(finds) Then

                            DataScore(i) = Val(NCoreGetItem(lin, "\", 1))
                            DataEg(i) = leftstr(NCoreGetItem(NCoreGetItem(lin, "\", 2), Chr(9), 0), 60)
                            DataEgCount(i) = Val(NCoreGetItem(lin, "\", 3))
                            If DataScore(i) < -20 Then DataScore(i) = -20

                        End If

                    Next

                End If

                ' MsgBox(done)
            End While
            sr.Close()
        End If

    End Sub
   

    Private Sub textrefresh()
        Me.Width = 0
        Me.Height = 0
        If position = 5 Then 'Or lastmove > 3000 Then
            Dim p As New Point
            ' My.Computer.Screen.WorkingArea.Width

            p.X = Rnd() * (Screen.PrimaryScreen.WorkingArea.Width - 80 * fontscale)
            p.Y = Rnd() * (Screen.PrimaryScreen.WorkingArea.Height - 40 * fontscale)
            Me.Location = p
        End If
        Me.SuspendLayout()


        ' find our answer, weighted by how often it was got wrong.
        Dim ans As Integer
        ans = Int(Rnd() * (MaxData + 1))
        Dim ii As Integer = 0
        Dim aa As Integer = 0
        While ii < (MaxData / 20) And DataScore(ans) >= -(20 - ii)
            ' ii = ii + 1
            aa = aa + 1
            If aa = 2 Then aa = 0 : ii = ii + 1
            ans = Int(Rnd() * (MaxData + 1))
        End While
        'If lastmove > 3000 And threadans = -1 And cpuusage.NextValue < 50 And (SystemInformation.PowerStatus.PowerLineStatus <> PowerLineStatus.Offline) Then
        '    threadans = ans
        '    Thread1 = New System.Threading.Thread(AddressOf findeg)
        '    Thread1.Start()
        'End If

        Dim i As Integer = ans
        answernum = ans
        Dim font1 = New Font("Microsoft Sans Serif", 15.75 * fontscale)
        '  Label1.Text = DataK(i) + " "


        Dim g As Graphics = Drawing.Graphics.FromImage(mybmp)
        g.TextRenderingHint = Drawing.Text.TextRenderingHint.SingleBitPerPixelGridFit
        PictureBox1.Width = mybmp.Width
        PictureBox1.Height = mybmp.Height

        clearbmp(lastheight)
        Dim line As String = ""
        Select Case mylanguage
            Case 1 'kanji first
                line = DataK(answernum)

            Case 2 'kana first
                line = DataH(answernum)

            Case 3 'english first
                line = engtrim(DataE(answernum))

        End Select
        g.DrawString(line, font1, New SolidBrush(randomcolor), 3, 3)
        shadeborder(font1.Height)
        Me.Width = g.MeasureString(line, font1).Width + 10
        Me.Height = font1.Height + 5
        PictureBox1.Image = mybmp

        PictureBox1.Refresh()
        PictureBox1.Visible = True


        Try 'opcaity can mess on xp when coming out of sleep mode
            Me.Opacity = 1
        Catch ex As Exception

        End Try


        flashcount = 30


        TimerFlash.Enabled = True
        'btf = btf + 1
        If lastmove > 30000 Then

            Me.BringToFront()
            btf = 1
        End If
        Me.ResumeLayout()

    End Sub

    Private Sub MouseFlash_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        Me.TopMost = True

        PopupAdd("Transparency / 透明さ\100%\75%\50%\25%", ContextMenu1)

        ' move speed is deprecated, I added it as I was concerned about wasting cpu power
        ' however I've never seen a time it's slowed down a machine, so what's the point?
        'PopupAdd("Move Speed / 動き速度\10ms\30ms\50ms\100ms\1s", ContextMenu1)
        PopupAdd("Update / 更新\2sec\3sec\5sec\10sec\20sec\30sec\60sec", ContextMenu1)
        PopupAdd("Language / 国語\1-Kanji\2-Kana\3-English", ContextMenu1)
        PopupAdd("Location / 場所\Below\Above\Left-below\Left-Above\Random\Chase", ContextMenu1)
        PopupAdd("Font / 文字\1x\1.5x\2x\2.5x\3x\4x\8x\16x", ContextMenu1)
        PopupAdd("RetestBias / 失敗差別\R0\R1\R2\R3\R4", ContextMenu1)
        PopupAdd("TestTimer / 試験時間\1Min\2Mins\3Mins\5Mins\10Mins\15Mins\30Mins\60Mins\Off", ContextMenu1)
        PopupAdd("TestLength / 試験長さ\2Q\4Q\6Q\8Q\10Q", ContextMenu1)
        PopupAdd("Advanced / 管理\HeavyDrillRange\Import\BringToFront\Flashing", ContextMenu1)
        PopupAdd("Test Me / 試験", ContextMenu1)
        PopupAdd("Ticker / チッカー", ContextMenu1)
        PopupAdd("Dictionary / 辞典", ContextMenu1)
        PopupAdd("Add New Word / 新言葉を登録", ContextMenu1)
        PopupAdd("About / 情報", ContextMenu1)
        PopupAdd("Close / 終了", ContextMenu1)
        NotifyIcon1.ContextMenu = ContextMenu1
        mytransp = NCoreGetIniValue(inifile, "Opacity", 0.75)
        mylanguage = NCoreGetIniValue(inifile, "Language", 1)
        TmrCursorMove.Interval = NCoreGetIniValue(inifile, "Timer", 50)
        TmrNewWord.Interval = NCoreGetIniValue(inifile, "Update", 5000)
        position = NCoreGetIniValue(inifile, "Position", 1)
        fontscale = NCoreGetIniValue(inifile, "fontscale", 1)
        flashing = NCoreGetIniValue(inifile, "flashing", 0)
        nothreads = NCoreGetIniValue(inifile, "nothreads", 1)
        quizlength = NCoreGetIniValue(inifile, "quizlength", 2)
        If NCoreGetIniValue(inifile, "TestTimer", 15) > -1 Then
            TestTimer.Interval = 60 * 1000 * NCoreGetIniValue(inifile, "TestTimer", 15)
            TestTimer.Enabled = True
        End If
        Randomize()


        Dim args As String() = Environment.GetCommandLineArgs()
        If Not args Is Nothing Then
            Try
                If args.GetUpperBound(0) > 0 Then

                    loadFile(args(1))
                Else
                    MsgBox("No wordlist specified, you should pass a filename as an argument, if you are making a new wordlist, please create a blank text file")
                    End
                End If
            Catch ex As Exception

            End Try

        End If

        textrefresh()
    End Sub

    Private Sub PopupAdd(ByVal lin As String, ByVal contextmenu1 As ContextMenu)
        'A quick sub to add lines to our popup.
        'Lin is the item(s) to add, 
        'using a \ creates a submenu.

        If InStr(lin, "\") > 0 Then
            ' this is a tiered menu
            Dim MenuItem1 As MenuItem
            'add the root menu
            MenuItem1 = New System.Windows.Forms.MenuItem
            MenuItem1.Text = NCoreGetItem(lin, "\", 0)
            contextmenu1.MenuItems.Add(MenuItem1)

            For i As Integer = 1 To NcoreCountItems(lin, "\")

                'add each of the sub menus
                Dim MenuItem2 As MenuItem
                MenuItem2 = New System.Windows.Forms.MenuItem
                MenuItem2.Text = NCoreGetItem(lin, "\", i)
                MenuItem1.MenuItems.Add(MenuItem2)
                AddHandler MenuItem2.Click, AddressOf Generic_MenuHandler
            Next

        Else
            'single menu
            Dim MenuItem1 As MenuItem
            MenuItem1 = New System.Windows.Forms.MenuItem
            MenuItem1.Text = lin

            contextmenu1.MenuItems.Add(MenuItem1)
            AddHandler MenuItem1.Click, AddressOf Generic_MenuHandler
        End If


    End Sub
    Sub TestMe()

        If TestTimer.Enabled = False Then Exit Sub
        DrillTimer.Enabled = False
        TestTimer.Enabled = False


        If autosave >= 10 Then
            autosave = 0
            savescores()
        End If
        autosave = autosave + 1

        Me.Visible = False
        Dim q As New FrmQuizTime(quizlength)
        q.ShowDialog()

        Try
            Me.Visible = True
        Catch ex As Exception

        End Try
        DrillTimer.Enabled = True
        TestTimer.Enabled = True
    End Sub
    Sub DrillMe()
        If TestTimer.Enabled = False Then Exit Sub
        Dim problemw As Integer = -1

        'if a word has a score of -19 or -20 we force the user to answer it again
        For i = 1 To MaxData
            If DataScore(i) <= -19 Then problemw = i
        Next

        If problemw <= 0 Then Exit Sub
        TestTimer.Enabled = False
        DrillTimer.Enabled = False

        'save the score every 10 questions so we don't lose progres if there's a crash
        If autosave >= 10 Then
            autosave = 0
            savescores()
        End If
        autosave = autosave + 1

        Me.Visible = False
        Dim q As New FrmQuizTime(2, problemw)
        q.ShowDialog()

        Try
            Me.Visible = True
        Catch ex As Exception

        End Try
        DrillTimer.Enabled = True
        TestTimer.Enabled = True
    End Sub

    Public Sub Generic_MenuHandler(ByVal sender As Object, ByVal e As System.EventArgs)
        'something was clicked on, look at the name of the menu, and perform the action.
        ' this is a quick dirty way of making and handling a popup menu
        Dim c As ContextMenu
        Select Case LCase(NCoreGetItem(sender.Parent.GetType.ToString, ".", NcoreCountItems(sender.Parent.GetType.ToString, ".")))

            Case "contextmenu"
                c = sender.Parent()
            Case "menuitem"
                c = sender.Parent.parent()
        End Select

        ' we ignore all but the english part when looking up a name
        Select Case LCase(Trim(NCoreGetItem(sender.text, "/", 0)))
            Case "import"
                Dim d As New OpenFileDialog
                d.Filter = "All files (*.*)|*.*"
                d.ShowDialog()
                If d.FileName <> "" Then
                    loadFile(d.FileName, True, True)
                End If
            Case "2q"
                quizlength = 2
            Case "4q"
                quizlength = 4
            Case "6q"
                quizlength = 6
            Case "8q"
                quizlength = 8
            Case "heavydrillrange"
                minprob = CInt(InputBox("Minimum Heavy Drill", , "-999"))
                maxprob = CInt(InputBox("Maximum Heavy Drill", , "999"))
            Case "10q"
                quizlength = 10
            Case "bringtofront"
                Me.BringToFront()


                'retest bias increases or decreases the amount of time 
                ' the quiz spends looking for words the player is particularly bad at.
            Case "r0"
                retestbias = 0
            Case "r1"
                retestbias = 1
            Case "r2"
                retestbias = 2
            Case "r3"
                retestbias = 3
            Case "r4"
                retestbias = 4
            Case "add new word"
                Dim f As New frmNewWord
                f.Show()
            Case "flashing"
                flashing = 1 - flashing
            Case "dictionary"
                If Not File.Exists("edict") Then MsgBox("Can't find Edict!") : Exit Sub
                If mysearch Is Nothing Then
                    Dim f As New frmSearch
                    mysearch = f
                End If
                mysearch.Show()
                mysearch.BringToFront()
                mysearch.Focus()
            Case "1min"
                TestTimer.Interval = 60 * 1000 * 1
                TestTimer.Enabled = True
            Case "2mins"
                TestTimer.Interval = 60 * 1000 * 2
                TestTimer.Enabled = True
            Case "3mins"
                TestTimer.Interval = 60 * 1000 * 3
                TestTimer.Enabled = True
            Case "5mins"
                TestTimer.Interval = 60 * 1000 * 5
                TestTimer.Enabled = True
            Case "10mins"
                TestTimer.Interval = 60 * 1000 * 10
                TestTimer.Enabled = True
            Case "15mins"
                TestTimer.Interval = 60 * 1000 * 15
                TestTimer.Enabled = True
            Case "30mins"
                TestTimer.Interval = 60 * 1000 * 30
                TestTimer.Enabled = True
            Case "60mins"
                TestTimer.Interval = 60 * 1000 * 60
            Case "off"
                TestTimer.Enabled = False
            Case "test me"
                TestMe()
            Case "ticker"
                Dim f As New FrmTicker
                f.Show()
            Case "close"
                Close()
            Case "1-kanji"
                mylanguage = 1
            Case "2-kana"
                mylanguage = 2
            Case "3-english"
                mylanguage = 3
            Case "100%"
                mytransp = 1
            Case "75%"
                mytransp = 0.75
            Case "50%"
                mytransp = 0.5
            Case "25%"
                mytransp = 0.25
                'move speed is obsolete
                'Case "10ms"
                '    TmrCursorMove.Interval = 10
                'Case "30ms"
                '    TmrCursorMove.Interval = 30
                'Case "50ms"
                '    TmrCursorMove.Interval = 50
                'Case "100ms"
                '    TmrCursorMove.Interval = 100
                'Case "1s"
                '    TmrCursorMove.Interval = 1000
            Case "1sec"
                TmrNewWord.Interval = 1000
            Case "2sec"
                TmrNewWord.Interval = 2000
            Case "3sec"
                TmrNewWord.Interval = 3000
            Case "5sec"
                TmrNewWord.Interval = 5000
            Case "10sec"
                TmrNewWord.Interval = 10000
            Case "20sec"
                TmrNewWord.Interval = 20000
            Case "30sec"
                TmrNewWord.Interval = 30000
            Case "60sec"
                TmrNewWord.Interval = 60000
            Case "about"
                ' show a crude line chart of the scores of the user.
                Dim scores(80) As Integer
                Dim totalscore As Single

                For i = 1 To MaxData
                    Dim a As String = DataScore(i)
                    a = a + 20
                    If a < 0 Then a = 0
                    If a > 80 Then a = 40
                    scores(a) = scores(a) + 1
                    totalscore = totalscore + DataScore(i)
                Next
                Dim lin As String = "Wordlist size " + CStr(MaxData) + " - "
                Dim min, max As Integer
                min = 50
                max = 0
                For I = 0 To 80
                    If scores(I) > 0 And I < min Then min = I
                    If scores(I) > 0 And I > max Then max = I
                Next

                If MaxData > 0 Then
                    lin = lin + "Average Score " + CStr(totalscore / MaxData) + Chr(13) + Chr(10)
                End If
                'lin = lin + Chr(13) + Chr(10)
                For I = min To max

                    If (I - 20) > -10 And (I - 20) < 10 Then lin = lin + " "
                    lin = lin + leftstr(CStr(I - 20) + "    ", 3) + ":"
                    If scores(I) > 0 Then lin = lin + "|"
                    For a As Integer = 1 To Int(scores(I) * 600 / MaxData)
                        lin = lin + "|"

                    Next
                    If scores(I) > 0 Then lin = lin + "     " + CStr(scores(I)) + ""
                    lin = lin + Chr(13) + Chr(10)
                Next
                Dim f As New frmInfo(lin)
                f.Show()

            Case "below"
                position = 1
            Case "above"
                position = 2
            Case "left-below"
                position = 3
            Case "left-above"
                position = 4
            Case "random"
                position = 5
            Case "chase"
                position = 6
            Case "1x"
                fontscale = 1
            Case "1.5x"
                fontscale = 1.5
            Case "2x"
                fontscale = 2
            Case "2.5x"
                fontscale = 2.5
            Case "3x"
                fontscale = 3
            Case "4x"
                fontscale = 4
            Case "8x"
                fontscale = 8
            Case "16x"
                fontscale = 16
        End Select
    End Sub

    Private Sub TmrNewWord_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TmrNewWord.Tick
        textrefresh()
    End Sub

    Private Sub TimerFlash_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TimerFlash.Tick
        Try 'opcaity can mess on xp when coming out of sleep mode
            Me.Opacity = mytransp '+ 0.5
        Catch ex As Exception

        End Try

        If flashing = 1 Then


            Dim font1 = New Font("Microsoft Sans Serif", 15.75 * fontscale)
            Dim g As Graphics = Drawing.Graphics.FromImage(mybmp)
            Dim line As String = ""
            Select Case mylanguage
                Case 1 'kanji first
                    line = DataK(answernum)

                Case 2 'kana first
                    line = DataH(answernum)

                Case 3 'english first
                    line = engtrim(DataE(answernum))

            End Select

            g.DrawString(line, font1, New SolidBrush(randomcolor), 3, 3)

            PictureBox1.Refresh()

        End If

        If flashcount > 0 Then
            flashcount = flashcount - 1
        Else
            Me.Width = 0
            Me.Height = 0
            Dim formwidth As Integer = 0
            Dim g As Graphics = Drawing.Graphics.FromImage(mybmp)

            clearbmp(lastheight)

            Dim line(3) As String
            Select Case mylanguage
                Case 1 'kanji first
                    line(0) = DataK(answernum)
                    line(1) = DataH(answernum)
                    line(2) = DataE(answernum)
                Case 2 'kana first
                    line(0) = DataH(answernum)
                    line(1) = DataK(answernum)
                    line(2) = DataE(answernum)
                Case 3 'english first
                    line(0) = engtrim(DataE(answernum))
                    line(1) = DataK(answernum)
                    line(2) = DataH(answernum)
            End Select


            Dim font1 As Font = New Font("Microsoft Sans Serif", 8.25 * fontscale)
            Dim font2 As Font = New Font("Microsoft Sans Serif", 6 * fontscale)
            g.TextRenderingHint = Drawing.Text.TextRenderingHint.SingleBitPerPixelGridFit


            g.DrawString(line(0), font1, New SolidBrush(randomcolor), 3, 3)
            g.DrawString(line(1), font1, New SolidBrush(randomcolor), 3, 3 + font1.Height)
            g.DrawString(line(2), font1, New SolidBrush(randomcolor), 3, 3 + font1.Height * 2)
            Dim eg As String = NCoreGetItem(DataEg(answernum), Chr(9), 0)

            ' work out the longest of the words we will show
            If g.MeasureString(line(0), font1).Width > formwidth Then formwidth = g.MeasureString(line(0), font1).Width
            If g.MeasureString(line(1), font1).Width > formwidth Then formwidth = g.MeasureString(line(1), font1).Width
            If g.MeasureString(line(2), font1).Width > formwidth Then formwidth = g.MeasureString(line(2), font1).Width
            If g.MeasureString(eg, font2).Width > formwidth Then formwidth = g.MeasureString(eg, font2).Width
            If formwidth > 320 Then formwidth = 320
            If g.MeasureString(eg, font2).Width > 310 Then
                '   formwidth = 320
                Dim bestlen As Integer = 0
                For i = Len(eg) To 1 Step -1
                    If g.MeasureString(leftstr(eg, i), font2).Width < 300 And bestlen = 0 Then bestlen = i
                Next
                eg = leftstr(eg, bestlen) + Chr(13) + Chr(10) + rightstr(eg, Len(eg) - bestlen)
            End If

            If mylanguage < 3 Then g.DrawString(eg, font2, New SolidBrush(randomcolor), 3, 3 + font1.Height * 3)


            Dim mMy As Integer = font1.Height * 3 + font2.Height * 2
            If mMy > 240 - 3 Then mMy = 240 - 3
            shadeborder(mMy + 1)
            Me.Width = formwidth
            Me.Height = mMy + 5

            PictureBox1.Image = mybmp
            PictureBox1.Refresh()

            PictureBox1.Visible = True
            PictureBox1.BringToFront()
            TimerFlash.Enabled = False
            If mysearch Is Nothing Then Me.Visible = True

        End If
    End Sub
    Private Sub shadeborder(ByVal mmy As Integer)
        'fills in a black outline around the text
        'the outline is sometimes a bit cruddy
        'this is becase to save cpu time we only approximate the edge of the text
        Dim a As Integer = mytransp * 255
        If a > 255 Then a = 255

        For y = 1 To mmy
            For x = 1 To 319 - bbord

                Dim p As Color = mybmp.GetPixel(x, y)


                If p.A > 0 And (p.R > 0 Or p.G > 0 Or p.B > 0) Then
                    Dim ymin As Integer = y - bbord
                    Dim ymax As Integer = y + bbord

                    p = mybmp.GetPixel(x, y - 1)
                    If p.A > 0 And (p.R > 0 Or p.G > 0 Or p.B > 0) Then ymin = y - 1
                    p = mybmp.GetPixel(x, y + 1)
                    If p.A > 0 And (p.R > 0 Or p.G > 0 Or p.B > 0) Then ymax = y + 1

                    For ax = x - bbord To x + bbord
                        For ay = ymin To ymax
                            Dim p2 As Color = mybmp.GetPixel(ax, ay)
                            If p2.A = 0 Then mybmp.SetPixel(ax, ay, Color.Black)
                        Next
                    Next
                    x = x + bbord / 2
                End If

            Next
        Next
        lastheight = mmy
    End Sub
    Private Sub clearbmp(ByVal mmy As Integer)
   

        Dim g As Graphics = Drawing.Graphics.FromImage(mybmp)
        g.SetClip(New RectangleF(0, 0, 320, mmy + 1 + bbord))
        'g.FillRectangle(New SolidBrush(Color.Transparent`, 0, 0, 320, mmy + 1 + bbord)

        ' transparent clear doesn't work on linux, so clear to black first
        g.Clear(Color.Black)
        'g.Clear(Color.FromArgb(1, 0, 0, 0))
        g.Clear(Color.Transparent)
    End Sub

    Private Sub MouseFlash_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseMove
        If Me.FormBorderStyle = Windows.Forms.FormBorderStyle.None Then

            Dim p As Point
            p.X = Cursor.Position.X + 10
            p.Y = Cursor.Position.Y + 10
            Me.Location = p
        End If
    End Sub

    Private Sub Label1_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Label1.MouseMove
        MouseFlash_MouseMove(sender, e)
    End Sub

    Private Sub Label2_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Label2.MouseMove
        MouseFlash_MouseMove(sender, e)
    End Sub

    Private Sub Label3_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Label3.MouseMove
        MouseFlash_MouseMove(sender, e)
    End Sub

    Private Sub TestTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TestTimer.Tick
        needquiz = True

        Beep()
    End Sub

    Private Sub NotifyIcon1_MouseDoubleClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles NotifyIcon1.MouseDoubleClick
        TestMe()
    End Sub

    Private Sub DrillTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DrillTimer.Tick
        DrillTimer.Enabled = False
        DrillMe()
        DrillTimer.Enabled = True
    End Sub

End Class
