/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mrsp;

import java.net.URL;
import java.util.List;
import jp.sourceforge.mrsp.ArtifactViewerSorter;
import jp.sourceforge.mrsp.MavenRepoSearchPlugin;
import jp.sourceforge.mrsp.ResultContentProvider;
import jp.sourceforge.mrsp.ResultLabelProvider;
import jp.sourceforge.mrsp.model.Artifact;
import jp.sourceforge.mrsp.model.Result;
import jp.sourceforge.mrsp.service.RepoSearchService;
import jp.sourceforge.mrsp.service.RepoSearchServiceException;
import jp.sourceforge.mrsp.service.RepoSearchServiceImpl;
import jp.sourceforge.mrsp.util.MavenDependencyTagMaker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class ResultView
extends ViewPart {
    private TableViewer viewer;
    private Action searchAction;
    private Action jumpRepositoryAction;
    private Action copyDependencyAction;
    private Text queryText;
    private RepoSearchService searchService;
    private Result result;
    private boolean isSearching;

    public void setFocus() {
        this.queryText.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.viewer = null;
        this.searchAction = null;
        this.jumpRepositoryAction = null;
        this.copyDependencyAction = null;
        this.searchService = null;
        this.result = null;
    }

    public void createPartControl(Composite parent) {
        this.setPartName("MavenRepoSearch");
        GridLayout gridLayout = new GridLayout(1, true);
        parent.setLayout((Layout)gridLayout);
        this.queryText = new Text(parent, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.queryText.setLayoutData((Object)gridData);
        this.queryText.setToolTipText(MavenRepoSearchPlugin.getResourceString("queryTextToolTip"));
        Table table = this.createTable(parent);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ResultContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResultLabelProvider());
        this.searchService = new RepoSearchServiceImpl();
        this.result = new Result();
        this.viewer.setInput((Object)this.result);
        this.createActions();
        this.createContextMenu();
        this.hookActions();
    }

    private Table createTable(Composite parent) {
        Table table = new Table(parent, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column_0 = new TableColumn(table, 16384, 0);
        column_0.setText("groupId");
        column_0.setWidth(80);
        column_0.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultView.this.viewer.setSorter((ViewerSorter)new ArtifactViewerSorter(1));
            }
        });
        TableColumn column_1 = new TableColumn(table, 16384, 1);
        column_1.setText("artifactId");
        column_1.setWidth(150);
        column_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultView.this.viewer.setSorter((ViewerSorter)new ArtifactViewerSorter(2));
            }
        });
        TableColumn column_2 = new TableColumn(table, 16384, 2);
        column_2.setText("version");
        column_2.setWidth(80);
        column_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultView.this.viewer.setSorter((ViewerSorter)new ArtifactViewerSorter(3));
            }
        });
        TableColumn column_3 = new TableColumn(table, 16384, 3);
        column_3.setText("type");
        column_3.setWidth(80);
        column_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultView.this.viewer.setSorter((ViewerSorter)new ArtifactViewerSorter(4));
            }
        });
        TableColumn column_4 = new TableColumn(table, 16384, 4);
        column_4.setText("repository");
        column_4.setWidth(250);
        column_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultView.this.viewer.setSorter((ViewerSorter)new ArtifactViewerSorter(5));
            }
        });
        return table;
    }

    private void createActions() {
        this.searchAction = new Action(){

            public void run() {
                ResultView.this.doSearch();
            }
        };
        this.jumpRepositoryAction = new Action(MavenRepoSearchPlugin.getResourceString("jumpRepositoryActionTitle")){

            public void run() {
                ISelection selection = ResultView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null) {
                    Artifact artifact = (Artifact)obj;
                    Program.launch((String)(String.valueOf(artifact.getRepoUrl()) + artifact.getGroupId() + "/"));
                }
            }
        };
        this.copyDependencyAction = new Action(MavenRepoSearchPlugin.getResourceString("copyDependencyActionTitle")){

            public void run() {
                ISelection selection = ResultView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null) {
                    Artifact artifact = (Artifact)obj;
                    Clipboard clipboard = new Clipboard(ResultView.this.viewer.getControl().getDisplay());
                    clipboard.setContents(new Object[]{MavenDependencyTagMaker.create(artifact)}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        };
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResultView.this.updateActionEnablement();
            }
        });
        this.jumpRepositoryAction.setEnabled(false);
        this.copyDependencyAction.setEnabled(false);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ResultView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IAction)this.copyDependencyAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.jumpRepositoryAction);
    }

    private void hookActions() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ResultView.this.jumpRepositoryAction.run();
            }
        });
        this.queryText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    ResultView.this.searchAction.run();
                }
            }
        });
    }

    private void updateActionEnablement() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        this.jumpRepositoryAction.setEnabled(sel.size() > 0);
        this.copyDependencyAction.setEnabled(sel.size() > 0);
    }

    private ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/";
        MavenRepoSearchPlugin plugin = MavenRepoSearchPlugin.getDefault();
        return ImageDescriptor.createFromURL((URL)plugin.find((IPath)new Path(String.valueOf(iconPath) + relativePath)));
    }

    private void doSearch() {
        if (this.queryText.getText().length() < 2 || this.isSearching) {
            return;
        }
        this.queryText.setEditable(false);
        this.isSearching = true;
        String keyword = this.queryText.getText();
        try {
            List artifacts = this.searchService.searchArtifactByKeyword(keyword);
            if (artifacts.size() > 0) {
                this.result.setArtifacts(artifacts);
            } else {
                this.showMessage(MavenRepoSearchPlugin.getResourceString("notFound"));
            }
        }
        catch (RepoSearchServiceException e) {
            MavenRepoSearchPlugin.log(e);
            this.showMessage(MavenRepoSearchPlugin.getResourceString("searchFail"));
        }
        this.queryText.setEditable(true);
        this.viewer.setSelection(null);
        this.viewer.getTable().setFocus();
        this.isSearching = false;
    }

    private void showMessage(String msg) {
        MessageDialog.openWarning((Shell)this.viewer.getControl().getShell(), (String)"Maven Repo Search", (String)msg);
    }
}

