/*
 * Created on 2004/09/23
 */
package jp.sourceforge.mrsp.parser;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.mrsp.model.Artifact;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * @author Ryuzo Yamamoto
 * @version $Id: ArtifactsHandler.java,v 1.1 2004/09/23 06:42:14 dragon3 Exp $
 */
public class ArtifactsHandler extends DefaultHandler {

    private List artifacts;

    private Artifact artifact;

    private String currentElement;

    public List getArtifacts() {
        return this.artifacts;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xml.sax.ContentHandler#characters(char[], int, int)
     */
    public void characters(char[] ch, int start, int length)
            throws SAXException {

        if (currentElement.equals("groupId")) {
            artifact.setGroupId(new String(ch, start, length));
        } else if (currentElement.equals("artifactId")) {
            artifact.setArtifactId(new String(ch, start, length));
        } else if (currentElement.equals("version")) {
            artifact.setVersion(new String(ch, start, length));
        } else if (currentElement.equals("type")) {
            artifact.setType(new String(ch, start, length));
        } else if (currentElement.equals("repository")) {
            artifact.setRepoUrl(new String(ch, start, length));
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xml.sax.ContentHandler#endElement(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public void endElement(String uri, String localName, String qName)
            throws SAXException {
        if (qName.equals("dependency")) {
            artifacts.add(artifact);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xml.sax.ContentHandler#startDocument()
     */
    public void startDocument() throws SAXException {
        this.artifacts = new ArrayList();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xml.sax.ContentHandler#startElement(java.lang.String,
     *      java.lang.String, java.lang.String, org.xml.sax.Attributes)
     */
    public void startElement(String uri, String localName, String qName,
            Attributes attributes) throws SAXException {

        if (qName.equals("dependency")) {
            artifact = new Artifact();
            currentElement = null;
        } else {
            currentElement = qName;
        }
    }
}