/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mrsp.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mrsp.model.Artifact;
import jp.sourceforge.mrsp.parser.ResponseParser;

public class HtmlResponseParser
implements ResponseParser {
    private static final Pattern artifactPattern = Pattern.compile("<tr[^>]*>[\\s]*<td>([^<]*)</td>[\\s]*<td>([^<]*)</td>[\\s]*<td>([^<]*)</td>[\\s]*<td>([^<]*)</td>[\\s]*<td>(ibiblio|<a href=\"[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+\">[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+</a>)</td>[\\s]*</tr>", 8);
    private static final Pattern repoUrlPattern = Pattern.compile("s?https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+");

    public List parse(Object o) {
        String s = (String)o;
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        Matcher matcher = artifactPattern.matcher(s);
        while (matcher.find()) {
            Artifact artifact = new Artifact();
            artifact.setGroupId(matcher.group(1));
            artifact.setArtifactId(matcher.group(2));
            artifact.setVersion(matcher.group(3));
            artifact.setType(matcher.group(4));
            if (matcher.group(5).equals("ibiblio")) {
                artifact.setRepoUrl("http://www.ibiblio.org/maven/");
            } else {
                Matcher repoUrlMatcher = repoUrlPattern.matcher(matcher.group(5));
                if (repoUrlMatcher.find()) {
                    artifact.setRepoUrl(repoUrlMatcher.group(0));
                }
            }
            list.add(artifact);
        }
        return list;
    }
}

