/*
 * Created on 2004/09/18
 */
package jp.sourceforge.mrsp.model;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.mrsp.ResultListener;

import org.eclipse.jface.util.ListenerList;

/**
 * @author Ryuzo Yamamoto
 * @version $Id: Result.java,v 1.6 2004/09/21 15:13:26 dragon3 Exp $
 */
public class Result {

    private List artifacts;

    private ListenerList listenerList = new ListenerList();

    public Result() {
        this.artifacts = new ArrayList();
    }

    /**
     * @return Returns the artifacts.
     */
    public List getArtifacts() {
        return artifacts;
    }

    /**
     * @param artifacts
     *            The artifacts to set.
     */
    public void setArtifacts(List artifacts) {
        this.artifacts = artifacts;
        Object[] listeners = listenerList.getListeners();
        for (int i = 0, n = listeners.length; i < n; i++) {
            ResultListener resultListener = (ResultListener) listeners[i];
            resultListener.artifactsUpdated(this);
        }
    }

    private void addArtifact(Artifact artifact) {
        artifacts.add(artifact);
        Object[] listeners = listenerList.getListeners();
        for (int i = 0, n = listeners.length; i < n; i++) {
            ResultListener resultListener = (ResultListener) listeners[i];
            resultListener.artifactAdded(artifact);
        }
    }

    private void removeArtifact(Artifact artifact) {
        artifacts.remove(artifact);
        Object[] listeners = listenerList.getListeners();
        for (int i = 0, n = listeners.length; i < n; i++) {
            ResultListener resultListener = (ResultListener) listeners[i];
            resultListener.artifactRemoved(artifact);
        }
    }

    public void addResultListener(ResultListener resultListener) {
        listenerList.add(resultListener);
    }

    public void removeResultLister(ResultListener resultListener) {
        listenerList.remove(resultListener);
    }
}