/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.api.gbase.client.ServiceError;
import com.google.gdata.data.HtmlTextConstruct;
import com.google.gdata.data.batch.BatchStatus;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlParser;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceErrors {
    private List<ServiceError> requestErrors = new ArrayList<ServiceError>();
    private List<ServiceError> dataErrors = new ArrayList<ServiceError>();
    private static final ContentType DEFAULT_CONTENT_TYPE = new ContentType("text/plain");

    public String toString() {
        StringBuffer retval = new StringBuffer();
        ServiceErrors.appendErrors(retval, this.requestErrors);
        ServiceErrors.appendErrors(retval, this.dataErrors);
        return retval.toString();
    }

    private static void appendErrors(StringBuffer retval, List<ServiceError> list) {
        for (ServiceError error : list) {
            if (retval.length() > 0) {
                retval.append(", ");
            }
            retval.append(error.toString());
        }
    }

    public ServiceErrors(ServiceException e) {
        this.addErrors(e);
    }

    public ServiceErrors(BatchStatus status) {
        this.addErrors(status);
    }

    public ServiceErrors() {
    }

    public void addErrors(ServiceException e) {
        this.addErrors(e.getMessage(), e.getResponseContentType(), e.getResponseBody());
    }

    public void addErrors(BatchStatus status) {
        this.addErrors(status.getReason(), status.getContentType(), status.getContent());
    }

    private void addErrors(String reason, ContentType contentType, String body) {
        if (body == null) {
            this.addError(new ServiceError(reason));
            return;
        }
        if (contentType == null) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        if (contentType.toString().startsWith("application/xml")) {
            try {
                XmlParser parser = new XmlParser();
                parser.parse(new StringReader(body), (XmlParser.ElementHandler)new ErrorsElementHandler(), "", "errors");
            }
            catch (IOException ioe) {
                this.addInvalidXmlServiceError(reason, body);
            }
            catch (ParseException pe) {
                this.addInvalidXmlServiceError(reason, body);
            }
        } else if (contentType.toString().startsWith("text/html")) {
            HtmlTextConstruct construct = new HtmlTextConstruct(body);
            this.addError(new ServiceError(construct.getPlainText()));
        } else {
            this.addError(new ServiceError(body));
        }
    }

    private void addInvalidXmlServiceError(String reason, String body) {
        this.addError(new ServiceError(reason + "(badly formatted xml error message: " + body));
    }

    public void addError(ServiceError error) {
        if ("data".equals(error.getType())) {
            this.dataErrors.add(error);
        } else {
            this.requestErrors.add(error);
        }
    }

    public List<? extends ServiceError> getAllErrors() {
        ArrayList<ServiceError> retval = new ArrayList<ServiceError>(this.requestErrors.size() + this.dataErrors.size());
        retval.addAll(this.requestErrors);
        retval.addAll(this.dataErrors);
        return retval;
    }

    public List<? extends ServiceError> getRequestErrors() {
        return this.requestErrors;
    }

    public Collection<? extends ServiceError> getDataErrors() {
        return this.dataErrors;
    }

    public Set<? extends String> getErrorFields() {
        HashSet<String> fields = new HashSet<String>();
        for (ServiceError error : this.dataErrors) {
            String field = error.getField();
            if (field == null) continue;
            fields.add(field);
        }
        return fields;
    }

    public List<? extends ServiceError> getFieldErrors(String field) {
        ArrayList<ServiceError> retval = new ArrayList<ServiceError>();
        for (ServiceError error : this.dataErrors) {
            if (!ServiceErrors.equalsMaybeNull(field, error.getField())) continue;
            if (retval == null) {
                retval = new ArrayList();
            }
            retval.add(error);
        }
        return retval;
    }

    private static boolean equalsMaybeNull(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private class ErrorElementHandler
    extends XmlParser.ElementHandler {
        public ErrorElementHandler(Attributes attrs) {
            ServiceErrors.this.addError(new ServiceError(attrs.getValue("type"), attrs.getValue("field"), attrs.getValue("reason")));
        }
    }

    private class ErrorsElementHandler
    extends XmlParser.ElementHandler {
        private ErrorsElementHandler() {
        }

        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if ("error".equals(localName)) {
                return new ErrorElementHandler(attrs);
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }
}

