/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atom;

import com.google.common.collect.Lists;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.IGenerator;
import com.google.gdata.data.ILink;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.atom.Author;
import com.google.gdata.model.atom.Category;
import com.google.gdata.model.atom.Contributor;
import com.google.gdata.model.atom.Link;
import com.google.gdata.model.atom.Person;
import com.google.gdata.model.atom.TextContent;
import com.google.gdata.util.Namespaces;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Source
extends Element {
    public static final ElementKey<Void, Source> CONSTRUCT = ElementKey.of(null, Source.class);
    public static final ElementKey<Void, Source> KEY = ElementKey.of(new QName(Namespaces.atomNs, "source"), Void.class, Source.class);
    public static final ElementKey<String, Element> ID = ElementKey.of(new QName(Namespaces.atomNs, "id"));
    public static final ElementKey<DateTime, Element> UPDATED = ElementKey.of(new QName(Namespaces.atomNs, "updated"), DateTime.class, Element.class);
    public static final ElementKey<String, TextContent> TITLE = ElementKey.of(new QName(Namespaces.atomNs, "title"), String.class, TextContent.class);
    public static final ElementKey<String, TextContent> SUBTITLE = ElementKey.of(new QName(Namespaces.atomNs, "subtitle"), String.class, TextContent.class);
    public static final ElementKey<String, TextContent> RIGHTS = ElementKey.of(new QName(Namespaces.atomNs, "rights"), String.class, TextContent.class);
    public static final ElementKey<URI, Element> ICON = ElementKey.of(new QName(Namespaces.atomNs, "icon"), URI.class, Element.class);
    public static final ElementKey<URI, Element> LOGO = ElementKey.of(new QName(Namespaces.atomNs, "logo"), URI.class, Element.class);

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(CONSTRUCT)) {
            return;
        }
        registry.build(ID);
        registry.build(UPDATED);
        registry.build(TITLE);
        registry.build(SUBTITLE);
        registry.build(RIGHTS);
        registry.build(ICON);
        registry.build(LOGO);
        ElementCreator builder = registry.build(CONSTRUCT);
        builder.addElement(ID);
        builder.addElement(UPDATED);
        builder.addElement(Category.KEY);
        builder.addElement(TITLE);
        builder.addElement(SUBTITLE);
        builder.addElement(RIGHTS);
        builder.addElement(ICON);
        builder.addElement(LOGO);
        builder.addElement(Link.KEY);
        builder.addElement(Author.KEY);
        builder.addElement(Contributor.KEY);
        builder.addElement(Generator.KEY);
        registry.build(KEY);
    }

    public Source() {
        super(KEY);
    }

    protected Source(ElementKey<?, ? extends Source> key) {
        super(key);
    }

    protected Source(Source sourceSource) {
        this((ElementKey<?, ? extends Source>)KEY, (Element)sourceSource);
    }

    protected Source(ElementKey<?, ? extends Source> key, Element source) {
        super(key, source);
    }

    public String getId() {
        return this.getElementValue(ID);
    }

    public void setId(String v) {
        this.setElement(ID, v == null ? null : new Element(ID).setTextValue(v));
    }

    public DateTime getUpdated() {
        return this.getElementValue(UPDATED);
    }

    public void setUpdated(DateTime v) {
        this.setElement(UPDATED, v == null ? null : new Element(UPDATED).setTextValue(v));
    }

    public Set<Category> getCategories() {
        return this.getElementSet(Category.KEY);
    }

    public void addCategory(Category v) {
        this.addElement(Category.KEY, (Element)v);
    }

    public void clearCategories() {
        this.removeElement(Category.KEY);
    }

    public TextContent getTitle() {
        return this.getElement(TITLE);
    }

    public void setTitle(TextContent v) {
        this.setElement(TITLE, (Element)v);
    }

    public TextContent getSubtitle() {
        return this.getElement(SUBTITLE);
    }

    public void setSubtitle(TextContent v) {
        this.setElement(SUBTITLE, (Element)v);
    }

    public TextContent getRights() {
        return this.getElement(RIGHTS);
    }

    public void setRights(TextContent v) {
        this.setElement(RIGHTS, (Element)v);
    }

    @Deprecated
    public String getIcon() {
        URI uri = this.getIconUri();
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    public URI getIconUri() {
        return this.getElementValue(ICON);
    }

    @Deprecated
    public void setIcon(String v) {
        try {
            this.setIcon(v == null ? null : new URI(v));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setIcon(URI v) {
        this.setElement(ICON, v == null ? null : new Element(ICON).setTextValue(v));
    }

    @Deprecated
    public String getLogo() {
        URI uri = this.getLogoUri();
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    public URI getLogoUri() {
        return this.getElementValue(LOGO);
    }

    @Deprecated
    public void setLogo(String v) {
        try {
            this.setLogo(v == null ? null : new URI(v));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setLogo(URI v) {
        this.setElement(LOGO, v == null ? null : new Element(LOGO).setTextValue(v));
    }

    public List<Link> getLinks() {
        return this.getElements(Link.KEY);
    }

    public void addLink(Link v) {
        this.addElement(Link.KEY, (Element)v);
    }

    public Link addLink(String rel, String type, String href) {
        try {
            Link link = new Link(rel, type, new URI(href));
            this.addLink(link);
            return link;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean removeLink(Link link) {
        return this.removeElement(Link.KEY, link);
    }

    public void clearLinks() {
        this.removeElement(Link.KEY);
    }

    public List<Person> getAuthors() {
        return this.getElements(Author.KEY);
    }

    public void addAuthor(Person v) {
        this.addElement(Author.KEY, (Element)v);
    }

    public void addAuthors(List<Person> v) {
        for (Person p : v) {
            this.addAuthor(p);
        }
    }

    public boolean removeAuthor(Person v) {
        return this.removeElement(Author.KEY, v);
    }

    public void clearAuthors() {
        this.removeElement(Author.KEY);
    }

    public List<Person> getContributors() {
        return this.getElements(Contributor.KEY);
    }

    public void addContributor(Person v) {
        this.addElement(Contributor.KEY, (Element)v);
    }

    public void addContributors(List<Person> v) {
        for (Person p : v) {
            this.addContributor(p);
        }
    }

    public boolean removeContributor(Person v) {
        return this.removeElement(Contributor.KEY, v);
    }

    public void clearContributors() {
        this.removeElement(Contributor.KEY);
    }

    public Generator getGenerator() {
        return this.getElement(Generator.KEY);
    }

    public void setGenerator(Generator v) {
        this.setElement(Generator.KEY, (Element)v);
    }

    public Generator setGenerator(String version, String uri, String name) {
        Generator gen = new Generator();
        gen.setVersion(version);
        gen.setUri(uri);
        gen.setName(name);
        this.setGenerator(gen);
        return gen;
    }

    public Link getLink(String rel, String type) {
        for (Link link : this.getLinks()) {
            if (!link.matches(rel, type)) continue;
            return link;
        }
        return null;
    }

    public List<Link> getLinks(String relToMatch, String typeToMatch) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.getLinks()) {
            if (!link.matches(relToMatch, typeToMatch)) continue;
            result.add(link);
        }
        return result;
    }

    public void removeLinks(String relToMatch, String typeToMatch) {
        ArrayList<Link> toRemove = Lists.newArrayList();
        for (Link link : this.getLinks()) {
            if (!link.matches(relToMatch, typeToMatch)) continue;
            toRemove.add(link);
        }
        for (Link link : toRemove) {
            this.removeLink(link);
        }
    }

    public void addHtmlLink(String htmlUrl, String lang, String title) {
        try {
            Link link = new Link("alternate", ILink.Type.HTML, new URI(htmlUrl));
            if (lang != null) {
                link.setHrefLang(lang);
            }
            if (title != null) {
                link.setTitle(title);
            }
            this.addElement(Link.KEY, (Element)link);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Link getHtmlLink() {
        Link htmlLink = this.getLink("alternate", ILink.Type.HTML);
        return htmlLink;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Generator
    extends Element
    implements IGenerator {
        public static final ElementKey<String, Generator> KEY = ElementKey.of(new QName(Namespaces.atomNs, "generator"), String.class, Generator.class);
        public static final AttributeKey<String> VERSION = AttributeKey.of(new QName("version"));
        public static final AttributeKey<URI> URI = AttributeKey.of(new QName("uri"), URI.class);

        public static void registerMetadata(MetadataRegistry registry) {
            if (registry.isRegistered(KEY)) {
                return;
            }
            ElementCreator builder = registry.build(KEY);
            builder.addAttribute(VERSION);
            builder.addAttribute(URI);
        }

        public Generator() {
            super(KEY);
        }

        public Generator(ElementKey<?, ? extends Generator> key) {
            super(key);
        }

        @Override
        public String getVersion() {
            return this.getAttributeValue(VERSION);
        }

        public void setVersion(String v) {
            this.setAttributeValue(VERSION, (Object)v);
        }

        @Override
        @Deprecated
        public String getHref() {
            URI uri = this.getUriUri();
            if (uri == null) {
                return null;
            }
            return uri.toString();
        }

        public URI getUriUri() {
            return this.getAttributeValue(URI);
        }

        @Deprecated
        public void setUri(String v) {
            try {
                this.setUri(v == null ? null : new URI(v));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public void setUri(URI v) {
            this.setAttributeValue(URI, (Object)v);
        }

        @Override
        public String getName() {
            return (String)this.getTextValue();
        }

        public void setName(String v) {
            this.setTextValue(v);
        }
    }
}

