/*
 * Decompiled with CFR 0.152.
 */
package config.ui;

import config.ui.FileChooseTextPanel;
import config.ui.FileListEditorPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class ConfigPanel
extends JPanel {
    private static final int HOR_RATIO_MAX = 200;
    private static NumberFormatter doubleFormatter = new NumberFormatter();
    private JTextField scheduleFileName;
    private JTextField userName;
    private JTextField garoonUserId;
    private JTextField garoonPassword;
    private JTextField garoonUserFileName;
    private JTextField atmuoUserId;
    private JTextField atmuoPassword;
    private JTextField atmuoCompanyName;
    private JTextField atmuoCompanyCode;
    private JFormattedTextField horizontalRatio;
    private JSlider hRatioSlider;
    private JComboBox gridMinute;
    private JTextField startHour;
    private JTextField endHour;
    private JTextField notesIDFileName;
    private JTextField notesPassword;
    private JTextField notesServerName;
    private JTextField notesDBName;
    private JList prjUnitList;
    private DefaultListModel prjUnitListModel;
    private JList garoonUserList;
    private DefaultListModel garoonUserListModel;

    static {
        doubleFormatter.setValueClass(Double.class);
        NumberFormat f = (NumberFormat)doubleFormatter.getFormat();
        f.setGroupingUsed(false);
    }

    public Enumeration<String> getPrjUnitFileNames() {
        return this.prjUnitListModel.elements();
    }

    public void addPrjUnitFileName(String filename) {
        this.prjUnitListModel.addElement(filename);
    }

    public Enumeration<String> getGaroonUserFileNames() {
        return this.garoonUserListModel.elements();
    }

    public void addGaroonUserFileName(String filename) {
        this.garoonUserListModel.addElement(filename);
    }

    public String getNotesDBName() {
        return this.notesDBName.getText();
    }

    public void setNotesDBName(String notesDBName) {
        this.notesDBName.setText(notesDBName);
    }

    public String getNotesServerName() {
        return this.notesServerName.getText();
    }

    public void setNotesServerName(String notesServerName) {
        this.notesServerName.setText(notesServerName);
    }

    public String getNotesIDFileName() {
        return this.notesIDFileName.getText();
    }

    public void setNotesIDFileName(String notesIDFileName) {
        this.notesIDFileName.setText(notesIDFileName);
    }

    public String getNotesPassword() {
        return this.notesPassword.getText();
    }

    public void setNotesPassword(String notesPassword) {
        this.notesPassword.setText(notesPassword);
    }

    public String getGaroonUserFileName() {
        return this.garoonUserFileName.getText();
    }

    public void setGaroonUserFileName(String garoonUserFileName) {
        this.garoonUserFileName.setText(garoonUserFileName);
    }

    public String getGridMinute() {
        return (String)this.gridMinute.getSelectedItem();
    }

    public void setGridMinute(String gridMinute) {
        this.gridMinute.setSelectedItem(gridMinute);
    }

    public String getStartHour() {
        return this.startHour.getText();
    }

    public void setStartHour(String startHour) {
        this.startHour.setText(startHour);
    }

    public String getEndHour() {
        return this.endHour.getText();
    }

    public void setEndHour(String endHour) {
        this.endHour.setText(endHour);
    }

    public String getAtmuoUserId() {
        return this.atmuoUserId.getText();
    }

    public void setAtmuoUserId(String atmuoUserId) {
        this.atmuoUserId.setText(atmuoUserId);
    }

    public String getAtmuoPassword() {
        return this.atmuoPassword.getText();
    }

    public void setAtmuoPassword(String atmuoPassword) {
        this.atmuoPassword.setText(atmuoPassword);
    }

    public String getAtmuoCompanyCode() {
        return this.atmuoCompanyCode.getText();
    }

    public void setAtmuoCompanyCode(String atmuoCompanyCode) {
        this.atmuoCompanyCode.setText(atmuoCompanyCode);
    }

    public String getAtmuoCompanyName() {
        return this.atmuoCompanyName.getText();
    }

    public void setAtmuoCompanyName(String atmuoCompanyName) {
        this.atmuoCompanyName.setText(atmuoCompanyName);
    }

    public String getScheduleFileName() {
        return this.scheduleFileName.getText();
    }

    public void setScheduleFileName(String scheduleFileName) {
        this.scheduleFileName.setText(scheduleFileName);
    }

    public String getUserName() {
        return this.userName.getText();
    }

    public void setUserName(String userName) {
        this.userName.setText(userName);
    }

    public String getGaroonUserId() {
        return this.garoonUserId.getText();
    }

    public void setGaroonUserId(String garoonUserId) {
        this.garoonUserId.setText(garoonUserId);
    }

    public String getGaroonPassword() {
        return this.garoonPassword.getText();
    }

    public void setGaroonPassword(String garoonPassword) {
        this.garoonPassword.setText(garoonPassword);
    }

    public String getHorizontalRatio() {
        return this.horizontalRatio.getText();
    }

    public void setHorizontalRatio(String horizontalRatio) {
        this.horizontalRatio.setText(horizontalRatio);
        this.hRatioSlider.setValue((int)(Double.valueOf(horizontalRatio) * 200.0));
    }

    public ConfigPanel() {
        this.createComponents();
    }

    private void createComponents() {
        JTabbedPane pane = new JTabbedPane();
        pane.add("\u5168\u822c", this.createGeneralConfigPanel());
        pane.add("Garoon", this.createGaroonConfigPanel());
        pane.add("@MUo", this.createAtmuoConfigPanel());
        pane.add("Notes", this.createNotesConfigPanel());
        this.add(pane);
    }

    private JPanel createGeneralConfigPanel() {
        this.scheduleFileName = new JTextField(20);
        this.userName = new JTextField(10);
        this.prjUnitListModel = new DefaultListModel();
        this.prjUnitList = new JList(this.prjUnitListModel);
        ArrayList<ComponentPair> pairs = new ArrayList<ComponentPair>();
        pairs.add(new ComponentPair(new JLabel("\u30e6\u30fc\u30b6\u30fc\u540d"), this.userName));
        pairs.add(new ComponentPair(new JLabel("\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u30d5\u30a1\u30a4\u30eb\u540d"), new FileChooseTextPanel(this.scheduleFileName, new FileNameExtensionFilter("\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u30d5\u30a1\u30a4\u30eb(*.jsm)", "jsm"))));
        pairs.add(new ComponentPair(new JLabel("\u6848\u4ef6\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u540d"), new FileListEditorPanel(this.prjUnitList, new FileNameExtensionFilter("\u6848\u4ef6\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb(*.xml)", "xml"))));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(this.createPairedGroupLayout(p1, pairs));
        p.add(p1);
        p.add(this.createAppearanceConfigPanel());
        return p;
    }

    private Component createAppearanceConfigPanel() {
        this.horizontalRatio = new JFormattedTextField();
        this.horizontalRatio.setColumns(6);
        this.horizontalRatio.setFormatterFactory(new DefaultFormatterFactory(doubleFormatter, doubleFormatter, doubleFormatter));
        this.hRatioSlider = new JSlider(1, 200);
        this.hRatioSlider.setPaintTicks(true);
        this.hRatioSlider.setMinorTickSpacing(10);
        this.horizontalRatio.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                JTextField t = (JTextField)e.getSource();
                if (t.getText().length() > 0) {
                    ConfigPanel.this.hRatioSlider.setValue((int)(Double.valueOf(t.getText()) * 200.0));
                }
            }
        });
        this.hRatioSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                ConfigPanel.this.horizontalRatio.setText(Double.toString((double)slider.getValue() / 200.0));
            }
        });
        this.gridMinute = new JComboBox();
        this.gridMinute.addItem("15");
        this.gridMinute.addItem("30");
        this.startHour = new JTextField(2);
        this.endHour = new JTextField(2);
        JLabel lhRatio = new JLabel("\u6a2a\u306e\u30d4\u30c3\u30c1(\u5206/dot)", 4);
        JLabel lgridMinute = new JLabel("\u30b0\u30ea\u30c3\u30c9\u5358\u4f4d(\u5206)", 4);
        JLabel lstartHour = new JLabel("\u958b\u59cb\u6642\u523b", 4);
        JLabel lendHour = new JLabel("\u7d42\u4e86\u6642\u523b", 4);
        JPanel p1 = new JPanel();
        p1.add(this.horizontalRatio);
        p1.add(this.hRatioSlider);
        ArrayList<ComponentPair> pairs = new ArrayList<ComponentPair>();
        pairs.add(new ComponentPair(lhRatio, p1));
        pairs.add(new ComponentPair(lgridMinute, this.gridMinute));
        pairs.add(new ComponentPair(lstartHour, this.startHour));
        pairs.add(new ComponentPair(lendHour, this.endHour));
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder("\u8868\u793a\u8a2d\u5b9a"));
        p.setLayout(this.createPairedGroupLayout(p, pairs));
        return p;
    }

    private JPanel createGaroonConfigPanel() {
        this.garoonUserId = new JTextField(10);
        this.garoonPassword = new JPasswordField(10);
        this.garoonUserFileName = new JTextField(20);
        this.garoonUserListModel = new DefaultListModel();
        this.garoonUserList = new JList(this.garoonUserListModel);
        JLabel l1 = new JLabel("\u30ed\u30b0\u30a4\u30f3\u30e6\u30fc\u30b6\u30fcID", 4);
        JLabel l2 = new JLabel("\u30ed\u30b0\u30a4\u30f3\u30d1\u30b9\u30ef\u30fc\u30c9", 4);
        ArrayList<ComponentPair> pairs = new ArrayList<ComponentPair>();
        pairs.add(new ComponentPair(l1, this.garoonUserId));
        pairs.add(new ComponentPair(l2, this.garoonPassword));
        pairs.add(new ComponentPair(new JLabel("Garoon\u30e6\u30fc\u30b6\u30fc\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u540d"), new FileListEditorPanel(this.garoonUserList, new FileNameExtensionFilter("Garoon\u30e6\u30fc\u30b6\u30fc\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb(*.xml)", "xml"))));
        JPanel p = new JPanel();
        p.setLayout(this.createPairedGroupLayout(p, pairs));
        return p;
    }

    private JPanel createAtmuoConfigPanel() {
        this.atmuoUserId = new JTextField(10);
        this.atmuoPassword = new JPasswordField(10);
        this.atmuoCompanyCode = new JTextField(3);
        this.atmuoCompanyCode.setEditable(false);
        this.atmuoCompanyName = new JTextField(15);
        this.atmuoCompanyName.setEditable(false);
        ArrayList<ComponentPair> pairs = new ArrayList<ComponentPair>();
        pairs.add(new ComponentPair(new JLabel("@MUo\u30ed\u30b0\u30a4\u30f3ID"), this.atmuoUserId));
        pairs.add(new ComponentPair(new JLabel("@MUo\u30ed\u30b0\u30a4\u30f3\u30d1\u30b9\u30ef\u30fc\u30c9"), this.atmuoPassword));
        pairs.add(new ComponentPair(new JLabel("\u4f1a\u793e\u30b3\u30fc\u30c9"), this.atmuoCompanyCode));
        pairs.add(new ComponentPair(new JLabel("\u4f1a\u793e\u540d"), this.atmuoCompanyName));
        JPanel p = new JPanel();
        p.setLayout(this.createPairedGroupLayout(p, pairs));
        return p;
    }

    private Component createNotesConfigPanel() {
        this.notesIDFileName = new JTextField(20);
        this.notesPassword = new JPasswordField(10);
        this.notesServerName = new JTextField(20);
        this.notesServerName.setEditable(false);
        this.notesDBName = new JTextField(20);
        this.notesDBName.setEditable(false);
        ArrayList<ComponentPair> pairs = new ArrayList<ComponentPair>();
        pairs.add(new ComponentPair(new JLabel("NotesID\u30d5\u30a1\u30a4\u30eb"), new FileChooseTextPanel(this.notesIDFileName, new FileNameExtensionFilter("NotesID\u30d5\u30a1\u30a4\u30eb(*.id)", "id"))));
        pairs.add(new ComponentPair(new JLabel("Notes\u30d1\u30b9\u30ef\u30fc\u30c9"), this.notesPassword));
        pairs.add(new ComponentPair(new JLabel("\u4f1a\u8b70\u5ba4Notes\u30b5\u30fc\u30d0\u540d"), this.notesServerName));
        pairs.add(new ComponentPair(new JLabel("\u4f1a\u8b70\u5ba4NotesDB\u540d"), this.notesDBName));
        JPanel p = new JPanel();
        p.setLayout(this.createPairedGroupLayout(p, pairs));
        return p;
    }

    private GroupLayout createPairedGroupLayout(Container host, List<ComponentPair> pairs) {
        GroupLayout gl = new GroupLayout(host);
        gl.setAutoCreateGaps(true);
        gl.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hgroup = gl.createSequentialGroup();
        GroupLayout.ParallelGroup hpg_left = gl.createParallelGroup();
        for (ComponentPair pair : pairs) {
            hpg_left.addComponent(pair.left);
        }
        hgroup.addGroup(hpg_left);
        GroupLayout.ParallelGroup hpg_right = gl.createParallelGroup();
        for (ComponentPair pair : pairs) {
            hpg_right.addComponent(pair.right);
        }
        hgroup.addGroup(hpg_right);
        gl.setHorizontalGroup(hgroup);
        GroupLayout.SequentialGroup vgroup = gl.createSequentialGroup();
        for (ComponentPair pair : pairs) {
            GroupLayout.ParallelGroup vpg = gl.createParallelGroup(GroupLayout.Alignment.BASELINE);
            vpg.addComponent(pair.left).addComponent(pair.right);
            vgroup.addGroup(vpg);
        }
        gl.setVerticalGroup(vgroup);
        return gl;
    }

    private class ComponentPair {
        Component left;
        Component right;

        public ComponentPair(Component left, Component right) {
            this.left = left;
            this.right = right;
        }
    }
}

