/*
 * Decompiled with CFR 0.152.
 */
package deliveryData;

import commonData.YyyyMmDdHolder;
import jScheduleData.OneDayScheduleData;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scheduleData.ScheduleData;

public class OneDeliveryData
extends OneDayScheduleData {
    private String projectUnit;
    private String projectCode;
    private String comment;

    public OneDeliveryData(YyyyMmDdHolder yyyyMmDd, String projectUnit, String projectCode) {
        super(yyyyMmDd);
        this.projectUnit = new String(projectUnit);
        this.projectCode = new String(projectCode);
        this.comment = "";
        this.workTimeByMinute = 0;
    }

    public void createOneDeliveryData(ArrayList<ScheduleData> sdList, boolean projectUnitFlag, boolean phaseFlag, boolean workFlag) {
        for (ScheduleData sd : sdList) {
            this.addSchedule(sd, projectUnitFlag, phaseFlag, workFlag);
        }
    }

    private void addSchedule(ScheduleData sd, boolean projectUnitFlag, boolean phaseFlag, boolean workFlag) {
        if (!this.checkData(sd, projectUnitFlag)) {
            return;
        }
        this.updateStartDi(sd.getS_date());
        this.updateEndDi(sd.getE_date());
        if (phaseFlag) {
            this.comment = this.addComment(this.comment, sd.getPhaseName());
        }
        if (workFlag) {
            this.comment = this.addComment(this.comment, sd.getWork());
        }
        this.sdList.add(sd);
        this.workTimeByMinute += sd.getTimeByMinute();
    }

    private String addComment(String beforeComment, String addString) {
        Pattern pattern = Pattern.compile(addString);
        Matcher matcher = pattern.matcher(beforeComment);
        if (matcher.find()) {
            return beforeComment;
        }
        return new String(String.valueOf(beforeComment) + "," + addString);
    }

    private boolean checkData(ScheduleData sd, boolean projectUnitFlag) {
        if (projectUnitFlag ? !sd.getProjectUnitName().equals(this.projectUnit) : !sd.getPrj_code().equals(this.projectCode)) {
            return false;
        }
        return sd.getS_date().getYyyy().equals(this.yyyyMmDd.getYyyy()) && sd.getS_date().getMm().equals(this.yyyyMmDd.getMm()) && sd.getS_date().getDd().equals(this.yyyyMmDd.getDd());
    }

    public String getComment() {
        return this.comment;
    }
}

