/*
 * Decompiled with CFR 0.152.
 */
package jScheduleData;

import com.google.gdata.client.Query;
import com.google.gdata.client.calendar.CalendarQuery;
import com.google.gdata.client.calendar.CalendarService;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Person;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.calendar.CalendarEventEntry;
import com.google.gdata.data.calendar.CalendarEventFeed;
import com.google.gdata.data.extensions.When;
import com.google.gdata.data.extensions.Where;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.InvalidEntryException;
import com.google.gdata.util.ServiceException;
import commonData.UserInfo;
import configInfo.GoogleCalendarConfig;
import jScheduleData.JScheduleData;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;

public class JScheduleDataGoogleCalendar
extends JScheduleData {
    private GoogleCalendarConfig googleCalendarConfig;

    public JScheduleDataGoogleCalendar(UserInfo userInfo, GoogleCalendarConfig googleCalendarConfig) {
        super(userInfo);
        this.googleCalendarConfig = googleCalendarConfig;
    }

    @Override
    public int addScheduleData(ArrayList<ScheduleData> sdList) {
        int result = 0;
        this.setProxy();
        if (this.googleCalendarConfig.getPassword() == null) {
            this.googleCalendarConfig.setPassword(this.inputPassword());
        }
        for (ScheduleData sd : sdList) {
            try {
                CalendarEventEntry myEntry = new CalendarEventEntry();
                myEntry.setTitle(new PlainTextConstruct(sd.getTitle()));
                myEntry.setContent(new PlainTextConstruct(sd.getComment()));
                Person author = new Person("mScheduer", null, this.googleCalendarConfig.getUserid());
                myEntry.getAuthors().add(author);
                DateTime startTime = new DateTime();
                startTime.setTzShift(9);
                startTime = DateTime.parseDateTime(String.valueOf(sd.getS_date().getYyyy()) + "-" + sd.getS_date().getMm() + "-" + sd.getS_date().getDd() + "T" + sd.getS_date().getHH() + ":" + sd.getS_date().getMM() + ":00");
                DateTime endTime = new DateTime();
                endTime.setTzShift(9);
                endTime = DateTime.parseDateTime(String.valueOf(sd.getE_date().getYyyy()) + "-" + sd.getE_date().getMm() + "-" + sd.getE_date().getDd() + "T" + sd.getE_date().getHH() + ":" + sd.getE_date().getMM() + ":00");
                When eventTimes = new When();
                eventTimes.setStartTime(startTime);
                eventTimes.setEndTime(endTime);
                myEntry.addTime(eventTimes);
                Where evLocation = new Where();
                evLocation.setValueString(sd.getPlace());
                myEntry.addLocation(evLocation);
                CalendarService calService = new CalendarService("mScheduler");
                calService.setUserCredentials(this.googleCalendarConfig.getUserid(), this.googleCalendarConfig.getPassword());
                URL postURL = this.createUrl(this.googleCalendarConfig);
                CalendarEventEntry insertEntry = calService.insert(postURL, myEntry);
            }
            catch (MalformedURLException e) {
                this.unSetProxy();
                e.printStackTrace();
                return -1;
            }
            catch (AuthenticationException e) {
                this.unSetProxy();
                e.printStackTrace();
                return -1;
            }
            catch (IOException e) {
                this.unSetProxy();
                e.printStackTrace();
                return -1;
            }
            catch (ServiceException e) {
                this.unSetProxy();
                e.printStackTrace();
                return -1;
            }
        }
        this.unSetProxy();
        return result;
    }

    @Override
    public int delScheduleData(ArrayList<ScheduleData> sdList) {
        int result = 0;
        this.setProxy();
        if (this.googleCalendarConfig.getPassword() == null) {
            this.googleCalendarConfig.setPassword(this.inputPassword());
        }
        try {
            URL postURL = this.createUrl(this.googleCalendarConfig);
            Query myQuery = new Query(postURL);
            CalendarService calService = new CalendarService("mScheduler");
            calService.setUserCredentials(this.googleCalendarConfig.getUserid(), this.googleCalendarConfig.getPassword());
            CalendarEventFeed myResultsFeed = calService.query(myQuery, CalendarEventFeed.class);
            if (myResultsFeed.getEntries().size() > 0) {
                for (CalendarEventEntry entry : myResultsFeed.getEntries()) {
                    ScheduleData entrySd = new ScheduleData();
                    entrySd = this.createSd(entry);
                    for (ScheduleData sd : sdList) {
                        if (!entrySd.compare(sd)) continue;
                        try {
                            entry.delete();
                        }
                        catch (InvalidEntryException e) {
                            e.printStackTrace();
                            System.out.println("InvalidEntryException: " + sd.createScheduleDataKey());
                        }
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            this.unSetProxy();
            e.printStackTrace();
            result = -1;
        }
        catch (AuthenticationException e) {
            this.unSetProxy();
            e.printStackTrace();
            result = -1;
        }
        catch (IOException e) {
            this.unSetProxy();
            e.printStackTrace();
            result = -1;
        }
        catch (ServiceException e) {
            this.unSetProxy();
            e.printStackTrace();
            result = -1;
        }
        this.unSetProxy();
        return result;
    }

    @Override
    public int readScheduleData(DateInfo dateScope) {
        int result = 0;
        this.setProxy();
        if (this.googleCalendarConfig.getPassword() == null) {
            this.googleCalendarConfig.setPassword(this.inputPassword());
        }
        try {
            CalendarService calService = new CalendarService("mScheduler");
            calService.setUserCredentials(this.googleCalendarConfig.getUserid(), this.googleCalendarConfig.getPassword());
            CalendarQuery myQuery = new CalendarQuery(this.createUrl(this.googleCalendarConfig));
            System.out.println("getAuthority : " + myQuery.getUrl().getAuthority());
            System.out.println("getFile : " + myQuery.getUrl().getFile());
            System.out.println("getHost : " + myQuery.getUrl().getHost());
            System.out.println("getPath : " + myQuery.getUrl().getPath());
            System.out.println("getPort : " + myQuery.getUrl().getPort());
            System.out.println("getProtocol : " + myQuery.getUrl().getProtocol());
            System.out.println("getQuery : " + myQuery.getUrl().getQuery());
            DateInfo nowDi = new DateInfo();
            myQuery.setMinimumStartTime(DateTime.parseDateTime(String.valueOf(nowDi.getYyyy()) + "-" + nowDi.getMm() + "-" + "01T00:00:00"));
            CalendarEventFeed myResultsFeed = calService.query(myQuery, CalendarEventFeed.class);
            this.setFeed2JscheduleMap(myResultsFeed);
        }
        catch (MalformedURLException e) {
            this.unSetProxy();
            e.printStackTrace();
            result = -1;
        }
        catch (AuthenticationException e) {
            this.unSetProxy();
            e.printStackTrace();
            result = -1;
        }
        catch (IOException e) {
            this.unSetProxy();
            e.printStackTrace();
            result = -1;
        }
        catch (ServiceException e) {
            this.unSetProxy();
            e.printStackTrace();
            result = -1;
        }
        this.unSetProxy();
        return result;
    }

    private void setFeed2JscheduleMap(CalendarEventFeed cef) {
        this.createDataMap();
        for (CalendarEventEntry entry : cef.getEntries()) {
            ScheduleData sd = this.createSd(entry);
            this.addSchedule2ScheduleDataMap2(sd);
            this.addSchedule2DayScheduleDataMap(sd);
        }
    }

    private ScheduleData createSd(CalendarEventEntry entry) {
        ScheduleData sd = new ScheduleData();
        sd.setTitle(entry.getTitle().getPlainText());
        String plase = new String("");
        for (Where location : entry.getLocations()) {
            plase = String.valueOf(plase) + location.getValueString();
        }
        sd.setPlace(plase);
        if (entry.getTimes().size() > 0) {
            GoogleCalendarTime gct = new GoogleCalendarTime();
            gct.setGaroonCalendarTime(entry.getTimes().get(0).getStartTime().toString());
            sd.getS_date().setYyyy(gct.getYyyy());
            sd.getS_date().setMm(gct.getMm());
            sd.getS_date().setDd(gct.getDd());
            sd.getS_date().setHH(gct.getHH());
            sd.getS_date().setMM(gct.getMM());
            gct.setGaroonCalendarTime(entry.getTimes().get(0).getEndTime().toString());
            sd.getE_date().setYyyy(gct.getYyyy());
            sd.getE_date().setMm(gct.getMm());
            sd.getE_date().setDd(gct.getDd());
            sd.getE_date().setHH(gct.getHH());
            sd.getE_date().setMM(gct.getMM());
        }
        sd.setComment(entry.getPlainTextContent());
        return sd;
    }

    private URL createUrl(GoogleCalendarConfig gcc) {
        URL url = null;
        try {
            url = new URL(gcc.getCalendar_url());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    private void setProxy() {
        if (this.googleCalendarConfig.getProxyHost() != null) {
            System.setProperty("http.proxyHost", this.googleCalendarConfig.getProxyHost());
            System.setProperty("http.proxyPort", this.googleCalendarConfig.getProxyPort());
        }
    }

    private void unSetProxy() {
        if (this.googleCalendarConfig.getProxyHost() != null) {
            System.setProperty("http.proxyHost", null);
        }
    }

    private String inputPassword() {
        return JOptionPane.showInputDialog("Please input password");
    }

    private class GoogleCalendarTime {
        private String yyyy = "";
        private String mm = "";
        private String dd = "";
        private String HH = "";
        private String MM = "";

        public void setGaroonCalendarTime(String timeInfo) {
            Pattern pattern = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2})");
            Matcher matcher = pattern.matcher(timeInfo);
            if (matcher.find()) {
                if (matcher.group(1) != null) {
                    this.yyyy = matcher.group(1);
                }
                if (matcher.group(2) != null) {
                    this.mm = matcher.group(2);
                }
                if (matcher.group(3) != null) {
                    this.dd = matcher.group(3);
                }
                if (matcher.group(4) != null) {
                    this.HH = matcher.group(4);
                }
                if (matcher.group(5) != null) {
                    this.MM = matcher.group(5);
                }
            }
        }

        public String getYyyy() {
            return this.yyyy;
        }

        public void setYyyy(String yyyy) {
            this.yyyy = yyyy;
        }

        public String getMm() {
            return this.mm;
        }

        public void setMm(String mm) {
            this.mm = mm;
        }

        public String getDd() {
            return this.dd;
        }

        public void setDd(String dd) {
            this.dd = dd;
        }

        public String getHH() {
            return this.HH;
        }

        public void setHH(String hh) {
            this.HH = hh;
        }

        public String getMM() {
            return this.MM;
        }

        public void setMM(String mm) {
            this.MM = mm;
        }
    }
}

