/*
 * Decompiled with CFR 0.152.
 */
package jScheduleData;

import commonData.YyyyMmDdHolder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;

public class OneDayScheduleData {
    protected ArrayList<ScheduleData> sdList = new ArrayList();
    protected YyyyMmDdHolder yyyyMmDd = new YyyyMmDdHolder();
    protected DateInfo startDi;
    protected DateInfo endDi;
    protected int workTimeByMinute;

    public OneDayScheduleData(YyyyMmDdHolder yyyyMmDd) {
        this.yyyyMmDd.setYyyy(yyyyMmDd.getYyyy());
        this.yyyyMmDd.setMm(yyyyMmDd.getMm());
        this.yyyyMmDd.setDd(yyyyMmDd.getDd());
        this.startDi = new DateInfo(yyyyMmDd.getYyyy(), yyyyMmDd.getMm(), yyyyMmDd.getDd(), "", "");
        this.endDi = new DateInfo(yyyyMmDd.getYyyy(), yyyyMmDd.getMm(), yyyyMmDd.getDd(), "", "");
        this.workTimeByMinute = 0;
    }

    public void createOneDayScheduleData(ArrayList<ScheduleData> sdList) {
        for (ScheduleData sd : sdList) {
            this.addSchedule(sd);
        }
    }

    private void addSchedule(ScheduleData sd) {
        if (!this.checkData(sd)) {
            return;
        }
        this.updateStartDi(sd.getS_date());
        this.updateEndDi(sd.getE_date());
        this.sdList.add(sd);
        this.workTimeByMinute += sd.getTimeByMinute();
    }

    private boolean checkData(ScheduleData sd) {
        return sd.getS_date().getYyyy().equals(this.yyyyMmDd.getYyyy()) && sd.getS_date().getMm().equals(this.yyyyMmDd.getMm()) && sd.getS_date().getDd().equals(this.yyyyMmDd.getDd());
    }

    protected void updateStartDi(DateInfo di) {
        if (this.startDi.getHH().equals("")) {
            this.startDi = new DateInfo(di.getYyyy(), di.getMm(), di.getDd(), di.getHH(), di.getMM());
        } else if (di.compareDateInfo(this.startDi) == -1) {
            this.startDi = new DateInfo(di.getYyyy(), di.getMm(), di.getDd(), di.getHH(), di.getMM());
        }
    }

    protected void updateEndDi(DateInfo di) {
        if (this.endDi.getHH().equals("")) {
            this.endDi = new DateInfo(di.getYyyy(), di.getMm(), di.getDd(), di.getHH(), di.getMM());
        }
        if (di.compareDateInfo(this.endDi) == 1) {
            this.endDi = new DateInfo(di.getYyyy(), di.getMm(), di.getDd(), di.getHH(), di.getMM());
        }
    }

    public String getDd() {
        return this.startDi.getDd();
    }

    public String getStartHH() {
        return this.startDi.getHH();
    }

    public String getStartMM() {
        return this.startDi.getMM();
    }

    public String getEndHH() {
        return this.endDi.getHH();
    }

    public String getEndMM() {
        return this.endDi.getMM();
    }

    public String getWorkTime() {
        return Integer.toString(this.workTimeByMinute);
    }

    public String getWorkTimeHH() {
        return Integer.toString(this.workTimeByMinute / 60);
    }

    public String getWorkTimeMM() {
        return Integer.toString(this.workTimeByMinute % 60);
    }

    private int getRestTimeByMinute() {
        if (this.workTimeByMinute == 0) {
            return 0;
        }
        ScheduleData sd = new ScheduleData();
        sd.getS_date().setYyyy(this.startDi.getYyyy());
        sd.getS_date().setMm(this.startDi.getMm());
        sd.getS_date().setDd(this.startDi.getDd());
        sd.getS_date().setHH(this.startDi.getHH());
        sd.getS_date().setMM(this.startDi.getMM());
        sd.getE_date().setYyyy(this.endDi.getYyyy());
        sd.getE_date().setMm(this.endDi.getMm());
        sd.getE_date().setDd(this.endDi.getDd());
        sd.getE_date().setHH(this.endDi.getHH());
        sd.getE_date().setMM(this.endDi.getMM());
        int totalTime = sd.getTimeByMinute();
        int restTime = totalTime - this.workTimeByMinute;
        return restTime;
    }

    public String getRestTimeHH() {
        if (this.workTimeByMinute == 0) {
            return "";
        }
        int restTime = this.getRestTimeByMinute();
        int restTimeHH = restTime / 60;
        return Integer.toString(restTimeHH);
    }

    public String getRestTimeMM() {
        if (this.workTimeByMinute == 0) {
            return "";
        }
        int restTime = this.getRestTimeByMinute();
        int restTimeMM = restTime % 60;
        return Integer.toString(restTimeMM);
    }

    public String getRestTimeByHour() {
        if (this.workTimeByMinute == 0) {
            return "";
        }
        double restTime = this.getRestTimeByMinute();
        double restTimeHour = restTime / 60.0;
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(restTimeHour);
    }

    public ArrayList<ScheduleData> getSdList() {
        return this.sdList;
    }
}

