/*
 * Decompiled with CFR 0.152.
 */
package mScheduler;

import commonData.UserInfo;
import commonData.YyyyMmHolder;
import configInfo.JSchedulerConfig;
import configInfo.JschedulerDigesterCtl;
import configInfo.ReferenceDir;
import garoonUserInfo.GaroonUserInfoCreator;
import jScheduleData.AllUserJScheduleData;
import jScheduleData.HolidayInfo;
import mScheduler.MSchedulerFrameImp;
import notesRoomsInfo.NotesRooms;
import notesRoomsInfo.NotesRoomsDigesterCtl;
import userInfoData.UserIndexCreator;
import userInfoData.UserIndexes;
import userInfoData.UserInfoData;
import workMasterData.PhaseInfoListMap;
import workMasterData.ProjectUnitList;
import workMasterData.ProjectUnitListCreator;
import workMasterData.WorkInfoListMap;

public class MSchedulerMain {
    MSchedulerMain(String configFileName) {
        NotesRoomsDigesterCtl ncdc;
        JschedulerDigesterCtl digesterCtl = new JschedulerDigesterCtl();
        JSchedulerConfig jsc = digesterCtl.configRead(configFileName);
        if (jsc.getResult() < 0) {
            System.out.println(String.valueOf(configFileName) + ",config\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f");
            System.exit(-1);
        }
        UserInfo currentUserInfo = new UserInfo(jsc.getJSchedulerDataConfig().getUserId(), jsc.getJSchedulerDataConfig().getUserName(), true, false, true);
        UserIndexCreator uic = new UserIndexCreator();
        UserIndexes userIndexes = uic.createUserIndex(jsc.getJSchedulerDataConfig().getDirInfo());
        userIndexes.getUserIndex().printAll();
        UserInfoData userInfoData = new UserInfoData(currentUserInfo);
        userInfoData.createUserInfoList(jsc.getJSchedulerDataConfig().getFileName(), userIndexes.getUserIndex());
        HolidayInfo holidayInfo = new HolidayInfo();
        holidayInfo.readHolidayInfo(jsc.getJSchedulerDataConfig().getDirInfo());
        ProjectUnitList projectUnitList = null;
        PhaseInfoListMap phaseInfoListMap = null;
        WorkInfoListMap workInfoListMap = null;
        if (jsc.getProjectUnitConfigs() != null) {
            ProjectUnitListCreator pulc = new ProjectUnitListCreator();
            projectUnitList = pulc.createProjectUnitList(jsc.getProjectUnitConfigs());
            if (projectUnitList != null) {
                phaseInfoListMap = new PhaseInfoListMap();
                phaseInfoListMap.readPhaseNames(projectUnitList.getAllPhaseNameFileList());
                workInfoListMap = new WorkInfoListMap();
                workInfoListMap.readWorkInfo(projectUnitList.getAllWorkNameFileList());
            } else {
                projectUnitList = new ProjectUnitList();
                phaseInfoListMap = new PhaseInfoListMap();
                workInfoListMap = new WorkInfoListMap();
            }
        }
        if (jsc.getJSchedulerDataConfig().getReferenceDirs() != null) {
            for (ReferenceDir rdir : jsc.getJSchedulerDataConfig().getReferenceDirs().getReferenceDirList()) {
                userInfoData.createUserInfoListByDirpath(rdir.getUserspaceName(), rdir.getDirName());
            }
        }
        if (jsc.getGaroon_user_configs() != null) {
            GaroonUserInfoCreator guic = new GaroonUserInfoCreator();
            guic.createGaroonUserInfo(jsc.getGaroon_user_configs(), userInfoData);
        }
        NotesRooms notesRooms = null;
        if (jsc.getNotesConfig().getRoomsFileName() != null && !jsc.getNotesConfig().getRoomsFileName().equals("") && (notesRooms = (ncdc = new NotesRoomsDigesterCtl()).executeParse(jsc.getNotesConfig().getRoomsFileName())) != null) {
            userInfoData.createUserInfoFromNotesRooms(notesRooms);
        }
        AllUserJScheduleData aujsd = new AllUserJScheduleData(jsc.getJSchedulerDataConfig().getFileName(), jsc.getGaroonConfig(), jsc.getNotesConfig(), jsc.getGoogleCalendarConfig(), currentUserInfo);
        userInfoData.printAll();
        YyyyMmHolder yyyyMmHolder = new YyyyMmHolder();
        yyyyMmHolder.setToday();
        new MSchedulerFrameImp("mScheduler", currentUserInfo, yyyyMmHolder.getYyyy(), yyyyMmHolder.getMm(), aujsd, holidayInfo, jsc, projectUnitList, phaseInfoListMap, workInfoListMap, userInfoData);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("\u5f15\u6570\u3067config\u30d5\u30a1\u30a4\u30eb\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
            System.exit(-1);
        }
        new MSchedulerMain(args[0]);
    }
}

