/*
 * Decompiled with CFR 0.152.
 */
package mtroom.notes;

import java.util.logging.Logger;
import lotus.notes.Database;
import lotus.notes.Document;
import lotus.notes.DocumentCollection;
import lotus.notes.NotesThread;
import lotus.notes.Registration;
import lotus.notes.Session;
import mtroom.Reservation;
import mtroom.ReservationList;
import mtroom.RoomSearchCriteria;

public abstract class MeetingRoom
extends NotesThread {
    private String userIDPath;
    private String password;
    private String dayStr;
    private String dbServer;
    private String dbFile;
    private boolean error_occured = false;
    private Exception occured_ex;
    private Session session;
    private ReservationList rl;
    private RoomSearchCriteria criteria = new RoomSearchCriteria();

    @Deprecated
    public MeetingRoom(String userIDPath, String password, String dbServer, String dbFile, String year, String month, String day) {
        this.userIDPath = userIDPath;
        this.password = password;
        this.dbServer = dbServer;
        this.dbFile = dbFile;
        this.dayStr = this.makeDayStr(year, month, day);
    }

    public MeetingRoom(String userIDPath, String password, String dbServer, String dbFile) {
        this.userIDPath = userIDPath;
        this.password = password;
        this.dbServer = dbServer;
        this.dbFile = dbFile;
    }

    public synchronized void runNotes() {
        this.rl = new ReservationList();
        Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.session = Session.newInstance();
            Registration registration = this.session.createRegistration();
            registration.switchToID(this.userIDPath, this.password);
            Database db = this.session.getDatabase(this.dbServer, this.dbFile);
            log.fine("TITLE[" + db.getTitle() + "],dayStr[" + this.dayStr + "]");
            DocumentCollection docs = db.search(this.getSelectPhrase(this.criteria));
            log.fine("found notes data count[" + docs.getCount() + "]");
            int i = 0;
            while (i < docs.getCount()) {
                Document doc = docs.getNthDocument(i + 1);
                Reservation rs = new Reservation();
                this.setReservation(rs, doc);
                if (rs.getCreater() == null || rs.getUser() == null || rs.getPlace() == null) {
                    log.info("invalid reservation found - not add " + rs);
                } else {
                    this.rl.add(rs);
                    log.finest("added " + rs);
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.severe("error occured " + e.getClass().getName() + " : " + e.getMessage());
            this.error_occured = true;
            this.occured_ex = e;
        }
    }

    public ReservationList getReservationList() {
        return this.rl;
    }

    public void setRoomSearchCriteria(RoomSearchCriteria criteria) {
        this.criteria = criteria;
    }

    public boolean hasError() {
        return this.error_occured;
    }

    public Exception getOccuredException() {
        return this.occured_ex;
    }

    public abstract String[] getMeetingRooms();

    public abstract String[] getReceptionRooms();

    public abstract String[] getRooms();

    protected abstract String getSelectPhrase(String var1);

    protected abstract String getSelectPhrase(RoomSearchCriteria var1);

    protected abstract String makeDayStr(String var1, String var2, String var3);

    protected abstract void setReservation(Reservation var1, Document var2);

    public abstract String getDateFormat();
}

