/*
 * Decompiled with CFR 0.152.
 */
package mtroom.notes;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import lotus.notes.DateTime;
import lotus.notes.Document;
import lotus.notes.NotesException;
import mtroom.Reservation;
import mtroom.RoomSearchCriteria;
import mtroom.notes.MeetingRoom;

public class MeetingRoomOak
extends MeetingRoom {
    private static final String DATE_FORMAT = "yyyy/MM/dd";

    @Deprecated
    public MeetingRoomOak(String userIDPath, String password, String dbServer, String dbFile, String year, String month, String day) {
        super(userIDPath, password, dbServer, dbFile, year, month, day);
    }

    public MeetingRoomOak(String userIDPath, String password, String dbServer, String dbFile) {
        super(userIDPath, password, dbServer, dbFile);
    }

    @Override
    public String[] getMeetingRooms() {
        return null;
    }

    @Override
    public String[] getReceptionRooms() {
        return null;
    }

    @Override
    public String[] getRooms() {
        return null;
    }

    @Override
    protected String getSelectPhrase(String dayStr) {
        return "SELECT ( @Date(Date ) = @Date(" + dayStr + ") )";
    }

    @Override
    protected String getSelectPhrase(RoomSearchCriteria criteria) {
        Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        StringBuffer phrase = new StringBuffer();
        phrase.append("SELECT (");
        phrase.append("(  @Date(Date) >= @Date(" + this.makeDayStr(criteria.getDateFrom()) + ")" + " & @Date(Date) <= @Date(" + this.makeDayStr(criteria.getDateTo()) + ")  )");
        phrase.append(" &(  time1 >= \"" + this.getTimeStr(criteria.getTimeFrom()) + "\"" + " &  time2 <= \"" + this.getTimeStr(criteria.getTimeTo()) + "\")");
        if (criteria.getRoomName() != null && criteria.getRoomName().length() > 0) {
            phrase.append(" &(  place = \"" + criteria.getRoomName() + "\")");
        }
        phrase.append(")");
        log.fine("search phrase=" + phrase.toString());
        return phrase.toString();
    }

    private String makeDayStr(Calendar cal) {
        return this.makeDayStr(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    private String makeDayStr(int year, int month, int day) {
        return this.makeDayStr(Integer.toString(year), Integer.toString(month), Integer.toString(day));
    }

    @Override
    protected String makeDayStr(String year, String month, String day) {
        return String.valueOf(year) + ";" + month + ";" + day;
    }

    @Override
    protected void setReservation(Reservation rs, Document doc) {
        try {
            rs.setCreater(doc.getItemValueString("creater"));
            rs.setDate(this.convertDate(doc.getFirstItem("date").getDateTimeValue()));
            rs.setPlace(doc.getItemValueString("place"));
            rs.setTel1(doc.getItemValueString("tel1"));
            rs.setTime1(doc.getItemValueString("time1"));
            rs.setTime2(doc.getItemValueString("time2"));
            rs.setUser(doc.getItemValueString("user"));
            rs.setKanriBumon(doc.getItemValueString("kanri_bumon"));
        }
        catch (NotesException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private String getTimeStr(Calendar calendar) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        return df.format(calendar.getTime());
    }

    private Date convertDate(DateTime dt) throws ParseException, NotesException {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        return df.parse(dt.getDateOnly());
    }

    @Override
    public String getDateFormat() {
        return DATE_FORMAT;
    }
}

