/*
 * Decompiled with CFR 0.152.
 */
package mtroom.notes;

import java.util.logging.Logger;
import lotus.notes.Database;
import lotus.notes.DateTime;
import lotus.notes.Document;
import lotus.notes.Item;
import lotus.notes.NotesException;
import lotus.notes.NotesThread;
import lotus.notes.Registration;
import lotus.notes.Session;
import lotus.notes.View;
import mtroom.MeetingRoomReserver;
import mtroom.Reservation;
import mtroom.notes.NotesDateTypeUtil;

public class OakMeetingRoomReserver
implements MeetingRoomReserver {
    private String userIDPath;
    private String password;
    private String dbServer;
    private String dbFile;
    private static long SERVER_WAIT_TIME = 30000L;
    private long waitTime = SERVER_WAIT_TIME;
    private Reservation reservation;

    public OakMeetingRoomReserver(String userIDPath, String password, String dbServer, String dbFile) {
        this.userIDPath = userIDPath;
        this.password = password;
        this.dbServer = dbServer;
        this.dbFile = dbFile;
    }

    @Override
    public void reserve(Reservation reservation) {
        Logger log = Logger.getLogger(this.getClass().getName());
        this.reservation = reservation;
        RoomThread room = new RoomThread(this.userIDPath, this.password, reservation, this.dbServer, this.dbFile);
        room.start();
        try {
            room.join(this.waitTime);
        }
        catch (InterruptedException e) {
            log.severe("Notes server access interrupted");
            throw new IllegalThreadStateException("server access interrupted");
        }
    }

    public String getDateStr() {
        return NotesDateTypeUtil.formatDate(this.reservation.getDate());
    }

    public class RoomThread
    extends NotesThread {
        private String userIDPath;
        private String password;
        private Reservation reservation;
        private String dbServer;
        private String dbFile;

        private RoomThread() {
        }

        public RoomThread(String userIDPath, String password, Reservation reservation, String dbServer, String dbFile) {
            this.userIDPath = userIDPath;
            this.password = password;
            this.reservation = reservation;
            this.dbServer = dbServer;
            this.dbFile = dbFile;
        }

        public void runNotes() throws NotesException {
            Session session = Session.newInstance();
            Registration reg = session.createRegistration();
            reg.switchToID(this.userIDPath, this.password);
            Database db = session.getDatabase(this.dbServer, this.dbFile);
            Document doc = db.createDocument();
            Item author = doc.replaceItemValue("From", (Object)session.getUserName());
            author.setAuthors(true);
            doc.replaceItemValue("Date", (Object)session.createDateTime(OakMeetingRoomReserver.this.getDateStr()));
            doc.replaceItemValue("creater", (Object)this.getKanjiName(session, this.dbServer));
            DateTime create = session.createDateTime("Now");
            create.setNow();
            doc.replaceItemValue("create", (Object)create);
            this.setReserveToDoc(doc);
            doc.save();
        }

        public void setReserveToDoc(Document doc) throws NotesException {
            doc.replaceItemValue("Form", (Object)"\u4f1a\u8b70\u5ba4\uff08\u793e\u5185\u5229\u7528\uff09\u4e88\u7d04");
            doc.replaceItemValue("Time1", (Object)this.reservation.getTime1());
            doc.replaceItemValue("Time2", (Object)this.reservation.getTime2());
            doc.replaceItemValue("place", (Object)this.reservation.getPlace());
            doc.replaceItemValue("tuuka", (Object)"\u25cb");
            doc.replaceItemValue("Kanri_bumon", (Object)this.reservation.getKanriBumon());
            doc.replaceItemValue("USER", (Object)this.reservation.getUser());
            doc.replaceItemValue("mokuteki", (Object)this.reservation.getPurpose());
            doc.replaceItemValue("riyosha", (Object)this.reservation.getNumOfPeople());
            doc.replaceItemValue("tel1", (Object)this.reservation.getTel1());
        }

        private String getKanjiName(Session session, String dbserver) throws NotesException {
            Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
            Database adbook = session.getDatabase(dbserver, "names.nsf");
            adbook.open();
            View view = adbook.getView("people2");
            Document doc = view.getDocumentByKey((Object)session.getUserNameObject().getAbbreviated());
            if (doc == null) {
                throw new IllegalAccessError("cannot get Kanji name from notes");
            }
            return doc.getItemValueString("KanjiName");
        }
    }
}

