/*
 * Decompiled with CFR 0.152.
 */
package uiDaySchedule;

import commonData.CommonStatic;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DayScheduleHeader
extends JPanel {
    static final long serialVersionUID = 0L;
    private final double xBase;
    private final int dayHeader1;
    private final int dayHeader2;
    private final int headerHeight = 22;
    private final int startHH;
    private final int endHH;

    public DayScheduleHeader(String yyyy, String mm, String dd, int startHH, int endHH, double xBase, int dayHeader1, int dayHeader2) {
        this.startHH = startHH;
        this.endHH = endHH;
        this.xBase = xBase;
        this.dayHeader1 = dayHeader1;
        this.dayHeader2 = dayHeader2;
        this.setLayout(null);
        HeaderTitle title = new HeaderTitle(String.valueOf(mm) + "\u6708" + dd + "\u65e5", this.calcPreferrdWidth(), 22);
        this.add(title);
        this.setPreferredSize(new Dimension(this.calcPreferrdWidth(), 22));
    }

    protected int calcPreferrdWidth() {
        return this.dayHeader1 + this.dayHeader2 + (int)(this.xBase * (double)(this.endHH - this.startHH) * 60.0);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        float[] dist = new float[]{0.0f, 0.5f, 1.0f};
        Color startEndColor = new Color(200, 200, 230);
        Color[] colors = new Color[]{startEndColor, new Color(255, 255, 255), startEndColor};
        LinearGradientPaint grad = new LinearGradientPaint(0.0f, 10.0f, this.getPreferredSize().width, 10.0f, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2.setPaint(grad);
        g2.fillRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
        this.initTimeLabel(g, this.startHH, this.endHH, this.xBase, this.dayHeader1, this.dayHeader2);
    }

    private void initTimeLabel(Graphics g, int startHH, int endHH, double xBase, int dayHeader1, int dayHeader2) {
        int i = startHH;
        while (i < endHH) {
            g.setColor(new Color(80, 80, 90));
            g.setFont(new Font("ITALIC", 0, 10));
            g.drawString(Integer.toString(i), dayHeader1 + dayHeader2 + (int)(xBase * 60.0 * (double)(i - startHH)) - 4, 20);
            ++i;
        }
    }

    private class HeaderTitle
    extends JLabel {
        static final long serialVersionUID = 0L;

        HeaderTitle(String title, int width, int height) {
            this.setForeground(CommonStatic.standardChar);
            this.setFont(new Font("MS\u30b4\u30b7\u30c3\u30af", 0, 12));
            this.setText(title);
            this.setBounds(DayScheduleHeader.this.calcPreferrdWidth() / 2 - 40, 0, 100, 12);
            this.setOpaque(false);
        }
    }
}

