/*
 * Decompiled with CFR 0.152.
 */
package uiDaySchedule;

import commonData.CommonStatic;
import commonData.GhostGrassPane;
import commonData.UserInfo;
import commonData.YyyyMmHolder;
import jScheduleData.AllUserJScheduleData;
import jScheduleData.HolidayInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JLayeredPane;
import javax.swing.border.LineBorder;
import scheduleData.ScheduleData;
import uiMonthSchedule.MonthSchedulePanel3Listener;
import uiOneSchedule.ScheduleJLabel4;

public class DaySchedulePanel
extends JLayeredPane {
    static final long serialVersionUID = 0L;
    protected final double xBase;
    protected final double yBase;
    protected final int dayHeader1;
    protected final int dayHeader2;
    protected static final int headerHeight = 10;
    protected final int startHH;
    protected final int endHH;
    protected YyyyMmHolder currentMonth;
    protected String dd;
    protected UserInfo currentUserInfo;
    protected ArrayList<UserInfo> userInfoList;
    protected AllUserJScheduleData aujsd;
    protected HolidayInfo holidayInfo;
    protected MonthSchedulePanel3Listener msp3l;
    protected ScheduleJLabel4 selectedScheduleJLabel3;
    protected ScheduleJLabel4 beforeSelectedScheduleJLabel3;
    protected HashMap<String, ArrayList<ScheduleJLabel4>> allUserSjl3 = new HashMap();
    protected GhostGrassPane ggp;

    public DaySchedulePanel(double xBase, double yBase, int dayHeader1, int dayHeader2, int startHH, int endHH, String yyyy, String mm, String dd, UserInfo currentUserInfo, ArrayList<UserInfo> userInfoList, AllUserJScheduleData aujsd, HolidayInfo holidayInfo, MonthSchedulePanel3Listener msp3l) {
        this.xBase = xBase;
        this.yBase = yBase;
        this.dayHeader1 = dayHeader1;
        this.dayHeader2 = dayHeader2;
        this.startHH = startHH;
        this.endHH = endHH;
        this.currentMonth = new YyyyMmHolder(yyyy, mm);
        this.dd = dd;
        this.currentUserInfo = currentUserInfo;
        this.userInfoList = userInfoList;
        this.aujsd = aujsd;
        this.holidayInfo = holidayInfo;
        this.msp3l = msp3l;
        this.initDaySchedulePanel();
    }

    private void initDaySchedulePanel() {
        this.setBackground(new Color(250, 250, 255));
        this.setOpaque(true);
        LineBorder border = new LineBorder(CommonStatic.borderColor);
        this.setBorder(border);
        this.setLayout(null);
        this.setPreferredSize(this.calcPreferrdSize());
    }

    private Dimension calcPreferrdSize() {
        int width = (int)((double)(this.dayHeader1 + this.dayHeader2) + this.xBase * (double)(this.endHH - this.startHH) * 60.0);
        int height = (int)((double)this.userInfoList.size() * this.yBase);
        return new Dimension(width, height);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.GRAY);
        int height = this.userInfoList.size();
        this.fillLunchTime(g, height);
        this.drawXLine(g, height);
        this.drawYLine(g, height);
        this.drawUserNameString(g, this.userInfoList);
    }

    private void fillLunchTime(Graphics g, int height) {
        g.setColor(CommonStatic.colorOfLunchTime);
        g.fillRect((int)((double)(this.dayHeader1 + this.dayHeader2) + this.xBase * 60.0 * (double)(12 - this.startHH)), 0, (int)(this.xBase * 60.0), (int)(this.yBase * (double)height));
    }

    private void drawXLine(Graphics g, int height) {
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(this.dayHeader1, 0, this.dayHeader1, (int)(this.yBase * (double)height));
        g.drawLine(this.dayHeader1 + this.dayHeader2, 0, this.dayHeader1 + this.dayHeader2, (int)(this.yBase * (double)height));
        int x = this.startHH;
        while (x <= this.endHH) {
            g.drawLine((int)(this.xBase * (double)(x - this.startHH) * 60.0 + (double)(this.dayHeader1 + this.dayHeader2)), 0, (int)(this.xBase * (double)(x - this.startHH) * 60.0 + (double)(this.dayHeader1 + this.dayHeader2)), (int)(this.yBase * (double)height));
            ++x;
        }
    }

    private void drawYLine(Graphics g, int height) {
        g.setColor(new Color(0, 0, 30));
        int y = 1;
        while (y <= height) {
            g.drawLine(0, (int)(this.yBase * (double)y), (int)(this.xBase * (double)(this.endHH - this.startHH) * 60.0 + (double)this.dayHeader1 + (double)this.dayHeader2), (int)(this.yBase * (double)y));
            ++y;
        }
    }

    private void drawUserNameString(Graphics g, ArrayList<UserInfo> userInfoList) {
        int count = 0;
        for (UserInfo userInfo : userInfoList) {
            g.drawString(userInfo.getUserName(), 3, (int)(this.yBase * (double)count + this.yBase - 5.0));
            ++count;
        }
    }

    public ScheduleJLabel4 getSjl4(ScheduleData sd, UserInfo userInfo) {
        if (this.allUserSjl3.containsKey(userInfo.getUserId())) {
            ArrayList<ScheduleJLabel4> sjl3List = this.allUserSjl3.get(userInfo.getUserId());
            for (ScheduleJLabel4 sjl3 : sjl3List) {
                if (!sjl3.getScheduleData().compare(sd)) continue;
                return sjl3;
            }
        }
        return null;
    }
}

