/*
 * Decompiled with CFR 0.152.
 */
package uiDaySchedule;

import commonData.GhostGrassPane;
import commonData.UserInfo;
import jScheduleData.AllUserJScheduleData;
import jScheduleData.HolidayInfo;
import jScheduleData.JScheduleData;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import scheduleData.ScheduleData;
import uiDaySchedule.DaySchedulePanel;
import uiMonthSchedule.MonthSchedulePanel3Listener;
import uiOneSchedule.ScheduleJLabel3;
import uiOneSchedule.ScheduleJLabel3Listener;
import uiOneSchedule.ScheduleJLabel4;

public class DaySchedulePanelImp
extends DaySchedulePanel
implements MouseListener,
ScheduleJLabel3Listener {
    static final long serialVersionUID = 0L;

    public DaySchedulePanelImp(double xBase, double yBase, int dayHeader1, int dayHeader2, int startHH, int endHH, String yyyy, String mm, String dd, UserInfo currentUserInfo, ArrayList<UserInfo> userInfoList, AllUserJScheduleData aujsd, HolidayInfo holidayInfo, MonthSchedulePanel3Listener msp3l) {
        super(xBase, yBase, dayHeader1, dayHeader2, startHH, endHH, yyyy, mm, dd, currentUserInfo, userInfoList, aujsd, holidayInfo, msp3l);
        this.addTodaySchedule(yyyy, mm, dd, userInfoList, aujsd);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.getClickCount() == 1) {
                this.msp3l.notifyScheduleSelectOff();
            } else {
                e.getClickCount();
            }
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.msp3l.notifyRightClicked();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void selectOn(ScheduleData sd, UserInfo userInfo) {
        ScheduleJLabel4 sjl3 = this.getSjl4(sd, userInfo);
        if (sjl3 != null) {
            sjl3.selectOn();
            this.selectedScheduleJLabel3 = sjl3;
            this.moveToFront(sjl3);
        }
    }

    public void selectOff(ScheduleData sd, UserInfo userInfo) {
        ScheduleJLabel4 sjl3 = this.getSjl4(sd, userInfo);
        if (sjl3 != null) {
            sjl3.selectOff();
            if (this.selectedScheduleJLabel3 != null) {
                this.beforeSelectedScheduleJLabel3 = this.selectedScheduleJLabel3;
                this.selectedScheduleJLabel3 = null;
            }
            this.moveToBack(sjl3);
        }
    }

    @Override
    public void requestRemove(ScheduleJLabel3 sjl3, boolean copyOrMove) {
        this.msp3l.notifyDndMoveSchedule(sjl3.getScheduleData(), sjl3.getUserInfo());
    }

    @Override
    public void notifyLeftSelected(ScheduleJLabel3 sjl3) {
        this.msp3l.notifyScheduleSelectOn(sjl3.getScheduleData(), sjl3.getUserInfo());
    }

    @Override
    public void notifyRightSelected(ScheduleJLabel3 sjl3, int x, int y) {
        this.msp3l.notifyRightClicked();
    }

    @Override
    public void notifyMiddleDoubleClicked(ScheduleJLabel3 sjl3) {
        ScheduleData sd = (ScheduleData)sjl3.getScheduleData().clone();
        sd.getS_date().incrementMm();
        sd.getE_date().incrementMm();
        UserInfo userInfo = sjl3.getUserInfo();
        this.msp3l.notifyAddSchedule(sd, userInfo);
    }

    @Override
    public void notifyDndStart(String updateMode, GhostGrassPane ggp, Point point) {
        this.ggp = ggp;
    }

    private void addTodaySchedule(String yyyy, String mm, String dd, ArrayList<UserInfo> userInfoList, AllUserJScheduleData aujsd) {
        for (UserInfo userInfo : userInfoList) {
            JScheduleData jsd = aujsd.getJScheduleData(userInfo);
            if (jsd == null) continue;
            ArrayList<ScheduleData> sdList = jsd.getDayScheduleList(yyyy, mm, dd);
            for (ScheduleData sd : sdList) {
                this.addSchedule(sd, userInfo);
            }
        }
    }

    private void addSchedule(ScheduleData scheduleData, UserInfo userInfo) {
        this.addSchedule(scheduleData, userInfo, false);
    }

    public void addSchedule(ScheduleData scheduleData, UserInfo userInfo, boolean selectFlag) {
        if (!this.isCurrentDay(scheduleData)) {
            return;
        }
        int userOffsetNo = 0;
        Iterator i = this.userInfoList.iterator();
        while (i.hasNext()) {
            if (userInfo.getUserId().equals(((UserInfo)i.next()).getUserId())) break;
            ++userOffsetNo;
        }
        ScheduleJLabel4 sjl3 = new ScheduleJLabel4(this, scheduleData, userInfo, this.xBase, this.yBase, this.dayHeader1, this.dayHeader2, this.startHH, this.endHH, userOffsetNo, this.currentUserInfo);
        if (this.allUserSjl3.containsKey(userInfo.getUserId())) {
            ((ArrayList)this.allUserSjl3.get(userInfo.getUserId())).add(sjl3);
        } else {
            ArrayList<ScheduleJLabel4> sjl3List = new ArrayList<ScheduleJLabel4>();
            sjl3List.add(sjl3);
            this.allUserSjl3.put(userInfo.getUserId(), sjl3List);
        }
        this.add(sjl3);
        this.moveToFront(sjl3);
        this.repaint();
    }

    private boolean isCurrentDay(ScheduleData sd) {
        return this.currentMonth.getYyyy().equals(sd.getS_date().getYyyy()) && this.currentMonth.getMm().equals(sd.getS_date().getMm()) && this.dd.equals(sd.getS_date().getDd());
    }

    public void delSchedule(ScheduleData sd, UserInfo userInfo) {
        if (this.allUserSjl3.containsKey(userInfo.getUserId())) {
            ArrayList sjl3List = (ArrayList)this.allUserSjl3.get(userInfo.getUserId());
            for (ScheduleJLabel3 sjl3 : sjl3List) {
                if (!sjl3.getScheduleData().compare(sd)) continue;
                sjl3List.remove(sjl3);
                this.remove(sjl3);
                this.revalidate();
                this.repaint();
                return;
            }
        }
    }
}

