/*
 * Decompiled with CFR 0.152.
 */
package uiMonthSchedule;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import uiMonthSchedule.ArrowPanelListener;

public class ArrowPanel
extends JPanel
implements MouseListener {
    static final long serialVersionUID = 0L;
    private ArrowPanelListener apl;
    private final int arrowKind;

    public ArrowPanel(ArrowPanelListener apl, int arrowKind) {
        this.apl = apl;
        this.arrowKind = arrowKind;
        this.setBackground(new Color(230, 230, 240));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(30, 20));
        this.addMouseListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.arrowKind == 1) {
            g.setColor(new Color(50, 50, 120));
            g.fillPolygon(this.createRightArrowPolygon());
            g.setColor(new Color(100, 100, 200));
            g.drawPolygon(this.createRightArrowPolygon());
        } else {
            g.setColor(new Color(50, 50, 120));
            g.fillPolygon(this.createLeftArrowPolygon());
            g.setColor(new Color(100, 100, 200));
            g.drawPolygon(this.createLeftArrowPolygon());
        }
    }

    private Polygon createRightArrowPolygon() {
        int[] xList = new int[]{5, 15, 15, 29, 15, 15, 5};
        int[] yList = new int[]{6, 6, 1, 10, 19, 14, 14};
        int count = 7;
        return new Polygon(xList, yList, count);
    }

    private Polygon createLeftArrowPolygon() {
        int[] xList = new int[]{1, 15, 15, 25, 25, 15, 15};
        int[] yList = new int[]{10, 1, 6, 6, 14, 14, 19};
        int count = 7;
        return new Polygon(xList, yList, count);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        System.out.println(String.valueOf(e.getClass().toString()) + "count is " + e.getClickCount());
        this.apl.notifyClicked(this.arrowKind);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(new Cursor(12));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

