/*
 * Decompiled with CFR 0.152.
 */
package uiUserInfo;

import commonData.UserInfo;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import uiUserInfo.UserInfoPanelListener;

public class UserInfoPanel
extends JPanel
implements TreeSelectionListener {
    static final long serialVersionUID = 0L;
    private JTree userTree;
    private UserInfoPanelListener uipl;

    public UserInfoPanel(UserInfo userInfo, UserInfoPanelListener uipl) {
        this.uipl = uipl;
        this.initControlPanel(userInfo);
    }

    private void initControlPanel(UserInfo userInfo) {
        this.userTree = new JTree(userInfo);
        this.userTree.setFont(new Font("MS\u30b4\u30b7\u30c3\u30af", 0, 12));
        this.userTree.addSelectionRow(0);
        this.userTree.addTreeSelectionListener(this);
        this.add(this.userTree);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] treePathList = e.getPaths();
        ArrayList<UserInfo> addUserInfoList = new ArrayList<UserInfo>();
        ArrayList<UserInfo> remUserInfoList = new ArrayList<UserInfo>();
        int i = 0;
        while (i < treePathList.length) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePathList[i].getLastPathComponent();
            if (node != null) {
                UserInfo userInfo = (UserInfo)node.getUserObject();
                if (e.isAddedPath(i)) {
                    addUserInfoList.add(userInfo);
                } else {
                    remUserInfoList.add(userInfo);
                }
            }
            ++i;
        }
        this.uipl.notifySelectedUserChanged(addUserInfoList, remUserInfoList);
    }
}

