/*
 * Decompiled with CFR 0.152.
 */
package workMasterData;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import workMasterData.Assignment;
import workMasterData.PhaseInfoList2;
import workMasterData.PhaseInfoList2DigesterCtl;

public class PhaseInfoListMap {
    HashMap<String, PhaseInfoList2> phaseInfoListMap = new HashMap();

    public int readPhaseNames(ArrayList<String> fileNameList) {
        Iterator<String> i = fileNameList.iterator();
        while (i.hasNext()) {
            PhaseInfoList2DigesterCtl phDigester = new PhaseInfoList2DigesterCtl();
            String fileName = i.next();
            PhaseInfoList2 phaseInfoList = phDigester.executeParse(fileName);
            if (phaseInfoList != null) {
                this.phaseInfoListMap.put(fileName, phaseInfoList);
                continue;
            }
            System.err.println("executeParse failed :" + fileName);
        }
        return 0;
    }

    public PhaseInfoList2 getPhaseInfoList(String fileName) {
        if (this.phaseInfoListMap.containsKey(fileName)) {
            return this.phaseInfoListMap.get(fileName);
        }
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.warning("fileName is faild :" + fileName);
        return null;
    }

    public ArrayList<String> getAssignmentNameList(ArrayList<String> phaseFileNameList) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, Assignment> assignmentMap = new HashMap<String, Assignment>();
        for (String fileName : phaseFileNameList) {
            PhaseInfoList2 phaseInfoList = this.getPhaseInfoList(fileName);
            HashMap<String, Assignment> wkMap = phaseInfoList.getAllAssignmentMap();
            Set<String> wkNameList = wkMap.keySet();
            for (String wkAssignmentName : wkNameList) {
                if (assignmentMap.containsKey(wkAssignmentName)) continue;
                assignmentMap.put(wkAssignmentName, wkMap.get(wkAssignmentName));
            }
        }
        Set resultMapList = assignmentMap.keySet();
        Iterator k = resultMapList.iterator();
        while (k.hasNext()) {
            result.add((String)k.next());
        }
        return result;
    }

    public ArrayList<String> getPhaseNameList(ArrayList<String> phaseFileNameList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String fileName : phaseFileNameList) {
            PhaseInfoList2 phaseInfoList = this.getPhaseInfoList(fileName);
            result.addAll(phaseInfoList.getAllPhaseNameList());
        }
        return result;
    }

    public ArrayList<String> getUpperLevelPhaseNameList(ArrayList<String> phaseFileNameList, int wbsLevel) {
        ArrayList<String> result = new ArrayList<String>();
        for (String fileName : phaseFileNameList) {
            PhaseInfoList2 phaseInfoList = this.getPhaseInfoList(fileName);
            if (phaseInfoList == null) continue;
            result.addAll(phaseInfoList.getUpperLevelPhaseNameList(wbsLevel));
        }
        return result;
    }

    public ArrayList<String> getPhaseNameList(ArrayList<String> phaseFileNameList, ArrayList<String> assignmentList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String fileName : phaseFileNameList) {
            PhaseInfoList2 phaseInfoList = this.getPhaseInfoList(fileName);
            result.addAll(phaseInfoList.getAllPhaseNameList(assignmentList));
        }
        return result;
    }

    public ArrayList<String> getPhaseNameListByUpperPhase(ArrayList<String> phaseFileNameList, String upperPhase) {
        ArrayList<String> result = new ArrayList<String>();
        for (String fileName : phaseFileNameList) {
            PhaseInfoList2 phaseInfoList = this.getPhaseInfoList(fileName);
            result.addAll(phaseInfoList.getPhaseNameListWithUppserPhase(upperPhase));
        }
        return result;
    }

    public String getUpperPhaseName(ArrayList<String> phaseFileNameList, String phaseName, int wbsLevel) {
        String result = "";
        for (String fileName : phaseFileNameList) {
            PhaseInfoList2 phaseInfoList = this.getPhaseInfoList(fileName);
            result = phaseInfoList.getPhaseNameWBSLevel(phaseName, wbsLevel);
            if (result.equals("")) continue;
            return result;
        }
        return phaseName;
    }
}

