/*
 * Decompiled with CFR 0.152.
 */
package workMasterData;

import java.util.ArrayList;
import java.util.Iterator;
import workMasterData.PhaseInfoListMap;
import workMasterData.PhaseListFile;
import workMasterData.ProjectCode;
import workMasterData.WorkInfoListMap;
import workMasterData.WorkListFile;

public class ProjectCodeList {
    ArrayList<ProjectCode> projectCodeList = new ArrayList();

    public ArrayList<ProjectCode> getProjectCodeList() {
        return this.projectCodeList;
    }

    public void setProject_code(ProjectCode projectCode) {
        this.projectCodeList.add(projectCode);
    }

    public ArrayList<String> getAllPhaseNameFileList() {
        ArrayList<String> phaseNameFileList = new ArrayList<String>();
        for (ProjectCode projectCode : this.projectCodeList) {
            for (PhaseListFile phaseListFile : projectCode.getPhaseListFileList()) {
                String fileName = phaseListFile.getFile_name();
                if (phaseNameFileList.contains(fileName)) continue;
                phaseNameFileList.add(fileName);
            }
        }
        return phaseNameFileList;
    }

    public ArrayList<String> getPhaseNameFileList(String targetCode) {
        ArrayList<String> phaseNameFileList = new ArrayList<String>();
        for (ProjectCode projectCode : this.projectCodeList) {
            if (!projectCode.getCode().equals(targetCode)) continue;
            for (PhaseListFile phaseListFile : projectCode.getPhaseListFileList()) {
                String fileName = phaseListFile.getFile_name();
                if (phaseNameFileList.contains(fileName)) continue;
                phaseNameFileList.add(fileName);
            }
        }
        return phaseNameFileList;
    }

    public ArrayList<String> getPhaseNameFileListByPrjCodeName(String targetCodeName) {
        ArrayList<String> phaseNameFileList = new ArrayList<String>();
        for (ProjectCode projectCode : this.projectCodeList) {
            if (!projectCode.getCodeName().equals(targetCodeName)) continue;
            for (PhaseListFile phaseListFile : projectCode.getPhaseListFileList()) {
                String fileName = phaseListFile.getFile_name();
                if (phaseNameFileList.contains(fileName)) continue;
                phaseNameFileList.add(fileName);
            }
        }
        return phaseNameFileList;
    }

    public ArrayList<String> getAllWorkNameFileList() {
        ArrayList<String> workNameFileList = new ArrayList<String>();
        for (ProjectCode projectCode : this.projectCodeList) {
            for (WorkListFile workListFile : projectCode.getWorkListFileList()) {
                String fileName = workListFile.getFile_name();
                if (workNameFileList.contains(fileName)) continue;
                workNameFileList.add(fileName);
            }
        }
        return workNameFileList;
    }

    public ArrayList<String> getWorkNameFileList(String targetCode) {
        ArrayList<String> workNameFileList = new ArrayList<String>();
        for (ProjectCode projectCode : this.projectCodeList) {
            if (!projectCode.getCode().equals(targetCode)) continue;
            for (WorkListFile workListFile : projectCode.getWorkListFileList()) {
                String fileName = workListFile.getFile_name();
                if (workNameFileList.contains(fileName)) continue;
                workNameFileList.add(fileName);
            }
        }
        return workNameFileList;
    }

    public ArrayList<String> getAllProjectCodeList() {
        ArrayList<String> result = new ArrayList<String>();
        for (ProjectCode projectCode : this.projectCodeList) {
            result.add(projectCode.getCode());
        }
        return result;
    }

    public ArrayList<String> getAllProjectCodeNameList() {
        ArrayList<String> result = new ArrayList<String>();
        for (ProjectCode projectCode : this.projectCodeList) {
            result.add(projectCode.getCodeName());
        }
        return result;
    }

    public String getProjectCodeName(String targetProjectCode) {
        for (ProjectCode projectCode : this.projectCodeList) {
            if (!projectCode.getCode().equals(targetProjectCode)) continue;
            return projectCode.getCodeName();
        }
        return targetProjectCode;
    }

    public String getProjectName(String targetProjectCode) {
        for (ProjectCode projectCode : this.projectCodeList) {
            if (!projectCode.getCode().equals(targetProjectCode)) continue;
            return projectCode.getName();
        }
        return "";
    }

    public ArrayList<String> makePhaseNameList(PhaseInfoListMap phaseInfoListMap, String projectCode) {
        ArrayList<String> result = new ArrayList<String>();
        for (String phaseListFileName : this.getPhaseNameFileList(projectCode)) {
            if (phaseInfoListMap.getPhaseInfoList(phaseListFileName) == null) continue;
            result.addAll(phaseInfoListMap.getPhaseInfoList(phaseListFileName).getAllPhaseNameList());
        }
        return result;
    }

    public ArrayList<String> makePhaseNameListByCodeName(PhaseInfoListMap phaseInfoListMap, String projectCodeName) {
        ArrayList<String> result = new ArrayList<String>();
        for (String phaseListFileName : this.getPhaseNameFileListByPrjCodeName(projectCodeName)) {
            if (phaseInfoListMap.getPhaseInfoList(phaseListFileName) == null) continue;
            result.addAll(phaseInfoListMap.getPhaseInfoList(phaseListFileName).getAllPhaseNameList());
        }
        return result;
    }

    public ArrayList<String> makeWorkNameList(WorkInfoListMap workInfoListMap, String projectCode) {
        ArrayList<String> result = new ArrayList<String>();
        for (String workListFileName : this.getWorkNameFileList(projectCode)) {
            if (workInfoListMap.getWorkInfoList(workListFileName) == null) continue;
            result.addAll(workInfoListMap.getWorkInfoList(workListFileName).getAllNameList());
        }
        return result;
    }

    public void printAll() {
        int count = 0;
        for (ProjectCode projectCode : this.projectCodeList) {
            System.out.println("[" + count + "] code:" + projectCode.getCode() + ", name:" + projectCode.getName());
            int pCount = 0;
            Iterator<PhaseListFile> j = projectCode.getPhaseListFileList().iterator();
            while (j.hasNext()) {
                System.out.println("   phase[" + pCount + "] " + j.next().getFile_name());
                ++pCount;
            }
            int wCount = 0;
            Iterator<WorkListFile> k = projectCode.getWorkListFileList().iterator();
            while (k.hasNext()) {
                System.out.println("   work[" + wCount + "] " + k.next().getFile_name());
                ++wCount;
            }
            ++count;
        }
    }
}

