# Copyright (c) 2008 Movable Type ACME Plugin Project, All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

package Lou;
use strict;

use Acme::Lou;
my $lou = undef;

sub get_lou {
    $lou if $lou;

	my $plugin = MT->component('Lou');
    $lou = new Acme::Lou(
		mecab_charset =>
        $plugin->get_config_value('mecab_charset') || 'utf-8'
	);
}

sub _fltr_translate {
    my ($str, $val, $ctx) = @_;

	my $rate = int($val);
	if ($rate <= 1 || $rate >= 100) {
		$rate = 100;
	}

    my $lou = &get_lou;
    $lou->translate($str, {
		is_html      => 1,
		lou_rate     => $rate,
		html_fx_rate => 100,
    });
}

1;
