# Copyright (c) 2008 Movable Type ACME Plugin Project, All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

package Lovers::App::Mote;
use strict;

sub source_rebuilding {
	my ($cb, $app, $tmpl) = @_;
	my $plugin = $app->component('Lovers');
	my $blog_id = $app->param('blog_id');
	my ($old, $new);

	if (my $text = $app->param('text')) {
		if ($text =~ m/<mt:?mote([^>]*)>(.*)<\/mt:?mote>/is) {
			$app->session('lovers_message', $2);

			my $args = $1;
			$args =~ m/type\s*=\s*"?(\w+)/is;
			$app->session('lovers_type', $1 || '');
		}
	}

	my $msg = $app->session('lovers_message');
	my $type = $app->session('lovers_type') || 'heat';

	if (! $msg) {
		return;
	}

	my $uri = $app->static_path . 'plugins/Lovers/icon/' . $type . '.gif';

	if ($type eq 'persistent') {
		$new = <<__EOF__;
<style type="text/css">
div.msg-publishing {
    background-color:#FFFFFF;
	background-image: none;
}
</style>
__EOF__
	}
	else {
		$new = <<__EOF__;
<style type="text/css">
div.msg-publishing {
    background-color:#FFFFFF;
    background-image:url($uri);
}
</style>
__EOF__
	}
	$old = '<mt:if name="is_one_index">';
	$$tmpl =~ s/($old)/$new\n$1/;

    $old = '\s+<__trans phrase="Publishing.*';
    $new = $msg;

	if ($type eq 'persistent') {
		require MT::Util;
		$new =
			'<script type="text/javascript">' .
			join('', map({
				$_ =~ s/^\s*|\s*$//gs;
				if ($_) {
					"alert('" . MT::Util::encode_js($_) . "');\n";
				}
				else {
					'';
				}
			} split(/\n/, $new))) .
			'</script>';
	}
	else {
		$new =~ s/^\s*|\s*$//gs;
		$new =~ s/\r?\n/<br>/g;
		$new =~ s/([\w._-~]+@[\w._-~]+)/<a href="$1">$1<\/a>/;
	}

	$$tmpl =~ s/($old)/$new/g;
}

sub _hdlr_popular_with {
    my($ctx, $args, $cond) = @_;
	my $app = MT->instance;
	my $plugin = MT->component('Lovers');

    my $res = '';
    my $builder = $ctx->stash('builder');
    my $tokens = $ctx->stash('tokens');

    defined($res = $builder->build($ctx, $tokens, $cond))
        or return $ctx->error( $builder->errstr );

	$app->session(
        'lovers_message',
        $res || $plugin->translate('My heart begins to throb...')
    );
	$app->session('lovers_type', $args->{'type'} || '');
}

sub post_build {
	my ($cb) = @_;

	my $app = MT->instance;
	my $msg = $app->session('lovers_message', '');
	my $type = $app->session('lovers_type', '');
}

1;
