<?php
# Copyright (c) 2009 Movable Type ACME Plugin Project, All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

global $mt;
$ctx = &$mt->context();
$tags = array(
	'manifestadditionalcategories', 'manifestassets', 'manifestatomid',
	'manifestaudio', 'manifestauthor', 'manifestauthordisplayname',
	'manifestauthoremail', 'manifestauthorid', 'manifestauthorlink',
	'manifestauthornickname', 'manifestauthorurl', 'manifestauthorusername',
	'manifestauthoruserpic', 'manifestauthoruserpicasset', 'manifestauthoruserpicurl',
	'manifestbasename', 'manifestblogdescription', 'manifestblogid',
	'manifestblogname', 'manifestblogurl', 'manifestbody',
	'manifestcategories', 'manifestcategory', 'manifestclass',
	'manifestclasslabel', 'manifestcommentcount', 'manifestcreateddate',
	'manifestcustomfielddescription', 'manifestcustomfieldname', 'manifestcustomfieldvalue',
	'manifestcustomfields', 'manifestdate', 'manifesteditlink',
	'manifestembedcode', 'manifestexcerpt', 'manifestflag',
	'manifestid', 'manifestifallowcomments', 'manifestifallowpings',
	'manifestifcategory', 'manifestifcommentsopen', 'manifestifextended',
	'manifestiftagged', 'manifestkeywords', 'manifestlink',
	'manifestlinkurl', 'manifestmodifieddate', 'manifestmore',
	'manifestnext', 'manifestpermalink', 'manifestphoto',
	'manifestposttype', 'manifestprevious', 'manifestrank',
	'manifestrawposttype', 'manifestrecommendvotelink', 'manifestrecommendedtotal',
	'manifestscore', 'manifestscoreavg', 'manifestscorecount',
	'manifestscorehigh', 'manifestscorelow', 'manifeststatus',
	'manifesttags', 'manifesttitle', 'manifesttrackbackcount',
	'manifesttrackbackdata', 'manifesttrackbackid', 'manifesttrackbacklink',
);
foreach ($tags as $t) {
	$p = new ManifestProxy($t);
	$ctx->add_tag($t, array($p, 'tag'));
}

class ManifestProxy {
	var $tag;
	function ManifestProxy($tag) {
		$this->tag = str_replace('manifest', 'entry', strtolower($tag));
	}

	function tag($args, &$ctx) {
		return $ctx->tag($this->tag, $args);
	}
}
