/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.date;

/**
 * <p>
 * Initializes time as {@link System#currentTimeMillis()} fixedly within
 * {@link ThreadLocal}.
 * </p>
 * <p>
 * {@link DateHelper} does NOT have destructive methods. This current time is
 * never destroyed in the {@link Thread}.
 * </p>
 * 
 * @see DateHelper
 * @author mtzky
 * @since 0.1.9
 */
public final class ThreadLocalDateHelper extends DateHelper {

	private static final ThreadLocal<Long> TIME_MILLIS = new ThreadLocal<Long>() {
		@Override
		protected Long initialValue() {
			return System.currentTimeMillis();
		};
	};

	/**
	 * <p>
	 * Initializes time as {@link System#currentTimeMillis()} fixedly within
	 * {@link ThreadLocal}.
	 * </p>
	 */
	public ThreadLocalDateHelper() {
		super(TIME_MILLIS.get());
	}

	@Override
	public long getTimeMillis() {
		return TIME_MILLIS.get();
	}

}
