/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.date;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateHelper
implements Comparable<DateHelper>,
Cloneable {
    private static final int[] FIELDS = new int[]{1, 2, 5, 11, 12, 13, 14};
    private static TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    private static Locale DEFAULT_LOCALE = Locale.getDefault();
    private static int DEFAULT_FIRST_DAY_OF_WEEK = 1;
    private TimeZone timeZone = DEFAULT_TIME_ZONE;
    private Locale locale = DEFAULT_LOCALE;
    private int firstDayOfWeek = DEFAULT_FIRST_DAY_OF_WEEK;
    private final long timeMillis;

    public DateHelper() {
        this(System.currentTimeMillis());
    }

    public DateHelper(long timeMillis) {
        this.timeMillis = timeMillis;
    }

    public DateHelper(int ... args) {
        this(DEFAULT_TIME_ZONE, DEFAULT_LOCALE, args);
    }

    public DateHelper(TimeZone timeZone, int ... args) {
        this(timeZone, DEFAULT_LOCALE, args);
    }

    public DateHelper(Locale locale, int ... args) {
        this(DEFAULT_TIME_ZONE, locale, args);
    }

    public DateHelper(TimeZone timeZone, Locale locale, int ... args) {
        this(DateHelper.buildCalendar(timeZone, locale, args), locale);
    }

    private static Calendar buildCalendar(TimeZone timeZone, Locale locale, int ... args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        if (FIELDS.length < args.length) {
            throw new IllegalArgumentException("too many args: " + Arrays.toString(args));
        }
        Calendar cal = Calendar.getInstance(timeZone, locale);
        cal.setTimeInMillis(0L);
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            cal.set(FIELDS[i], args[i]);
        }
        return cal;
    }

    public DateHelper(Date date) {
        this(date.getTime());
    }

    public DateHelper(Calendar calendar) {
        this(calendar, DEFAULT_LOCALE);
    }

    public DateHelper(Calendar calendar, Locale locale) {
        this(calendar.getTimeInMillis());
        this.timeZone = calendar.getTimeZone();
        this.locale = locale;
        this.firstDayOfWeek = calendar.getFirstDayOfWeek();
    }

    public final DateHelper add(int field, int amount) {
        Calendar cal = this.getCalendar();
        cal.add(field, amount);
        return new DateHelper(cal).setLocale(this.locale);
    }

    public final DateHelper roll(int field, int amount) {
        Calendar cal = this.getCalendar();
        cal.roll(field, amount);
        return new DateHelper(cal).setLocale(this.locale);
    }

    public final DateHelper set(int field, int value) {
        Calendar cal = this.getCalendar();
        cal.set(field, value);
        return new DateHelper(cal).setLocale(this.locale);
    }

    public final DateHelper truncate(int field) {
        Calendar cal = this.getCalendar();
        switch (field) {
            case 0: {
                cal.set(1, 0);
            }
            case 1: {
                cal.set(2, 0);
            }
            case 2: 
            case 3: 
            case 4: {
                switch (field) {
                    case 3: 
                    case 4: {
                        int first = cal.getFirstDayOfWeek();
                        int current = cal.get(7);
                        if (current < first) {
                            cal.add(5, first - current - 7);
                            break;
                        }
                        cal.add(5, first - current);
                        break;
                    }
                    default: {
                        cal.set(5, 1);
                    }
                }
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                switch (field) {
                    case 9: 
                    case 10: {
                        if (cal.get(9) == 1) {
                            cal.set(11, 12);
                            break;
                        }
                    }
                    default: {
                        cal.set(11, 0);
                    }
                }
            }
            case 11: {
                cal.set(12, 0);
            }
            case 12: {
                cal.set(13, 0);
            }
            case 13: {
                cal.set(14, 0);
            }
            case 14: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported field: " + field);
            }
        }
        return new DateHelper(cal).setLocale(this.locale);
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public final Calendar getCalendar() {
        Calendar cal = Calendar.getInstance(this.timeZone, this.locale);
        cal.setFirstDayOfWeek(this.firstDayOfWeek);
        cal.setTimeInMillis(this.getTimeMillis());
        return cal;
    }

    public final Date getDate() {
        return new Date(this.getTimeMillis());
    }

    public final java.sql.Date getSqlDate() {
        return new java.sql.Date(this.getTimeMillis());
    }

    public final Timestamp getSqlTimestamp() {
        return new Timestamp(this.getTimeMillis());
    }

    public final Time getSqlTime() {
        return new Time(this.getTimeMillis());
    }

    public String format() {
        return this.format(2, 2);
    }

    public String format(int dateStyle, int timeStyle) {
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle, this.locale).format(this.getDate());
    }

    public String format(String pattern) {
        return new SimpleDateFormat(pattern, this.locale).format(this.getDate());
    }

    public static void setDefaultLocale(Locale defaultLocale) {
        if (defaultLocale == null) {
            throw new NullPointerException("defaultLocale");
        }
        DEFAULT_LOCALE = defaultLocale;
    }

    public static void setDefaultTimeZone(TimeZone defaultTimeZone) {
        if (defaultTimeZone == null) {
            throw new NullPointerException("defaultTimeZone");
        }
        DEFAULT_TIME_ZONE = defaultTimeZone;
    }

    public static void setDefaultFirstDayOfWeek(int defaultFirstDayOfWeek) {
        if (defaultFirstDayOfWeek < 1 || 7 < defaultFirstDayOfWeek) {
            throw new IllegalArgumentException("out of bounds:" + defaultFirstDayOfWeek);
        }
        DEFAULT_FIRST_DAY_OF_WEEK = defaultFirstDayOfWeek;
    }

    public DateHelper setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        this.locale = locale;
        return this;
    }

    public DateHelper setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timeZone");
        }
        this.timeZone = timeZone;
        return this;
    }

    public DateHelper setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek < 1 || 7 < firstDayOfWeek) {
            throw new IllegalArgumentException("out of bounds:" + firstDayOfWeek);
        }
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [");
        sb.append("timeMillis=").append(this.getTimeMillis());
        sb.append(", timeZone=").append(this.timeZone);
        sb.append(", locale=").append(this.locale);
        sb.append(", firstDayOfWeek=").append(this.firstDayOfWeek);
        sb.append("] ");
        sb.append(this.format(0, 0));
        return sb.toString();
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Long.valueOf(this.getTimeMillis()).hashCode();
        result = 31 * result + this.timeZone.hashCode();
        result = 31 * result + this.locale.hashCode();
        result = 31 * result + this.firstDayOfWeek;
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateHelper)) {
            return false;
        }
        DateHelper other = (DateHelper)obj;
        if (this.getTimeMillis() != other.getTimeMillis()) {
            return false;
        }
        if (!this.timeZone.equals(other.timeZone)) {
            return false;
        }
        if (!this.locale.equals(other.locale)) {
            return false;
        }
        return this.firstDayOfWeek == other.firstDayOfWeek;
    }

    @Override
    public final int compareTo(DateHelper dateHelper) {
        long another;
        long thisVal = this.getTimeMillis();
        return thisVal < (another = dateHelper.getTimeMillis()) ? -1 : (thisVal == another ? 0 : 1);
    }

    public final DateHelper clone() {
        return new DateHelper(this.getTimeMillis()).setTimeZone(this.timeZone).setLocale(this.locale).setFirstDayOfWeek(this.firstDayOfWeek);
    }
}

