/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lang;

public abstract class ThreadUtils {
    public static StackTraceElement getCallingStackTraceElement() {
        return ThreadUtils.getStackTrace(4);
    }

    public static String getCallingMethodName() {
        return ThreadUtils.getStackTrace(4).getMethodName();
    }

    public static String getCallingClassName() {
        return ThreadUtils.getStackTrace(4).getClassName();
    }

    public static StackTraceElement getOwnStackTraceElement() {
        return ThreadUtils.getStackTrace(3);
    }

    public static String getOwnMethodName() {
        return ThreadUtils.getStackTrace(3).getMethodName();
    }

    public static String getOwnClassName() {
        return ThreadUtils.getStackTrace(3).getClassName();
    }

    public static String getOwnSimpleClassName() {
        String className = ThreadUtils.getStackTrace(3).getClassName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    protected static StackTraceElement getStackTrace(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("level");
        }
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        if (st.length < level) {
            throw new UnsupportedOperationException("StackTraceElement");
        }
        return st[level];
    }
}

