/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.log;

import java.util.ArrayList;
import org.mtzky.io.SPrintWriter;
import org.mtzky.lang.UtilConstractedAssertionError;

public class DumpUtils {
    private DumpUtils() {
        throw new UtilConstractedAssertionError(DumpUtils.class);
    }

    public static String hex(String string) {
        SPrintWriter w = new SPrintWriter();
        byte[] bytes = string.getBytes();
        int byteLen = bytes.length;
        int digit = Integer.toString(byteLen, 16).length();
        String lineFormat = "%0" + digit + "X:";
        for (int i = 0; i < byteLen; ++i) {
            if (i % 16 == 0) {
                w.print(String.format(lineFormat, i));
            }
            w.print(String.format(" %02X", bytes[i]));
            if (i % 16 != 15) continue;
            w.print("  ");
            w.print(DumpUtils.text(bytes, i - 15, i + 1));
            w.println();
        }
        int remainder = byteLen % 16;
        if (remainder != 0) {
            for (int i = 0; i < 16 - remainder; ++i) {
                w.print("   ");
            }
            w.print("  ");
            w.print(DumpUtils.text(bytes, byteLen - remainder, byteLen));
            w.println();
        }
        return ((Object)w).toString();
    }

    private static String text(byte[] bytes, int f, int t) {
        ArrayList<Byte> buff = new ArrayList<Byte>(16);
        for (int i = f; i < t; ++i) {
            char c = (char)bytes[i];
            buff.add((byte)(Character.isWhitespace(c) ? 46 : (int)c));
        }
        byte[] text = new byte[buff.size()];
        int i = 0;
        for (Byte c : buff) {
            text[i++] = c;
        }
        return new String(text);
    }
}

