/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.reflect;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.mtzky.io.IOUtils;
import org.mtzky.lang.IterableUtils;
import org.mtzky.log.GenericMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class PackageDesc {
    private static final Logger LOG = LoggerFactory.getLogger(PackageDesc.class);
    private static final Set<JavaFileObject.Kind> KINDS = EnumSet.of(JavaFileObject.Kind.CLASS);
    private static final IterableUtils.Find<Class<?>> ALL = new IterableUtils.Find<Class<?>>(){

        @Override
        public boolean call(Class<?> value) {
            return true;
        }
    };
    private final List<Class<?>> classes;

    public PackageDesc(String packageName) throws IOException, ClassNotFoundException {
        this(packageName, ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageDesc(String packageName, IterableUtils.Find<Class<?>> filter) throws IOException, ClassNotFoundException {
        if (packageName == null) {
            throw new NullPointerException("packageName");
        }
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new IllegalStateException("Running in a JRE, but a JDK is required.");
        }
        String p = packageName.endsWith(".") ? packageName : packageName + '.';
        StringBuilder classpath = new StringBuilder();
        classpath.append(System.getProperty("java.class.path", ""));
        for (ClassLoader cl : new ClassLoader[]{ClassLoader.getSystemClassLoader(), Thread.currentThread().getContextClassLoader()}) {
            if (cl instanceof URLClassLoader) {
                URL[] urls;
                for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                    try {
                        classpath.append(File.pathSeparatorChar).append(new File(url.toURI()).getCanonicalPath());
                    }
                    catch (URISyntaxException e) {
                        String fmt = "FAILED to parse classpath: %s";
                        LOG.warn((Marker)GenericMarker.FAILED_TO_PARSE, String.format("FAILED to parse classpath: %s", url), (Throwable)e);
                    }
                }
                continue;
            }
            LOG.warn((Marker)GenericMarker.FAILED_TO_PARSE, "NOT URLClassLoader: {}", (Object)cl);
        }
        StandardJavaFileManager manager = null;
        try {
            ArrayList classes = new ArrayList();
            manager = compiler.getStandardFileManager(new DiagnosticCollector(), null, null);
            if (0 < classpath.length()) {
                List<String> cps = Arrays.asList(classpath.toString());
                if (!manager.handleOption("-classpath", cps.iterator())) {
                    LOG.warn((Marker)GenericMarker.FAILED_TO_ADD, "FAILED to add classpath: '{}'", (Object)classpath);
                } else if (LOG.isDebugEnabled((Marker)GenericMarker.ADD)) {
                    LOG.debug((Marker)GenericMarker.ADD, "add classpath: '{}'", (Object)classpath);
                }
            }
            for (JavaFileObject obj : manager.list(StandardLocation.CLASS_PATH, packageName, KINDS, false)) {
                String n = obj.getName();
                Class<?> c = Class.forName(p + n.substring(0, n.lastIndexOf(46)));
                if (!filter.call(c)) continue;
                classes.add(c);
            }
            this.classes = Collections.unmodifiableList(classes);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(manager);
            throw throwable;
        }
        IOUtils.closeQuietly(manager);
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }

    public <T> Class<T> findClass(IterableUtils.Find<Class<?>> callback) {
        return IterableUtils.each(this.classes, callback);
    }
}

