/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.mtzky.lang.IterableUtils;
import org.mtzky.reflect.PropDesc;

public class PropsDesc {
    private final PropDesc[] descs;

    public PropsDesc(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        HashMap<String, PropDesc> descs = new HashMap<String, PropDesc>();
        for (Class<?> c = clazz; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Method method : c.getMethods()) {
                if (method.getAnnotation(annotationClass) == null) continue;
                PropDesc desc = new PropDesc(method);
                descs.put(desc.getName(), desc);
            }
            for (AccessibleObject accessibleObject : c.getFields()) {
                String name;
                if (((Field)accessibleObject).getAnnotation(annotationClass) == null || descs.containsKey(name = ((Field)accessibleObject).getName())) continue;
                descs.put(name, new PropDesc(name, (Field)accessibleObject));
            }
        }
        this.descs = descs.values().toArray(new PropDesc[descs.size()]);
        descs.clear();
    }

    public PropDesc[] getDescriptors() {
        return this.descs;
    }

    public <T> T[] wrap(IterableUtils.Wrap<PropDesc, T> cb, T ... type) {
        return IterableUtils.each(this.descs, cb, type);
    }

    public PropDesc find(IterableUtils.Find<PropDesc> cb) {
        return IterableUtils.each(this.descs, cb);
    }

    public static interface FindCallback
    extends IterableUtils.Find<PropDesc> {
    }

    public static interface WrapCallback<T>
    extends IterableUtils.Wrap<PropDesc, T> {
    }
}

