<?php
/*
 * ̾Ρmu_PdfFunctions
 * СVer.0.1.3beta
 * ơpdfؿȤʤPDF
 * ưĶPHP4ʹ (ɬ:mbstring,PCRE 侩:zlib,GD)
 * 2002/11/27
 * 2003/03/07
 * ԡR.Sakamoto
 * Copyright (c) 2002-2003 YDS. All rights reserved.
 * 饤󥹡LGPL
 * ۸http://www.mula-net.com/mulib/
 *
 * Υ饹饤֥LGPLǸƤޤ
 * 饤ʸޤ४ꥸʥϾ嵭ΥȤɤƤ
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//-------------------------------------
//Ķ˹碌ưʲꤷƤ

//AFMեΥѥ
if (!defined("MU_PDF_FONTPATH"))
	define("MU_PDF_FONTPATH", dirname(__FILE__)."/fonts");

//-------------------------------------

class mu_PdfFunctions {

	var $a_pdf;		//PDFѤξ
	var $a_font;	//եȥեξ

//󥹥ȥ饯
function mu_PdfFunctions () {
	$this->sub_init();
}

//
function sub_init() {
	$this->a_pdf['INFO']['PRODUCER']	= "mu_PdfFunctions (Ver.0.1.3beta)";
	$this->a_pdf['INFO']['TITLE']		= "";
	$this->a_pdf['INFO']['AUTHOR']		= "";
	$this->a_pdf['INFO']['CREATOR']		= "";
	$this->a_pdf['INFO']['SUBJECT']		= "";
	$this->a_pdf['INFO']['KEYWORDS']	= "";
	$this->a_pdf['VAL']['PAGE']			= 0;
	$this->a_pdf['VAL']['FONTSIZE']		= 12;	//ߤʸ
	$this->a_pdf['VAL']['FONT']			= 1;	//ߤΥեֹ
	$this->a_pdf['PAR']['FONTNAME']		= "";	//ߤΥե̾
	$this->a_pdf['VAL']['CHARSPACING']	= 0;	//ʸֳ
	$this->a_pdf['VAL']['TEXTRENDERING']= 0;	//ƥȥ󥰥⡼(07ޤǤ)
	$this->a_pdf['VAL']['TEXTX']		= 0;	//ƥxɸ
	$this->a_pdf['VAL']['TEXTY']		= 0;	//ƥyɸ
	$this->a_pdf['VAL']['COMPRESS']		= 6;	//Ψ
	$this->a_pdf['stream']		= "";			//ߤΥڡstream
	$this->a_pdf['byte']		= 0;			//ϺѤߥХȿ
	$this->a_pdf['fonts']		= array("dummy");	//ե̾򥭡Ȥֹ֥
	$this->a_pdf['images']		= array();		//ID򥭡Ȥ
	$this->a_pdf['imageid']		= 0;			//ѺѤ߲ID
	$this->a_pdf['xref']		= array("");	//xref ֹ֥椬ͤեåȤ
	$this->a_pdf['page']		= array();		//ڡξ
	$this->a_pdf['index']		= array();		//̾򥭡ͤˤΥֹ֥
	//$this->a_pdf['outlines']	= array();		//ȥ饤
	$this->a_pdf['descendantfonts']	= array();	//DescendantFonts
	$this->a_pdf['FILE']['name']		= "";	//ϥե̾
	$this->a_pdf['FILE']['pointer']	= FALSE;	//ϥեΥݥ
	$this->a_pdf['FILE']['buffer']		= "";	//եʤ
	$this->a_pdf['FILE']['is_outside']	= FALSE;	//Ťؿؤб
	
	$this->a_font	= array();
	$this->sub_f_set_afm_path(MU_PDF_FONTPATH);	//AFMե
	
	return TRUE;
}

//----------------------------------------------------------------------------
//# ץ󡦥

//Ťؿ: եݥ󥿤äPDF򳫤
function pdf_open($p_fp) {
	$this->a_pdf['FILE']['is_outside']	= TRUE;
	$this->a_pdf['FILE']['name']		= "dummy";
	$this->a_pdf['FILE']['pointer']	= $p_fp;
	return TRUE;	//֤ͤ˰̣Ϥʤ
}

//PDFɥȤ
function pdf_new(){
	//Ȥȥ饹ˤʤäƤΤǡ̵֤̣ͤ
	return TRUE;
}

//ե򳫤
function pdf_open_file($p_pdf, $p_file = ""){
	$this->a_pdf['FILE']['name']	= $p_file;
	
	if (strval($p_file) == "") {
		$this->a_pdf['FILE']['pointer'] = FALSE;	//ե̾ȥǺ
		return TRUE;
	} else {
		$this->a_pdf['FILE']['pointer'] = fopen($p_file, "wb");
		return $this->a_pdf['FILE']['pointer'];	//pdf_open_fileؿǤϲ֤? intȽ񤤤Ƥä
	}
}

//PDFɥȤλž夲
function pdf_close($p_pdf){
	$this->sub_m_pages();
	$this->sub_m_info();
	$this->sub_m_trailer();
	if (empty($this->a_pdf['FILE']['is_outside'])) {
		if ($this->a_pdf['FILE']['pointer'])	fclose($this->a_pdf['FILE']['pointer']);
	}
	return TRUE;
}

//PDF֥Ȥκ(֤᤹)
function pdf_delete($p_pdf) {
	$this->sub_init();
}

//ХåեȤ֤
function pdf_get_buffer($p_pdf) {
	return $this->a_pdf['FILE']['buffer'];
}

//----------------------------------------------------------------------------
//# ѥ᡼Ϣ

//ե᡼
function pdf_set_info($p_pdf, $p_key, $p_str){
	$p_key = strtoupper($p_key);
	if(!ereg("^(TITLE|AUTHOR|CREATOR|SUBJECT|KEYWORDS)$", $p_key))
		return FALSE;
	$this->a_pdf['INFO'][$p_key] = $p_str;
	return TRUE;
}

//ʸˤѥ᡼
function pdf_set_parameter($p_pdf, $p_key, $p_string) {
	//ΤȤǤΤϤʤ
	//$p_key	= strtoupper($p_key);
	//$this->a_pdf['PAR'][$p_key]	= $p_string;
}

//ʸˤѥ᡼֤
function pdf_get_parameter($p_pdf, $p_key) {
	$p_key	= strtoupper($p_key);
	return @$this->a_pdf['PAR'][$p_key];
}

//ͤˤѥ᡼
function pdf_set_value($p_pdf, $p_key, $p_value) {
	$p_key = strtoupper($p_key);
	$this->a_pdf['VAL'][$p_key]	= $p_value;
}

//ͤˤѥ᡼֤
function pdf_get_value($p_pdf, $p_key) {
	$p_key = strtoupper($p_key);
	return @$this->a_pdf['VAL'][$p_key];
}

//----------------------------------------------------------------------------
//# ڡ

//ڡȥ
function pdf_begin_page($p_pdf, $p_width, $p_height){
	$p_width = +$p_width;
	$p_height = +$p_height;
	$this->a_pdf['VAL']['PAGE']++;
	if($this->a_pdf['VAL']['PAGE'] == 1) {
		$this->sub_fwrite("%PDF-1.3\n");
		$this->sub_fwrite("%\xFD\xFE\xF3\xFE\n");	//Хʥǧ뤿Υ
		$this->sub_m_fonts();	//եȥ꥽
	}
	$page	= $this->a_pdf['VAL']['PAGE'];
	$this->a_pdf['page'][$page]	= array(
		'width'		=> $p_width,
		'height'	=> $p_height,
		'stream'	=> "",
		'fonts'		=> array()
	);
	return TRUE;
}
function pdf_end_page($p_pdf){
	$stream	= gzcompress($this->a_pdf['stream'], $this->a_pdf['VAL']['COMPRESS']);
	$length	= strlen($stream);
	$no	= $this->sub_object("<</Length $length /Filter [/FlateDecode]>>\nstream\n$stream\nendstream");
	$this->a_pdf['page'][$this->a_pdf['VAL']['PAGE']]['stream']	= $no;
	$this->a_pdf['stream']	= "";
	return TRUE;
}

//----------------------------------------------------------------------------
//# եå

function pdf_translate($p_pdf, $p_x, $p_y){
	$p_x = round((float)$p_x, 5);
	$p_y = round((float)$p_y, 5);
	$this->sub_stream("1 0 0 1 $p_x $p_y cm ");
}
function pdf_scale($p_pdf, $p_x, $p_y){
	$p_x = round((float)$p_x, 5);
	$p_y = round((float)$p_y, 5);
	$this->sub_stream("$p_x 0 0 $p_y 0 0 cm ");
}
function pdf_rotate($p_pdf, $p_phi){
	$rad	= $p_phi * M_PI / 180;
	$cos	= round(cos($rad), 5);
	$sin	= round(sin($rad), 5);
	$nsin	= -$sin;
	$this->sub_stream("$cos $sin $nsin $cos 0 0 cm ");
}

function pdf_save($p_pdf)		{	$this->sub_stream("q ");	}
function pdf_restore($p_pdf)	{	$this->sub_stream("Q ");	}
function pdf_closepath($p_pdf)	{	$this->sub_stream("h ");	}
function pdf_clip($p_pdf)		{	$this->sub_stream("W n ");	}

//饤
function pdf_setlinewidth($p_pdf, $p_width){
	$p_width = round((float)$p_width, 2);
	$this->sub_stream("$p_width w ");
	return TRUE;
}
function pdf_setdash($p_pdf, $p_white, $p_black){
	$p_white = (int)$p_white;
	$p_black = (int)$p_black;
	if($p_white == 0 || $p_black == 0) {
		$this->sub_stream("[] 0 d ");	//
	} else {
		$this->sub_stream("[$p_black $p_white] 0 d ");
	}
	return TRUE;
}
function pdf_moveto($p_pdf, $p_x, $p_y){
	$p_x = round((float)$p_x, 2);
	$p_y = round((float)$p_y, 2);
	$this->sub_stream("$p_x $p_y m ");
	return TRUE;
}
function pdf_lineto($p_pdf, $p_x, $p_y){
	$p_x = round((float)$p_x, 2);
	$p_y = round((float)$p_y, 2);
	$this->sub_stream("$p_x $p_y l ");
	return TRUE;
}
function pdf_curveto($p_pdf, $p_x1, $p_y1, $p_x2, $p_y2, $p_x3, $p_y3) {
	$p_x1 = round((float)$p_x1, 2);
	$p_y1 = round((float)$p_y1, 2);
	$p_x2 = round((float)$p_x2, 2);
	$p_y2 = round((float)$p_y2, 2);
	$p_x3 = round((float)$p_x3, 2);
	$p_y3 = round((float)$p_y3, 2);
	$this->sub_stream("$p_x1 $p_y1 $p_x2 $p_y2 $p_x3 $p_y3 c ");
	return TRUE;
}
function pdf_circle($p_pdf, $p_x, $p_y, $p_r) {
	$p_x	= (float)$p_x;
	$p_y	= (float)$p_y;
	$p_r	= (float)$p_r;
	$x0	= round($p_x + $p_r, 2);
	$y0	= round($p_y, 2);
	$this->sub_stream("$x0 $y0 m ");	//ѥγ
	
	//ߤ4ĤΥ٥
	$t	= $p_r * .55228475;		//.55228475 = 4 * (sqrt(2) - 1) / 3
	$x1	= round($p_x + $p_r, 2);
	$y1	= round($p_y + $t, 2);
	$x2	= round($p_x + $t, 2);
	$y2	= round($p_y + $p_r, 2);
	$x3	= round($p_x, 2);
	$y3	= round($p_y + $p_r, 2);
	$this->sub_stream("$x1 $y1 $x2 $y2 $x3 $y3 c ");
	$x1	= round($p_x - $t, 2);
	$y1	= round($p_y + $p_r, 2);
	$x2	= round($p_x - $p_r, 2);
	$y2	= round($p_y + $t, 2);
	$x3	= round($p_x - $p_r, 2);
	$y3	= round($p_y, 2);
	$this->sub_stream("$x1 $y1 $x2 $y2 $x3 $y3 c ");
	$x1	= round($p_x - $p_r, 2);
	$y1	= round($p_y - $t, 2);
	$x2	= round($p_x - $t, 2);
	$y2	= round($p_y - $p_r, 2);
	$x3	= round($p_x, 2);
	$y3	= round($p_y - $p_r, 2);
	$this->sub_stream("$x1 $y1 $x2 $y2 $x3 $y3 c ");
	$x1	= round($p_x + $t, 2);
	$y1	= round($p_y - $p_r, 2);
	$x2	= round($p_x + $p_r, 2);
	$y2	= round($p_y - $t, 2);
	$x3	= round($p_x + $p_r, 2);
	$y3	= round($p_y, 2);
	$this->sub_stream("$x1 $y1 $x2 $y2 $x3 $y3 c ");
	return TRUE;
}
function pdf_rect($p_pdf, $p_x, $p_y, $p_w, $p_h ){
	$p_x = round((float)$p_x, 2);
	$p_y = round((float)$p_y, 2);
	$p_w = round((float)$p_w, 2);
	$p_h = round((float)$p_h, 2);
	$this->sub_stream("$p_x $p_y $p_w $p_h re ");
	return TRUE;
}
function pdf_stroke($p_pdf)	{	$this->sub_stream("S ");	}
function pdf_fill($p_pdf)	{	$this->sub_stream("f ");	}
function pdf_fill_stroke($p_pdf){	$this->sub_stream("b ");	}

//----------------------------------------------------------------------------
//# ʸ

//Ťؿ: եȤ
function pdf_set_font($p_pdf, $p_font, $p_size, $p_code, $p_embed = 0) {
	$fontno	= $this->pdf_findfont($p_pdf, $p_font, $p_code, $p_embed);
	if ($fontno)	$this->pdf_setfont($p_pdf, $fontno, $p_size);
	return TRUE;
}

//եȤѰ
function pdf_findfont($p_pdf, $p_fontname, $p_encoding, $p_embed = 0) {
	//$p_embedϺΤȤ̵
	$fontno	= count($this->a_pdf['fonts']);	//եȥ꥽ֹ
	
	$p_fontname	= ereg_replace("[^A-Za-z0-9_\-]", "", $p_fontname);
	$p_encoding	= ereg_replace("[^A-Za-z0-9_\-]", "", $p_encoding);
	if (ereg("(H|V)$", $p_encoding)) {	//CJKեȤȽ
		$encoding	= $p_encoding;
		switch ($p_fontname) {
			case "GothicBBB-Medium":
			case "HeiseiKakuGo-W5":
				$p_fontname	= "GothicBBB-Medium";
				$dscfont	= $this->a_pdf['descendantfonts'][$p_fontname];
				$fontname	= $p_fontname."-".$encoding;
				break;
			case "Ryumin-Light":
			case "HeiseiMin-W3":
			default:
				$p_fontname	= "Ryumin-Light";
				$dscfont	= $this->a_pdf['descendantfonts'][$p_fontname];
				$fontname	= $p_fontname."-".$encoding;
				break;
		}
		$objdat	= "<</Type /Font /Subtype /Type0 /Name /F$fontno /BaseFont /$fontname /Encoding /$encoding /DescendantFonts [$dscfont 0 R]>>";
	} else {	//ʸȽǡType1եȤȤ
		$fontname	= $p_fontname;
		switch ($p_encoding) {
			case "macroman":
				$encoding	= "MacRomanEncoding";
				break;
			case "winansi":
				$encoding	= "WinAnsiEncoding";
				break;
			case "host":
			case "builtin":
			default:
				$encoding	= "StandardEncoding";
		}
		$objdat	= "<</Type /Font /Subtype /Type1 /Name /F$fontno /BaseFont /$fontname /Encoding /$encoding>>";
	}
	
	//Ǥ¸ߤƤ餽ֹ֤
	if (!empty($this->a_pdf['fontindex'][$p_fontname][$encoding]))
		return $this->a_pdf['fontindex'][$p_fontname][$encoding];
	
	//եȤ
	$no	= $this->sub_object($objdat);
	$this->a_pdf['fonts'][$fontno]	= array('object'=>$no, 'fontname'=>$p_fontname, 'encoding'=>$encoding);
	$this->a_pdf['fontindex'][$p_fontname][$encoding]	= $fontno;
	return $fontno;
}

//եȤ
function pdf_setfont($p_pdf, $p_fontno, $p_size) {
	$this->a_pdf['VAL']['FONT']	= (int)$p_fontno;
	$this->a_pdf['VAL']['FONTSIZE']	= (float)$p_size;
	$this->a_pdf['PAR']['FONTNAME']	= @$this->a_pdf['fonts'][$p_fontno]['fontname'];
	$this->a_pdf['page'][$this->a_pdf['VAL']['PAGE']]['fonts'][$p_fontno]	= $p_fontno;
}

function pdf_stringwidth($p_pdf, $p_text){
	$width	= 0;
	$fontname	= @$this->a_pdf['fonts'][$this->a_pdf['VAL']['FONT']]['fontname'];
	$len	= mb_strlen($p_text);
	for ($i = 0; $i < $len; $i++) {
		$ch	= mb_substr($p_text, $i, 1);
		$width	+= $this->sub_f_get_charwidth($fontname, $ch);
	}
	return ($width * $this->a_pdf['VAL']['FONTSIZE'] / 1000);
	//ʲsub_f_̵ξ
	//return ($this->a_pdf['VAL']['FONTSIZE'] / 2 + $this->a_pdf['VAL']['CHARSPACING']) * strlen($p_text);
}

//ʸ
function pdf_set_text_pos($p_pdf, $p_x, $p_y ){
	$this->a_pdf['VAL']['TEXTX'] = (float)$p_x;
	$this->a_pdf['VAL']['TEXTY'] = (float)$p_y;
	return TRUE;
}

function pdf_show($p_pdf, $p_txt){
	if ($this->a_pdf['VAL']['FONTSIZE'] < 1)	$this->a_pdf['VAL']['FONTSIZE']	= 12;
	
	$p_txt	= $this->sub_escape_string($p_txt);
	$this->sub_stream("BT /F".$this->a_pdf['VAL']['FONT']." ".round($this->a_pdf['VAL']['FONTSIZE'], 2)." Tf ");
	$this->sub_stream(round($this->a_pdf['VAL']['TEXTX'], 2)." ".round($this->a_pdf['VAL']['TEXTY'], 2)." Td ");
	$this->sub_stream((+$this->a_pdf['VAL']['TEXTRENDERING'])." Tr ");
	$this->sub_stream((+$this->a_pdf['VAL']['CHARSPACING'])." Tc ");
	$this->sub_stream("($p_txt) Tj ");
	$this->sub_stream("ET ");
	return TRUE;
}

function pdf_show_xy($p_pdf, $p_txt, $p_x, $p_y){
	$this->a_pdf['VAL']['TEXTX'] = (float)$p_x;
	$this->a_pdf['VAL']['TEXTY'] = (float)$p_y;
	return $this->pdf_show($p_pdf, $p_txt);
}

function pdf_show_boxed($p_pdf, $p_txt, $p_x, $p_y, $p_width, $p_height, $p_hmode, $p_feature = ""){
	if (($p_width == 0) && ($height == 0))
		return $this->pdf_show_xy($p_pdf, $p_txt, $p_x, $p_y);
	
	$x	= $p_x;
	$y	= $p_y;
	$strwidth	= $this->pdf_stringwidth($p_pdf, $p_txt);
	$spacing	= $this->a_pdf['VAL']['CHARSPACING'];
	switch ($p_hmode) {
		case "right":
			$x = $p_x + ($p_width - $strwidth);
			break;
		case "center":
			$x = $p_x + (($p_width - $strwidth) / 2);
			break;
		case "justify":
			$len	= mb_strlen($p_txt);
			if ($len < 2) {
				//1ʸʲʤcenterƱ
				$x = $p_x + (($p_width - $strwidth) / 2);
			} else {
				$this->a_pdf['VAL']['CHARSPACING']	= ($p_width - $strwidth) / ($len - 1);
			}
			break;
		case "left":
		default:
	}
	$result	= $this->pdf_show_xy($p_pdf, $p_txt, $x, $y);
	$this->a_pdf['VAL']['CHARSPACING']	= $spacing;
	return $result;
}

//----------------------------------------------------------------------------
//# Ϣ

//
function pdf_setcolor($p_pdf, $p_type, $p_cspace, $p_c1, $p_c2 = "", $p_c3 = "", $p_c4 = "") {
	$p_c1	= round((float)$p_c1, 5);
	$p_c2	= round((float)$p_c2, 5);
	$p_c3	= round((float)$p_c3, 5);
	$p_c4	= round((float)$p_c4, 5);
	switch ($p_cspace) {
		case "gray":
			$color	= "$p_c1";
			$opf	= "g";
			$ops	= "G";
			break;
		case "rgb":
			$color	= "$p_c1 $p_c2 $p_c3";
			$opf	= "rg";
			$ops	= "RG";
			break;
			
		case "cmyk":
			$color	= "$p_c1 $p_c2 $p_c3 $p_c4";
			$opf	= "k";
			$ops	= "K";
			break;
		default:
			return;
	}
	switch ($p_type) {
		case "fill":
			$ope	= "$color $opf";
			break;
		case "stroke":
			$ope	= "$color $ops";
			break;
		case "both":
			$ope	= "$color $opf $color $ops";
			break;
		default:
			return;
	}
	$this->sub_stream("$ope ");
}

function pdf_setrgbcolor($p_pdf, $p_r, $p_g, $p_b){
	$this->pdf_setcolor($p_pdf, "both", "rgb", $p_r, $p_g, $p_b);
	return TRUE;
}
function pdf_setrgbcolor_stroke($p_pdf, $p_r, $p_g, $p_b){
	$this->pdf_setcolor($p_pdf, "stroke", "rgb", $p_r, $p_g, $p_b);
	return TRUE;
}
function pdf_setrgbcolor_fill($p_pdf, $p_r, $p_g, $p_b){
	$this->pdf_setcolor($p_pdf, "fill", "rgb", $p_r, $p_g, $p_b);
	return TRUE;
}
function pdf_setgray($p_pdf, $p_gray){
	$this->pdf_setcolor($p_pdf, "both", "gray", $p_gray);
	return TRUE;
}
function pdf_setgray_stroke($p_pdf, $p_gray){
	$this->pdf_setcolor($p_pdf, "stroke", "gray", $p_gray);
	return TRUE;
}
function pdf_setgray_fill($p_pdf, $p_gray){
	$this->pdf_setcolor($p_pdf, "fill", "gray", $p_gray);
	return TRUE;
}


//-------------------------------------
//# ᡼ؿ

function pdf_open_image_file($p_pdf, $p_imgtype, $p_file) {
	switch ($p_imgtype) {
		case 'jpeg':
			$img	= imageCreateFromJPEG($p_file);
			break;
		case 'png':
			$img	= imageCreateFromPNG($p_file);
			break;
		default:
			$img	= FALSE;
	}
	if (!$img)	return FALSE;
	
	$id	= $this->pdf_open_memory_image($p_pdf, $img);
	imageDestroy($img);
	return $id;
}

function pdf_open_memory_image($p_pdf, $p_img) {
	if (!$p_img)	return FALSE;
	
	$width	= imageSX($p_img);
	$height	= imageSY($p_img);
	if (!$width || !$height) {
		return FALSE;
	}
	
	$stream	= "";
	for ($y = 0; $y < $height; $y++) {
		for ($x = 0; $x < $width; $x++) {
			$colidx	= imageColorAt($p_img, $x, $y);
			$a_color	= imageColorsForIndex($p_img, $colidx);
			$stream	.= pack("C3", $a_color['red'], $a_color['green'], $a_color['blue']);
		}
	}
	
	$id	= ++$this->a_pdf['imageid'];
	
	if ($this->a_pdf['VAL']['COMPRESS'] > 0) {
		$stream	= gzcompress($stream, $this->a_pdf['VAL']['COMPRESS']);
		$filter	= " /Filter [/FlateDecode]";
	} else {
		//compressѥ᡼0Ȱ̤ʤ
		$filter	= "";
	}
	$length	= strlen($stream);
	$no	= $this->sub_object(
		"<</Type /XObject /Subtype /Image /Width $width /Height $height"
		." /ColorSpace /DeviceRGB /BitsPerComponent 8 /Length $length$filter>>"
		."\nstream\n$stream\nendstream"
	);
	$this->a_pdf['images'][$id]['object']	= $no;
	$this->a_pdf['images'][$id]['colorspace']	= 'rgb';
	$this->a_pdf['images'][$id]['width']	= $width;
	$this->a_pdf['images'][$id]['height']	= $height;
	return $id;
}

function pdf_place_image($p_pdf, $p_imgid, $p_x = 0, $p_y = 0, $p_width = NULL, $p_height = NULL) {
	if (!isset($this->a_pdf['images'][$p_imgid]))	return;
	
	if (is_null($p_height)) {
		if (is_null($p_width)) {
			$p_width	= '100%';
		} elseif (!ereg('%$', $p_width)) {
			//pdfؿߴ
			$p_width	= ($p_width * 100)."%";
		}
		$p_height	= $p_width;
	}
	
	if (ereg('%$', $p_width))
		$width	= $this->sub_get_float($this->a_pdf['images'][$p_imgid]['width'] * $p_width / 100);
	else
		$width	= $this->sub_get_float($p_width);
	if (ereg('%$', $p_height))
		$height	= $this->sub_get_float($this->a_pdf['images'][$p_imgid]['height'] * $p_height / 100);
	else
		$height	= $this->sub_get_float($p_height);
	$x	= $this->sub_get_float($p_x);
	$y	= $this->sub_get_float($p_y);
	
	$this->a_pdf['page'][$this->a_pdf['VAL']['PAGE']]['images'][$p_imgid]	= $p_imgid;
	$this->sub_stream(
		"q  $width 0 0 $height $x $y cm "
		."/Im$p_imgid Do "
		."Q "
	);
}

function pdf_close_image($p_pdf, $p_imgid) {
}

//----------------------------------------------------------------------------
//# ̤

//Ťؿ: ֥åޡɲ
function pdf_add_outline($p_pdf, $p_text, $p_parent = 0, $p_open = 0) {
	//$this->a_pdf['outlines'][]	= array('text'=>$p_text, 'page'=>$this->a_pdf['VAL']['PAGE']);
}

//֥åޡɲ
function pdf_add_bookmark($p_pdf, $p_text, $p_parent = 0, $p_open = 0) {
}

function pdf_continue_text($p_pdf, $p_txt){
}

//----------------------------------------------------------------------------
//# ؿ

function sub_object($p_data) {
	$no	= count($this->a_pdf['xref']);
	$this->a_pdf['xref'][$no]	= $this->a_pdf['byte'];
	$this->sub_fwrite("$no 0 obj\n$p_data\nendobj\n");
	return $no;
}

function sub_fwrite($p_data) {
	if (strlen($this->a_pdf['FILE']['name'])) {
		$this->a_pdf['byte']	+= fwrite($this->a_pdf['FILE']['pointer'], $p_data);
	} else {
		$this->a_pdf['FILE']['buffer']	.= $p_data;
		$this->a_pdf['byte']	+= strlen($p_data);
	}
}

function sub_stream($p_data) {
	$this->a_pdf['stream'] .= $p_data;
}

//ʸ()ǰϤ֤
function sub_escape_string($p_txt) {
	return preg_replace('/([\\(\\)\\\\])/', '\\\\\\1', $p_txt);
}

//ʸPDFDocEncodingǥ󥳡
function sub_pdfdocencode($p_txt) {
	return "\xFE\xFF".mb_convert_encoding($p_txt, "UTF-16");
}

//륪֥Ȥֹ֤
function sub_get_nextref() {
	return count($this->a_pdf['xref']);
}

//PDFѤμ¿֤
function sub_get_float($p_number) {
	//ñfloat˥㥹ȤȻؿˤʤǽ롣
	//ޤPDFǤͭʾ5ޤǤ餷
	return round((float) $p_number, 5);
}

//----------------------------------------------------------------------------
//# ؿ(٤Ȥʤ䤹뤿ΤʬΥ)

//եȥ꥽ν
function sub_m_fonts() {
	$sysinfo	= $this->sub_object("<</Registry (Adobe) /Ordering (Japan1) /Supplement 2>>");
	
	//ī ---------------------------------------------------------------
	$fndsc	= $this->sub_object("<</Type /FontDescriptor /FontName /Ryumin-Light /Flags 6 /Ascent 723 /CapHeight 709 /Descent -241 /XHeight 450 /ItalicAngle 0 /StemV 69 /FontBBox [-123 -257 1001 910] /Style <</Panose <010502020300000000000000>>>>>");
	$dscfn	= $this->sub_object("<</Type /Font /Subtype /CIDFontType0 /CIDSystemInfo $sysinfo 0 R /FontDescriptor $fndsc 0 R /BaseFont /Ryumin-Light /DW 1000>>");
	$this->a_pdf['descendantfonts']['Ryumin-Light']	= $dscfn;
	$this->sub_f_set_fontinfo('Ryumin-Light', 'charwidth', 1000);	//PDFlib˹碌ܸեȤƱ
	
	//å -----------------------------------------------------------
	$fndsc	= $this->sub_object("<</Type /FontDescriptor /FontName /GothicBBB-Medium /Flags 4 /Ascent 752 /CapHeight 737 /Descent -221 /XHeight 553 /ItalicAngle 0 /StemV 114 /FontBBox [-92 -250 1010 922] /Style <</Panose <0801020b0500000000000000>>>>>");
	$dscfn	= $this->sub_object("<</Type /Font /Subtype /CIDFontType0 /CIDSystemInfo $sysinfo 0 R /FontDescriptor $fndsc 0 R /BaseFont /GothicBBB-Medium /DW 1000>>");
	$this->a_pdf['descendantfonts']['GothicBBB-Medium']	= $dscfn;
	$this->sub_f_set_fontinfo('GothicBBB-Medium', 'charwidth', 1000);	//PDFlib˹碌ܸեȤƱ
}

//ʸ¤
function sub_m_pages() {
	//Catalog
	$outlines	= "";
	if (!empty($this->a_pdf['index']['outlines']))
		$outlines	= "/Outlines ".$this->a_pdf['index']['outlines']." 0 R ";
	$ref	= $this->sub_get_nextref() + 1;	//Υֹ֥(PagesΤ)
	$this->a_pdf['index']['catalog']
		= $this->sub_object("<</Type /Catalog {$outlines}/Pages $ref 0 R>>");
	
	//Pages
	$ref	= $this->sub_get_nextref();	//Υֹ֥(PageΤ)
	$count	= count($this->a_pdf['page']);
	$kids	= "";
	@reset($this->a_pdf['page']);
	while (list($page, $h_page) = each($this->a_pdf['page'])) {
		if ($page < 1)	continue;
		$kids	.= (++$ref)." 0 R ";
	}
	$this->a_pdf['index']['pages']
		= $this->sub_object("<</Type /Pages /Count $count /Kids [$kids]>>");
	
	//Page
	$ref	= $this->a_pdf['index']['pages'];
	@reset($this->a_pdf['page']);
	while (list($page, $h_page) = each($this->a_pdf['page'])) {
		$width	= $h_page['width'];
		$height	= $h_page['height'];
		$stream	= $h_page['stream'];
		
		$fonts	= "";
		@reset($h_page['fonts']);
		while (list($key, $fontno) = @each($h_page['fonts'])) {
			$object	= $this->a_pdf['fonts'][$fontno]['object'];
			$fonts	.= "/F$fontno $object 0 R";
		}
		if ($fonts != "")	$fonts	= " /Font <<$fonts>>";
		
		$images	= "";
		$a_imgset	= array();
		@reset($h_page['images']);
		while (list($key, $imgid) = @each($h_page['images'])) {
			$object	= $this->a_pdf['images'][$imgid]['object'];
			$images	.= "/Im$imgid $object 0 R";
			switch ($this->a_pdf['images'][$imgid]['colorspace']) {
				case 'gray':
					$a_imgset[0]	= " /ImageB";
					break;
				case 'rgb':
					$a_imgset[1]	= " /ImageC";
					break;
				case 'index':
					$a_imgset[2]	= " /ImageI";
					break;
			}
		}
		if ($images != "")	$images	= " /XObject <<$images>>";
		$imageset	= implode("", $a_imgset);
		
		$this->sub_object(
			"<</Type /Page /MediaBox [0 0 $width $height] /Contents $stream 0 R /Resources ".
			"<</ProcSet [/PDF /Text$imageset]$fonts$images>> ".
			"/Parent $ref 0 R>>"
		);
	}
}

//Info
function sub_m_info() {
	$title		= "";
	$subject	= "";
	$keywords	= "";
	$creator	= "";
	$author		= "";
	$producer	= "";
	if (!empty($this->a_pdf['INFO']['TITLE']))
		$title		= "/Title (".$this->sub_escape_string($this->sub_pdfdocencode($this->a_pdf['INFO']['TITLE'])).") ";
	if (!empty($this->a_pdf['INFO']['SUBJECT']))
		$subject	= "/Subject (".$this->sub_escape_string($this->sub_pdfdocencode($this->a_pdf['INFO']['SUBJECT'])).") ";
	if (!empty($this->a_pdf['INFO']['KEYWORDS']))
		$keywords	= "/Keywords (".$this->sub_escape_string($this->sub_pdfdocencode($this->a_pdf['INFO']['KEYWORDS'])).") ";
	if (!empty($this->a_pdf['INFO']['CREATOR']))
		$creator	= "/Creator (".$this->sub_escape_string($this->sub_pdfdocencode($this->a_pdf['INFO']['CREATOR'])).") ";
	if (!empty($this->a_pdf['INFO']['AUTHOR']))
		$author		= "/Author (".$this->sub_escape_string($this->sub_pdfdocencode($this->a_pdf['INFO']['AUTHOR'])).") ";
	if (!empty($this->a_pdf['INFO']['PRODUCER']))
		$producer	= "/Producer (".$this->sub_escape_string($this->sub_pdfdocencode($this->a_pdf['INFO']['PRODUCER'])).") ";
	$date		= "/CreationDate (D:".date("YmdHis").")";
	$this->a_pdf['index']['info']
		= $this->sub_object("<<{$title}{$subject}{$keywords}{$creator}{$author}{$producer}{$date}>>");
}

//xref&trailer
function sub_m_trailer() {
	$xrefoffset	= $this->a_pdf['byte'];
	$count	= $this->sub_get_nextref();
	$this->sub_fwrite("xref\n");
	$this->sub_fwrite("0 $count\n");
	$this->sub_fwrite("0000000000 65535 f \x0A");	//ե꡼ȥ
	@reset($this->a_pdf['xref']);
	while (list($no, $offset) = each($this->a_pdf['xref'])) {
		if ($no) {
			$this->sub_fwrite(sprintf("%010d %05d n \x0A", $offset, 0));	//楨ȥ
		}
	}
	$catalog	= $this->a_pdf['index']['catalog'];
	$info		= $this->a_pdf['index']['info'];
	$this->sub_fwrite("trailer\n");
	$this->sub_fwrite("<</Size $count /Root $catalog 0 R /Info $info 0 R>>\n");
	$this->sub_fwrite("startxref\n");
	$this->sub_fwrite("$xrefoffset\n");
	$this->sub_fwrite("%%EOF\n");
}

//----------------------------------------------------------------------------
//# AFMեؿ

//AFMեΤǥ쥯ȥե
function sub_f_set_afm_path($p_dir) {
	if (strval($p_dir) != "") {
		$dir = @opendir($p_dir);
		if ($dir) {
			while (strval($filename = readdir($dir)) != "") {
				if (eregi("(.*)\\.afm$", $filename, $a_regs)) {
					//$a_regs[1]Ȥϥե̾ΤϤ
					$this->a_font[$a_regs[1]]['file']	= realpath("$p_dir/$filename");
				}
			}
			closedir($dir);
			return TRUE;
		}
	}
	return FALSE;
}

//AFMեɤ߹
function sub_f_read_afm($p_font) {
	if (empty($this->a_font[$p_font]['file']))	return FALSE;
	
	$filename	= $this->a_font[$p_font]['file'];
	$fp	= fopen($filename, "r");
	if (!$fp) {
		unset($this->a_font[$p_font]);
		//$this->a_font[$p_font]['file']	= $filename;	//ɤ߹פʤϤ
		return FALSE;
	}
	
	$flag	= 0;
	$i		= 0;
	while (!feof($fp)) {
		$text	= fgets($fp, 1024);
		if ($flag)	{
			$i++;
			if (($i > $count) || preg_match("/EndCharMetrics/", $text)) {
				break;
			}
			$char	= "";
			$wx		= 0;
			if (preg_match("/\\bC\\s*(\\d+)/", $text, $a_regs))
				if ($a_regs[1] > 0)	$char	= sprintf("%c", $a_regs[1]);
			if (preg_match("/\\bCH\\s*\\<\\s*([A-Fa-f0-9]+)\\s*\\>/", $text, $a_regs))
				if ($a_regs[1] > 0)	$char	= sprintf("%c", hecdec($a_regs[1]));
			if (preg_match("/\\bWX\\s*(\\d+)/", $text, $a_regs))
				$wx	= (int) $a_regs[1];
			
			if (strlen($char))
				$this->a_font[$p_font]['metrics'][$char]	= array("WX"=>$wx);
		}
		if (preg_match("/StartCharMetrics\\s+(\\d+)/", $text, $a_regs)) {
			$count	= (int) $a_regs[1];
			$flag	= 1;
		}
	}
	fclose($fp);
	return TRUE;
}

//եȾ򥻥å
function sub_f_set_fontinfo($p_font, $p_key, $p_value) {
	$this->a_font[$p_font][$p_key]	= $p_value;
}

//եȤλꥳɤ֤
function sub_f_get_charwidth($p_font, $p_char) {
	$default	= mb_strwidth($p_char) * 500;
	
	if (($p_font == "") || ($p_char == ""))	return $default;
	
	if (!empty($this->a_font[$p_font]['charwidth']))	$default	= $this->a_font[$p_font]['charwidth'];
	
	if (empty($this->a_font[$p_font]['metrics'])) {
		if (!empty($this->a_font[$p_font]['file'])) {
			$this->sub_f_read_afm($p_font);	//afmե뤬äɤ߹
		} else {
			return $default;			//ʤäǥե֤ͤ
		}
	}
	if (empty($this->a_font[$p_font]['metrics'][$p_char]['WX']))	return $default;
	return $this->a_font[$p_font]['metrics'][$p_char]['WX'];
}

//----------------------------------------------------------------------------

}	//End of class
?>
