#ifndef __MULTI
#define __MULTI

#define ADVERTISE_IP	"230.3.3.3"
#define ADVERTISE_PORT	59000
#define SERVER_IP	"127.0.0.1"
#define SERVER_PORT	50000
#define DEFAULT_IP	"231.0.0."
#define INTERVAL        5               /* advertise interval */
#define MULTITTL	2
#define MAXBUF		1024
#define MAXCON		16
#define MAXCLIENT	255
#define EMPTY		MAXCLIENT
#define IDLENGTH	16
#define LOCKTIME	10
#define CALC_INTERVAL	3000		/* calcrate_interval */
#define RESEND_INTERVAL	10000		/* resend_interval */

#define ROW_MAX		4
#define COLUMN_MAX	4
#define TAB_MAX		16
#define TABGROUP_MAX	32
#define WINDOW_WIDTH	800
#define WINDOW_HEIGHT	600
#define EXWINDOW_WIDTH	600
#define EXWINDOW_HEIGHT 400
#define CONFIG_FILE	"/etc/multivnc/multivnc_server.conf"
#define CAST_PK_SIZE	1400

/* client state */
#define STAT_FIRST	0
#define STAT_ADV	1
#define STAT_VNC	2
#define STAT_CUT	3

/* state parameter */
#define LOCKSTATE	0x80	/* å */
#define RECVSTATE	0x40	/* ۿμ */
#define SENDSTATE	0x20    /* ۿ */
#define VIEWSTATE	0x08	/* ̳ɽ */
#define CTRLSTATE	0x04	/*  */
#define RESENDSTATE	0x01	/* 饤Ȥ̤׵ */

#if 1
/* for server */
#define GETLOCK(Num)		(server_CB.client_grp[(Num)]->state & LOCKSTATE)?1:0
#define SETLOCK(Num, Flag)	(Flag)?(server_CB.client_grp[(Num)]->state |= LOCKSTATE):\
					(server_CB.client_grp[(Num)]->state &= ~LOCKSTATE)
#define GETRECV(Num)		(server_CB.client_grp[(Num)]->state & RECVSTATE)?1:0
#define SETRECV(Num, Flag)	(Flag)?(server_CB.client_grp[(Num)]->state |= RECVSTATE):\
                                        (server_CB.client_grp[(Num)]->state &= ~RECVSTATE)
#define GETSEND(Num)		(server_CB.client_grp[(Num)]->state & SENDSTATE)?1:0
#define SETSEND(Num, Flag)	(Flag)?(server_CB.client_grp[(Num)]->state |= SENDSTATE):\
                                        (server_CB.client_grp[(Num)]->state &= ~SENDSTATE)
#define GETVIEW(Num)		(server_CB.client_grp[(Num)]->state & VIEWSTATE)?1:0
#define SETVIEW(Num, Flag)	(Flag)?(server_CB.client_grp[(Num)]->state |= VIEWSTATE):\
                                        (server_CB.client_grp[(Num)]->state &= ~VIEWSTATE)
#define GETCTRL(Num)		(server_CB.client_grp[(Num)]->state & CTRLSTATE)?1:0
#define SETCTRL(Num, Flag)	(Flag)?(server_CB.client_grp[(Num)]->state |= CTRLSTATE):\
                                        (server_CB.client_grp[(Num)]->state &= ~CTRLSTATE)
#define GETCTRL(Num)		(server_CB.client_grp[(Num)]->state & CTRLSTATE)?1:0
#define SETCTRL(Num, Flag)	(Flag)?(server_CB.client_grp[(Num)]->state |= CTRLSTATE):\
                                        (server_CB.client_grp[(Num)]->state &= ~CTRLSTATE)
#define GETRESEND(Num)		(server_CB.client_grp[(Num)]->state & RESENDSTATE)?1:0
#define SETRESEND(Num, Flag)	(Flag)?(server_CB.client_grp[(Num)]->state |= RESENDSTATE):\
                                        (server_CB.client_grp[(Num)]->state &= ~RESENDSTATE)
/* for client */
#define GETLOCK_C		(client_CB.state & LOCKSTATE)?1:0
#define SETLOCK_C(Flag)		(Flag)?(client_CB.state |= LOCKSTATE):(client_CB.state &= ~LOCKSTATE)
#define GETRECV_C		(client_CB.state & RECVSTATE)?1:0
#define SETRECV_C(Flag)		(Flag)?(client_CB.state |= RECVSTATE):(client_CB.state &= ~RECVSTATE)
#define GETRESEND_C		(client_CB.state & RESENDSTATE)?1:0
#define SETRESEND_C(Flag)	(Flag)?(client_CB.state |= RESENDSTATE):(client_CB.state &= ~RESENDSTATE)
  
#endif

typedef struct {
	CARD8	type;
	CARD8	length;
	CARD16	server_port;
	CARD32	server_ip;
	CARD8	server_ID[IDLENGTH];
} ServerAdv;

typedef struct {
	CARD8	type;
	CARD8	length;
	CARD8	client_ID[IDLENGTH];
} ClientAdv;

typedef struct {
	CARD8	type;
	CARD8	flag;
	CARD16	casting_port;
	CARD32	casting_ip;
	CARD8	src_ID[IDLENGTH];
	rfbServerInitMsg serverInitMsg;
} CastAdv;

typedef struct {
	CARD8	type;
	CARD8	flag;
	CARD8	locktime;
	CARD8	pading;
} LockAdv;

typedef struct {
	CARD8 type;
	CARD8 flag;
} AllowAdv;

typedef struct {
	CARD8 type;
	CARD8 flag;
} ExistAdv;

typedef struct {
	CARD8 type;
	CARD8 flag;
} VncConnAdv;

struct server_cb {
	struct client_grp *client_grp[MAXCLIENT];	/* 饤Ⱦ */
	CARD32 advertise_ip;				/* еưΥɥ쥹 */
	CARD16 advertise_port;				/* еưΥݡ */
	CARD32 cstdsp[MAXCLIENT];			/* ǥץ */
	CARD32 casting_ip[MAXCLIENT];			/* ɥ쥹 */
	CARD16 casting_port;				/* ݡ */
	CARD8 server_ID[IDLENGTH];			/* ID */
	CARD16 server_port;				/* listenݡ */
	CARD32 lsndsp;					/* listenǥץ */
	CARD32 g_lsndsp;				/* listenǥץ(gtk) */
	CARD8 user_num;					/* 饤³ */
	//CARD32 testdsp;
	//CARD8 flag;
	CARD8 processingNum;
	CARD8 cast_src[MAXCLIENT];			/* 롼פ饤ֹ */
	struct timeval basetime;			/* RTT¬δȤʤ */
	CARD8 DB_Host[16];
	CARD32 DB_Port;
	CARD8 DB_Name[16];
	CARD8 DB_Pass[16];
	CARD8 DB_Database[16];
};

struct client_grp {
	CARD8 client_ID[IDLENGTH];
	CARD32 client_ip;
	CARD16 client_port;
	CARD8 state;
	CARD32 vncdsp;
	CARD32 ctldsp;
	CARD32 g_vncdsp;
	CARD32 g_ctldsp;
	CARD8 cast_grp;
	CARD8 recv_grp;
	rfbServerInitMsg serverInitMsg;
	int draw_page;
	int draw_area;
	unsigned int r_time;
	gint calcrate_tag;
	gint resend_tag;
	int shm_id;
};

struct client_cb {
	CARD8 client_ID[IDLENGTH];
	CARD8 server_ID[IDLENGTH];
	CARD32 server_ip;
	CARD16 server_port;
	CARD8 state;

	CARD32 advertise_ip;
	CARD16 advertise_port;
	CARD32 casting_ip;
	CARD16 casting_port;
	CARD32 mltdsp;
	CARD32 g_mltdsp;
	FILE *vncdsp;
	CARD32 ctldsp;
	CARD32 g_ctldsp;
	CARD32 cstdsp;
	CARD32 g_cstdsp;
	CARD32 connectstate;
	rfbServerInitMsg serverInitMsg;
	CARD16 del_pk_num;				/* ˴줿ѥåȿ */
};

struct Draw_Info {
        int row;
        int column;
	char group_name[16];
        int client_num[TABGROUP_MAX];
};


/* multi.c */
int clientNum;
extern void AdvInit ();
extern int SendAdv ();
extern int ConnectAdv ();
extern void ConnectCTL (struct sockaddr_in, int, int);
extern void ConnectVNC (struct sockaddr_in, int, int);
int CreateMultiSockToSend (unsigned int ip, int port);
extern void SendCastMsg (char flag, int clientNum);
extern void SendLockMsg (char flag, int clientNum);
extern void SendAllowMsg (int clientNum, char *buf);
extern void CutVNC (int clientNum);
extern void SendVncMsg (int clientNum);
extern void CheckLockClient(void);
extern void sem_init (void);
extern void sem_lock (void);
extern void sem_unlock (void);
extern struct Shm_asym *shm_asym[MAXCLIENT];
extern void resendCallback (gpointer cnum);

#include <sys/shm.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sched.h>

/* sockets.c */
extern gint gdksock;
extern int buffered;

/* vncviewer.c */
extern int vnc_main(int argc, char **argv);
struct server_cb server_CB;

/* multivnc_client.c */
extern int client_main(int argc, char **argv);
extern struct client_cb client_CB;

/* listen.c */
extern void doListen();

/* draw.c */
extern int clientNum_ex;

/* rfbproto.c */
#include <zlib.h>
#include <jpeglib.h>
int da_num;
#define CAST_BUF_SIZE 5000000
//#define CALC_SIZE CAST_BUF_SIZE
#define CALC_SIZE 30000
//#define CAST_BUF_SIZE SHMMAX
//#define CAST_BUF_SIZE 4194304
//#define CAST_BUF_SIZE 307200
//extern char castBuf[CAST_BUF_SIZE];
//extern int cblen;
extern z_stream zlibStream[MAXCLIENT][4];
extern Bool zlibStreamActive[MAXCLIENT][4];

struct Shm_asym {
  int sem_fg;
  int flag;
  int start;
  int end;
  int sendrate;
  char castBuf[CAST_BUF_SIZE];
  short rec_size[CALC_SIZE];
  short rec_s;
  short rec_e;
  int ave_delay;
};

extern void calcRateCallback (gpointer cnum);


/* init_client.c */
void DesktopInitForClient(void);
void CreateImageInfoForClient(void);
void CopyDataToScreenForClient(char *buf, int x, int y, int width, int height);
void window_copy_area_for_client(GdkWindow *window, GdkGC *gc, gint x, gint y,
				 GdkWindow *source_window, gint source_x, gint source_y,
				 gint width, gint height);
void draw_rectangle_for_client(GdkDrawable *drawable, GdkGC *gc, gint filled,
			       gint x, gint y, gint width, gint height, int color);

/* main.c(server) */
GtkWidget *drawingarea[TAB_MAX][ROW_MAX * COLUMN_MAX];
struct Draw_Info draw_info[TAB_MAX];
int tab_num, current_page;
int page;
Bool chStateDB(int clientNum, int flag);
void makeTable( int p, int x, int y );
void ChangeLabel(int p, int d, char *name);
extern int exDB_flag;
extern int Resend_flag;

/* callbacks.c(server) */
GdkPixmap *gdkpixmap[TAB_MAX][ROW_MAX * COLUMN_MAX];
GtkWidget *drawingarea_ex;
GdkPixmap *pixmap_ex;
GdkImage *smallimage_ex;
extern GtkWidget *window_ex;

/* callbacks.c(client) */
void GetMultiVNCServerMsg (void *);
void create_lock_window (void);
void start_lock(void);
void stop_lock(void);
GtkWidget *create_mini_window (void);
void draw_string_to_mini_window(char *string);

/* interface.c(client) */
extern GtkWidget* create_drawing_window (void);
extern GtkWidget* create_dialog_IDinput (void);
extern GtkWidget* create_dialog_wait (void);
extern GtkWidget* create_dialog_recvAdv (void);
extern GtkWidget* create_dialog_inputmiss (void);
extern GtkWidget* create_dialog_exit (void);

#endif
