/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <locale.h>

#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "vncviewer.h"

int current_page;
int tab_num, page;
int mainwindowWidth = 800;
int mainwindowHeight = 600;
int exwindowWidth = 600;
int exwindowHeight = 400;
int exDB_flag = 0;
int Resend_flag = 1;
int multi_ttl = 1;
gboolean modifierPressed[16];
struct Draw_Info draw_info[TAB_MAX];
GtkWidget *main_window;
GtkWidget *notebook;
GtkWidget *table[TAB_MAX];
GtkWidget *drawingarea[TAB_MAX][ROW_MAX * COLUMN_MAX];
GtkWidget *namelabel[TAB_MAX][ROW_MAX * COLUMN_MAX];
extern GtkWidget *main_window_viewport;
#if 0
#define CAT_CONF(a,b) a##b
#endif

void
read_conf (FILE *fp)
{
  char tmpstr[64];
  char ckitem[32];

  tab_num = 0;
  while (fgets(tmpstr, 64, fp) != NULL) {
    int res = sscanf(tmpstr, "%s", ckitem);
    if (res < 0) break;
    if (strncmp("Group", ckitem, 5) == 0) {
      if (tab_num == TAB_MAX) continue;
      sscanf(tmpstr, "%s %s %d %d", ckitem, draw_info[tab_num].group_name,
	     &draw_info[tab_num].row, &draw_info[tab_num].column);
      tab_num++;
    } else if (strncmp("MainWindowSize", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d %d", ckitem, &mainwindowWidth, &mainwindowHeight);
    } else if (strncmp("ExpandedWindowSize", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d %d", ckitem, &exwindowWidth, &exwindowHeight);
    } else if (strncmp("exDB_flag", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &exDB_flag);
    } else if (strncmp("DB_Host", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Host);
    } else if (strncmp("DB_Port", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %hd", ckitem, &server_CB.DB_Port);
    } else if (strncmp("DB_Name", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Name);
    } else if (strncmp("DB_Pass", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Pass);
    } else if (strncmp("DB_Database", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Database);
    } else if (strncmp("Resend_flag", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &Resend_flag);
    } else if (strncmp("Multi_TTL", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &multi_ttl);
    }
  }
#if 0
  char item_s[10][64] = {"rows","hoge"};
  int i;
  while (fgets(tmpstr, 64, fp) != NULL) {
    for (i = 0;; i++) {
      int res = sscanf(tmpstr, "%s", ckitem);
      if (res) break;
      if (strncmp(&item_s[i][0], ckitem, strlen(ckitem)) == 0) {
	char tmp[64] = "server_CB.";
	strcat(tmp, &item_s[i][0]);
	sscanf(tmpstr, "%s %s", ckitem, CAT_CONF(&server_CB., client_grp[i]));
	break;
      }
    }
  }
#endif
}


int
main (int argc, char *argv[])
{
  int i, pCnt, dCnt;
  FILE *fp;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);
  AdvInit();

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  
  /* եɤ߹ */
  if ((fp = fopen(CONFIG_FILE, "r")) == NULL) {
    tab_num = 1;
    strcpy(draw_info[0].group_name, "group1");
    draw_info[0].row = 2;
    draw_info[0].column = 2;
    mainwindowWidth = WINDOW_WIDTH;
    mainwindowHeight = WINDOW_HEIGHT;
    exwindowWidth = EXWINDOW_WIDTH;
    exwindowHeight = EXWINDOW_HEIGHT;
    exDB_flag = 0;
    Resend_flag = 0;
  } else {
    read_conf(fp);
    fclose(fp);
  }

  for (i = 0; i < 16; i++)
    modifierPressed[i] = False;

  for (pCnt = 0; pCnt < TAB_MAX; pCnt++) 
    for (dCnt = 0; dCnt < TABGROUP_MAX; dCnt++)
      draw_info[pCnt].client_num[dCnt] = EMPTY;

  /* ᥤ󥦥ɥκ */
  main_window = create_main_window ();
  gtk_window_set_default_size(GTK_WINDOW(main_window), mainwindowWidth, mainwindowHeight);

  /* notebookåȤκ */
  notebook = gtk_notebook_new ();
  gtk_widget_show (notebook);
  gtk_container_add (GTK_CONTAINER (main_window_viewport), notebook);
  gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), TRUE);
  current_page = 0;
  g_signal_connect ((gpointer) notebook, "switch_page",
                    G_CALLBACK (on_notebook_switch_page),
		    NULL);

  /* tableåȤκ */
  for (pCnt = 0; pCnt < tab_num; pCnt++) {
    makeTable (pCnt, draw_info[pCnt].row, draw_info[pCnt].column);
  }

  vnc_main (argc, argv);

  return 0;
}


void makeTable( int p, int x, int y )
{
  int xCnt, yCnt;
  int index, user_data;
  char client_name[16];
  GtkWidget *tab[TAB_MAX];
  GtkWidget *da;

  draw_info[p].row = x;
  draw_info[p].column = y;

  /* tableåȤκ or ꥵ */
  if (table[p] == NULL) {
    table[p] = gtk_table_new (x*2, y, FALSE);
    gtk_widget_show (table[p]);
    gtk_container_add (GTK_CONTAINER (notebook), table[p]);
  }
  else {
    gtk_table_resize (GTK_TABLE(table[p]), x*2, y);
  }

  /* label, drawing areaκ */
  for (xCnt = 0; xCnt < x; xCnt++) {
    for (yCnt = 0; yCnt < y; yCnt++) {
      index = xCnt * y + yCnt;

      /* labelåȤκ */
      if (draw_info[p].client_num[index] != EMPTY)
	strcpy(client_name, server_CB.client_grp[draw_info[p].client_num[index]]->client_ID);
      else
	strcpy(client_name, "no client");
      namelabel[p][index] = gtk_label_new(_(client_name));
      gtk_widget_show(namelabel[p][index]);
      gtk_table_attach (GTK_TABLE (table[p]), namelabel[p][index], yCnt, yCnt+1, xCnt*2, xCnt*2+1,
			(GtkAttachOptions) (GTK_FILL),
			(GtkAttachOptions) (GTK_FILL), 0, 0);
      gtk_widget_set_size_request (namelabel[p][index], -1, 15);

      /* drawing areaåȤκ */
      drawingarea[p][index] = gtk_drawing_area_new ();
      da = drawingarea[p][index];
      gtk_widget_set_events (da, GDK_EXPOSURE_MASK | GDK_ENTER_NOTIFY_MASK | GDK_BUTTON_PRESS_MASK
			     | GDK_LEAVE_NOTIFY_MASK | GDK_STRUCTURE_MASK);
      gtk_widget_show (da);
      gtk_table_attach (GTK_TABLE (table[p]), da, yCnt, yCnt+1, xCnt*2+1, xCnt*2+2,
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

      user_data = (p << 8) + index;
      g_signal_connect ((gpointer) da, "configure_event",
		        G_CALLBACK (on_main_drawingarea_configure_event),
		        (gpointer)user_data);
      g_signal_connect ((gpointer) da, "expose_event",
		        G_CALLBACK (on_main_drawingarea_expose_event),
		        (gpointer)user_data);
      g_signal_connect ((gpointer) da, "button_press_event",
		        G_CALLBACK (on_main_drawingarea_button_press_event),
		        (gpointer)user_data);
    }
  }

  /* notebookåȤΥ֤˥롼̾ղä */
  tab[p] = gtk_label_new (_(draw_info[p].group_name));
  gtk_widget_show (tab[p]);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), p),
			      tab[p]);
}


void ChangeLabel(int p, int d, char *name)
{
  int x = d / draw_info[p].column;
  int y = d % draw_info[p].column;

  gtk_container_remove(GTK_CONTAINER(table[p]), namelabel[p][d]);
  namelabel[p][d] = gtk_label_new(_(name));
  gtk_widget_show(namelabel[p][d]);
  gtk_table_attach (GTK_TABLE (table[p]), namelabel[p][d], y, y+1, x*2, x*2+1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);
}
