#!/bin/bash

RM_PO="po/Makefile* po/POTFILES"
RM_SRC="src/Makefile src/.deps"
RM_GLADE="Makefile COPYING INSTALL depcomp\
  aclocal.m4 auto*.cache config.* configure mkinstalldirs\
  missing install-sh stamp-h stamp-h? .deps"
RM_LIST="$RM_PO $RM_SRC $RM_GLADE"

clean(){
  if [ -e Makefile ]; then
    make clean
  else
    rm *.o *.a src/*.o src/*.a
  fi
}

cd ./src_server
clean
cd -
cd ./src_client
clean
cd -
cd ./vncviewer
clean
cd -
cd ./libvncauth
clean
cd -

case $1 in
  all)
    cd ./src_server;\
    echo "rm $RM_LIST";\
    rm -rf $RM_LIST;\
    cd -;\
    cd ./src_client;\
    echo "rm $RM_LIST";\
    rm -rf $RM_LIST;\
    cd -;\
    cd ./vncviewer;\
    rm Makefile;\
    cd -;\
    cd ./libvncauth;\
    rm Makefile;\
    cd -
    ;;
esac

rm -f multivnc_server
rm -f multivnc_client
echo
echo '****** CLEAN_COMPLETE ******'
