#include <stdio.h>
#include <errno.h>
#include <time.h>
#include "vncviewer.h"


void
changeTwoDigit(char *string, int num)
{
  if (num < 10) {
    sprintf(string, "0%d", num);
  } else {
    sprintf(string, "%d", num);
  }

  return;
}

#if 0
char *get_stamp(char *stamp) {
  char year[4], month[4], day[4], hour[4], minute[4];
  time_t timer;
  struct tm *t_st;

  // file stamp
  time(&timer);
  t_st = localtime(&timer);
  changeTwoDigit(year, t_st->tm_year + 1900);
  changeTwoDigit(month, t_st->tm_mon + 1);
  changeTwoDigit(day, t_st->tm_mday);
  changeTwoDigit(hour, t_st->tm_hour);
  changeTwoDigit(minute, t_st->tm_min);
  sprintf(stamp, "%s%s%s%s%s", year, month, day, hour, minute);

  return(stamp);
}

size_t
get_file_size (char *file) {
  FILE *fp;
  size_t size;

  if ((fp = fopen(file, "r")) == NULL) {
    fprintf(stderr, "Can't open %s file\n", file);
    return False;
  }

  fseek(fp, 0, SEEK_END);
  size = ftell(fp);
  fclose(fp);

  return size;
}


void 
SendRecMsg (char flag, int sock, int rectime, int fps, char* geometry)
{
  RecAdv recadv;

  bzero(&recadv, sizeof(recadv));
  recadv.type = rfbRecAdv;
  recadv.flag = flag;
  recadv.rectime = rectime + SLEEP;
  recadv.fps  = fps;
  if (geometry != NULL) {
    memcpy(recadv.geometry, geometry, IDLENGTH);
  }

  send (sock, &recadv, sizeof(recadv), 0);
}

void
SendFileMsg (char flag, int sock, size_t fsize , char *fname, char *data)
{
  FileAdv fileadv;

  bzero(&fileadv, sizeof(fileadv));
  fileadv.type =  rfbFileAdv;
  fileadv.flag = flag;
  fileadv.fsize = fsize;
  if (fname != NULL)
    memcpy(fileadv.fname, fname, STRLENGTH);
  if (data != NULL)
    memcpy(fileadv.data, data, SWF_DATA);

  send(sock, &fileadv, 2, 0);
  write(sock, &fileadv.fsize, sizeof(fileadv.fsize));
  send(sock, fileadv.fname, STRLENGTH, 0);
  size_t ret = 0;
  ret = send(sock, fileadv.data, SWF_DATA, 0);
  fprintf(stderr, "send data %d\n", ret);
}
#endif
