#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <pthread.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "vncviewer.h"
#include "image_processing.h"


Display *display;
pthread_mutex_t i_mutex;
pthread_t i_thread;

/**********************************/
/* utility functions              */
/**********************************/
void RGBtoHSV(int r,int g,int b,int *h,int *s,int *v)
{
    int max,min;
    max = r   > g ? r   : g;
    max = max > b ? max : b;
    min = r   < g ? r   : g;
    min = min < b ? min : b;

    if(max == 0)
    {//ΤȤhs̤
        *h = 0;*s = 0;*v = 0;
    }
    else if (max == min)
    {//ΤȤh̤
        *h = 0;*s = 0;*v = max;
    }
    else
    {//׻Wikipedia
        if (max == r)      *h = 60 * (g - b) / (max - min);
        else if (max == g) *h = 60 * (b - r) / (max - min) + 120;
        else               *h = 60 * (r - g) / (max - min) + 240;
    }

    *h /= 2;
    while(*h < 0) *h += 180;
    while(*h >= 180) *h -= 180;
}

void tsInit(TS *ts,int length)
{
    ts->now = 0;
    ts->length = length;
}

void tsPutForward(TS *ts)
{
    ts->now++;
    if(ts->now >= ts->length) ts->now = 0;
}

int tsFromNow(TS *ts,int diff)
{
    int time;
    time = ts->now + diff;
    while(time < 0         ) time += ts->length;
    while(time >= ts->length) time -= ts->length;
    return time;
}

int tsNext(TS *ts,int time)
{
    time++;
    while(time < 0         ) time += ts->length;
    while(time >= ts->length) time -= ts->length;
    return time;
}

int tsPrev(TS *ts,int time)
{
    time--;
    while(time < 0         ) time += ts->length;
    while(time >= ts->length) time -= ts->length;
    return time;
}


/**********************************/
/* For client functions           */
/**********************************/

/*
 * 饤Ȳѥåɴؿ
 */
void *image_proc_client (void *arg)
{
    //    //
    struct client_cb *client_CB = arg;
    int h,i,j,t;

    //꡼󥭥ץ
    int screen;
    Window rootWindow;

    //ҥȥࡢ󡢥ե꡼Ƚ
    TS ts;
    int seq_hist_h[LENGTH_TIME_SEQ][MAX_HIST];  //ҥȥǼ
    int seq_matching_hist_h[LENGTH_TIME_SEQ];   //ޥå󥰷̳Ǽ
    int flag_freeze;                            //ե꡼Ƚ

    //    //
    XInitThreads();
    display = XOpenDisplay(NULL);
    screen = DefaultScreen(display);
    rootWindow = RootWindow(display, screen);
    tsInit(&ts,LENGTH_TIME_SEQ);
    memset(seq_hist_h,0,sizeof(seq_hist_h));
    memset(seq_matching_hist_h,-1,sizeof(seq_matching_hist_h));
    flag_freeze = 0;

    while (1) {
        //ᥤ롼ѿ
        XImage *image;
        XWindowAttributes attr;
        int root_w,root_h;

        //
        memset(seq_hist_h[ts.now],0,sizeof(seq_hist_h[ts.now]));
        seq_matching_hist_h[ts.now] = -1;

        //
        XGetWindowAttributes(display, rootWindow, &attr);
        root_w = attr.width;root_h = attr.height;
#if 0
        Window focus;
        int revert_to;
        char str[512];
        FILE *fs;

        XGetInputFocus(display,&focus,&revert_to);
        XGetWindowAttributes(display, focus, &attr);
        sprintf(str,"xwininfo -id %d | grep -E 'Absolute|Width|Height'",
                (int)focus);
        fs = popen(str,"r");
        fgets(str,512,fs);
        sscanf(str,"  Absolute upper-left X:  %d",&attr.x);
        fgets(str,512,fs);
        sscanf(str,"  Absolute upper-left Y:  %d",&attr.y);
        fgets(str,512,fs);
        sscanf(str,"  Width: %d",&attr.width);
        fgets(str,512,fs);
        sscanf(str,"  Height: %d",&attr.height);
        pclose(fs);

        if (attr.x+attr.width  > root_w)
            attr.width  -= (attr.x+attr.width -root_w);
        if (attr.y+attr.height > root_h)
            attr.height -= (attr.y+attr.height-root_h);
        if (attr.x < 0) {attr.width  += attr.x-1;attr.x =0;}
        if (attr.y < 0) {attr.height += attr.y-1;attr.y =0;}

        printf("attr:(%d,%d),%d,%d\n", attr.x, attr.y,attr.width,attr.height);
#endif
        if (attr.map_state != IsViewable
            || attr.width < 10 || attr.height < 10 //ɤȽ
            || (attr.depth != 16 && attr.depth != 24 && attr.depth != 32)
           )
            image = NULL;
        else
            image = XGetImage(display, rootWindow,//focus,//
                            attr.x, attr.y, attr.width, attr.height,
                            AllPlanes, ZPixmap);

        if (image == NULL)
        {
            printf("failed to get image.\n");
        }
        else
        {
            //ҥȥ׻
            for (j = 0;j < attr.height;j++)
            {
                for (i = 0;i < attr.width;i++)
                {
                    unsigned char *pix;
                    int r,g,b,h,s,v;

                    if (attr.depth == 16)
                    {
                        unsigned long buf = XGetPixel(image,i,j);
                        b = buf & 0x1F;
                        g = (buf >> 6) & 0x1F;
                        r = (buf >> 11);
                    }
                    else if (attr.depth == 24 ||attr.depth == 32)
                    {
                        pix =(unsigned char*)&image->data[(j*attr.width+i)*4];
                        r = *(pix+2);
                        g = *(pix+1);
                        b = *pix;
                        r /= 8;g /= 8;b /= 8;
                    }

                    RGBtoHSV(r,g,b,&h,&s,&v);

                    seq_hist_h[ts.now][h]++;
                }
            }
            XDestroyImage(image);

            //ҥȥ
            int sum = 0;
            for (h = 0;h < MAX_HIST;h++)
            {
                seq_hist_h[ts.now][h] *=
                     (double)NORMALIZE_HIST
                        / (attr.width * attr.height);
                sum+=seq_hist_h[ts.now][h];
            }

            //ޥå
            int intersection = 0;
            int matching_count = 0;
            for (h = 0;h < MAX_HIST;h++)
            {
                intersection +=
                    seq_hist_h[ts.now][h] < seq_hist_h[tsPrev(&ts,ts.now)][h] ?
                    seq_hist_h[ts.now][h] : seq_hist_h[tsPrev(&ts,ts.now)][h];
            }
            seq_matching_hist_h[ts.now] =
                intersection > NORMALIZE_HIST * MATCHING_RATIO ? 1:0;

            //FREEZEȽ
            for (t = 0;t < LENGTH_TIME_SEQ;t++)
            {
                if (seq_matching_hist_h[t] == 1) matching_count++;
            }
            if (matching_count == LENGTH_TIME_SEQ) flag_freeze = 1;
            else flag_freeze = 0;
            for (t = 0;t < LENGTH_TIME_SEQ;t++)
                printf("%d  ",seq_matching_hist_h[t]);
            printf("> %d\n",flag_freeze);
        }

        pthread_mutex_lock(&i_mutex);
        //memcpy(client_CB->hist_h,seq_hist_h[ts.now],sizeof(seq_hist_h[ts.now]));
        memcpy(client_CB->histogram_h, seq_hist_h[ts.now], sizeof(seq_hist_h[ts.now]));
        //client_CB->flag = flag_freeze;
        client_CB->client_status = flag_freeze;
	send_histgram (client_CB); //TODO
        pthread_mutex_unlock(&i_mutex);

        tsPutForward(&ts);
        sleep (C_INTERVAL);
    }
}

/*
 * ҥȥ׵ؿ
 */
void HistogramRequest (void)
{
    //TODO : Ԥäơsend_histogramؿƤӽФ
    dbg();
}

/*
 * ҥȥؿ
 */
int send_histgram (struct client_cb *client_CB)
{
    struct client_cb ccb;
    HistogramAdv histogramadv;
    int rep;

    if (client_CB->ctldsp == 0) return False;

    //pthread_mutex_lock(&i_mutex);
    memcpy(&ccb, client_CB, sizeof(struct client_cb));
    //pthread_mutex_unlock(&i_mutex);
    
    /* Create Histogram Packet */
    histogramadv.type    = rfbHistogramAdv;
    histogramadv.flag    = 0x4; //TODO
    histogramadv.status  = ccb.client_status;
    histogramadv.padding = 0x0;
    memcpy(histogramadv.histogram_h, ccb.histogram_h, MAX_HIST);
    memcpy(histogramadv.histogram_s, ccb.histogram_s, MAX_HIST);
    memcpy(histogramadv.histogram_v, ccb.histogram_v, MAX_HIST);

    //TODO
    /* Send Histogram */
    //pthread_mutex_lock(&i_mutex);
    rep = send (ccb.ctldsp, &histogramadv, sizeof(HistogramAdv), 0);
    if (rep != sizeof(HistogramAdv)) {
	err("Warning Can't send histogram data.");
	return False;
    }
    //pthread_mutex_unlock(&i_mutex);


    dbg("client_send_histogram client_ID: %s", ccb.client_ID);

    return True;
}

/**********************************/
/* For server functions           */
/**********************************/

/*
 * вѥåɴؿ
 */
void *image_proc_server (void *arg)
{
    int h,k,n;        //ҥȥǡ饤ȡХåե롼
    struct client_cb **client_grp = arg;

    int global_hist_h[MAX_HIST];                //ҥȥ
    int client_hist_h[MAXCLIENT][MAX_HIST];    //饤ȥҥȥ
    int flag_exist[MAXCLIENT];                 //饤Ȥ¸
    int flag_irregular[MAXCLIENT];             //쥮顼Ƚ
    int kajou_hist_h[MAXCLIENT];               //Ψ
    int kesson_hist_h[MAXCLIENT];              //»Ψ
    int matching_hist_h[MAXCLIENT];            //Ψ

    while (1)
    {
        int num_client = 0;
        int buf_hist[NORMALIZE_HIST];
        int sum_buf_hist = 0;
        int sum_global_hist_h = 0;

        //
        memset(client_hist_h,0,sizeof(client_hist_h));
        memset(flag_exist,0,sizeof(flag_exist));
        memset(flag_irregular,0,sizeof(flag_irregular));
        memset(kajou_hist_h,0,sizeof(kajou_hist_h));
        memset(kesson_hist_h,0,sizeof(kesson_hist_h));
        memset(matching_hist_h,0,sizeof(matching_hist_h));

        //ҥȥ
        pthread_mutex_lock(&i_mutex);
        for (k = 0;k < MAXCLIENT;k++)
        {
            if(client_grp[k] != NULL)
            {
                memcpy(client_hist_h[k],client_grp[k]->histogram_h,
                       sizeof(int)*MAX_HIST);
                num_client++;
            }
        }
        pthread_mutex_unlock(&i_mutex);

        //ҥȥ
        for (h = 0;h < MAX_HIST;h++)
        {
            if(client_grp[k] != NULL) continue;
            memset(buf_hist,0,sizeof(buf_hist));
            sum_buf_hist = 0;

            for (k = 0;k < num_client;k++)
            {
                buf_hist[client_hist_h[k][h]]++;
            }
            for (n = 0;n < NORMALIZE_HIST;n++)
            {
                sum_buf_hist += buf_hist[n];
                if(sum_buf_hist >= num_client/2) break;
            }
            global_hist_h[h] = n;
            //printf("%d,",n);
        }//printf("\n");
        //ҥȥ
        sum_global_hist_h = 0;
        for (h = 2;h < MAX_HIST;h++) sum_global_hist_h += global_hist_h[h];

        //쥮顼Ƚ
        if (sum_global_hist_h < 10)
        {}
        else
        {
            for (k = 0;k < num_client;k++)
            {
                if(client_grp[k] != NULL) continue;
                for (h = 2;h < MAX_HIST;h++)
                {
                    int freq = client_hist_h[k][h];
                    if ( freq >= global_hist_h[h] )
                    {
                        kajou_hist_h[k] += (freq - global_hist_h[h]);
                    }else{
                        kesson_hist_h[k] += (global_hist_h[h] - freq);
                    }
                }
                matching_hist_h[k] = (int)((1-(kajou_hist_h[k]+kesson_hist_h[k])
                                        /(double)sum_global_hist_h)*100);
                if (matching_hist_h[k] <= 0) flag_irregular[k] = 1;
                else                         flag_irregular[k] = 0;
                printf("<%2d> kajou:%4d kesson:%4d matching:%4d\n",
                       k,kajou_hist_h[k],kesson_hist_h[k],matching_hist_h[k]);
            }
            int sum_regular = 0;
            for (k = 0;k < MAXCLIENT;k++)
                if (flag_irregular[k] == 0) sum_regular++;
            if (sum_regular < num_client / 2)
                memset(flag_irregular,0,sizeof(flag_irregular));
        }

        //TODO:
        pthread_mutex_lock(&i_mutex);
        for (k = 0;k < MAXCLIENT;k++)
        {
            if(client_grp[k] != NULL)
            {
                client_grp[k]->client_status = flag_irregular[k];
            }
        }
        pthread_mutex_unlock(&i_mutex);

        fprintf(stderr, "image_proc_server\n");
        sleep (S_INTERVAL);
    }
}

/*
 * ҥȥؿ
 */
void GetHistogram (int clientNum, char *buf, int socket)
{
    int f_status;
    HistogramAdv *hadv = buf;
    int rep;

    dbg();

    /* إåѥåȤλĤ */
    rep = 0;
    do {
	if ((rep += recv (socket, buf + 2 + rep, sizeof(HistogramAdv) - 2 - rep, 0)) <= 0) {
	    err ();
	}
    } while (rep != sizeof(HistogramAdv)-2);
    //dbg("######## rep=%d == %d",rep, sizeof(HistogramAdv)-2);

    f_status = hadv->status;

    //TODO : flag
    pthread_mutex_lock(&i_mutex);
    //if (f_status == FREEZE)
//	server_CB.client_grp[clientNum]->client_status = FREEZE;
    if (f_status == FREEZE) {
	dbg("                                                    FREEZE");
	server_CB.client_grp[clientNum]->client_status = FREEZE;
    }
    dbg("now status =%d", server_CB.client_grp[clientNum]->client_status);

    memcpy(server_CB.client_grp[clientNum]->histogram_h, hadv->histogram_h, MAX_HIST);
    memcpy(server_CB.client_grp[clientNum]->histogram_s, hadv->histogram_s, MAX_HIST);
    memcpy(server_CB.client_grp[clientNum]->histogram_v, hadv->histogram_v, MAX_HIST);

    set_client_color (server_CB.client_grp[clientNum]->draw_page, server_CB.client_grp[clientNum]->draw_area);
    pthread_mutex_unlock(&i_mutex);

    dbg ("UPDATE HISTOGRAM : %s (%d)",
	    server_CB.client_grp[clientNum]->client_ID,
	    server_CB.client_grp[clientNum]->client_status
	);
}

/*
 * ҥȥ׵ؿ
 */
int request_histgram (struct client_grp *client_GRP)
{
    struct client_grp cgp;
    HistogramRequestAdv histogramrequestadv;
    int rep;

    pthread_mutex_lock(&i_mutex);
    memcpy(&cgp, client_GRP, sizeof(struct client_grp));
    pthread_mutex_unlock(&i_mutex);
    
    /* Create Histogram Packet */
    histogramrequestadv.type    = rfbHistogramRequestAdv;
    histogramrequestadv.flag    = 0x0; //TODO 0x10 or 0x100

    //TODO
    /* Send Histogram */
    pthread_mutex_lock(&i_mutex);
    rep = send (cgp.ctldsp, &histogramrequestadv, sizeof(HistogramRequestAdv), 0);
    if (rep != sizeof(HistogramRequestAdv)) {
	err ("Warning Can't send histogram request.");
	return False;
    }
    pthread_mutex_unlock(&i_mutex);


    dbg ("server_send_request_histogram client_ID: %s", cgp.client_ID);

    return True;
}

