/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <locale.h>

#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "vncviewer.h"

#define MULTIVNC_SRC SERVER
#define ENABLE_NSL

int current_page;
int tab_num, page;
int mainwindowWidth = 800;
int mainwindowHeight = 600;
int exwindowWidth = 600;
int exwindowHeight = 400;
int exDB_flag = 0;
int Resend_flag = 1;
int multi_ttl = 1;
gboolean modifierPressed[16];
struct Draw_Info draw_info[TAB_MAX];
GtkWidget *main_window;
GtkWidget *notebook;
GtkWidget *table[TAB_MAX];
GtkWidget *frame[TAB_MAX][ROW_MAX * COLUMN_MAX];
GtkWidget *drawingarea[TAB_MAX][ROW_MAX * COLUMN_MAX];
GtkWidget *namelabel[TAB_MAX][ROW_MAX * COLUMN_MAX];
extern GtkWidget *main_window_viewport;
GtkWidget *user_list[TAB_MAX];
GtkWidget *client_name_list[TAB_MAX][ROW_MAX * COLUMN_MAX];
GtkWidget *group_name_list[TAB_MAX];
#if 0
#define CAT_CONF(a,b) a##b
#endif

char interface_name[IF_LENGTH];
char interface_addr[IF_LENGTH] = "0.0.0.0";
char server_name[IDLENGTH] = "";
extern int clientNum;

void
read_conf (FILE *fp)
{
  char tmpstr[64];
  char ckitem[32];

  tab_num = 0;
  while (fgets(tmpstr, 64, fp) != NULL) {
    int res = sscanf(tmpstr, "%s", ckitem);
    if (res < 0) break;
    if (strncmp("Group", ckitem, 5) == 0) {
      if (tab_num == TAB_MAX) continue;
      sscanf(tmpstr, "%s %s %d %d", ckitem, draw_info[tab_num].group_name,
	     &draw_info[tab_num].row, &draw_info[tab_num].column);
      if(draw_info[tab_num].row < 1) {
	draw_info[tab_num].row = 1;
      } else if (draw_info[tab_num].row > ROW_MAX) {
	draw_info[tab_num].row = ROW_MAX;
      }
      if(draw_info[tab_num].column < 1) {
	draw_info[tab_num].column = 1;
      } else if (draw_info[tab_num].column > COLUMN_MAX) {
	draw_info[tab_num].column = COLUMN_MAX;
      }
      tab_num++;
    } else if (strncmp("MainWindowSize", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d %d", ckitem, &mainwindowWidth, &mainwindowHeight);
      if (mainwindowWidth < 0) {
        mainwindowWidth = 0;
      }
      if (mainwindowHeight < 0) {
        mainwindowHeight = 0;
      }
    } else if (strncmp("ExpandedWindowSize", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d %d", ckitem, &exwindowWidth, &exwindowHeight);
      if (exwindowWidth < 0) {
        exwindowWidth = 0;
      }
      if (exwindowHeight < 0) {
        exwindowHeight = 0;
      }
    } else if (strncmp("exDB_flag", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &exDB_flag);
    } else if (strncmp("DB_Host", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Host);
    } else if (strncmp("DB_Port", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %hd", ckitem, &server_CB.DB_Port);
    } else if (strncmp("DB_Name", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Name);
    } else if (strncmp("DB_Pass", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Pass);
    } else if (strncmp("DB_Database", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Database);
    } else if (strncmp("Resend_flag", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &Resend_flag);
    } else if (strncmp("Multi_TTL", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &multi_ttl);
    } else if (strncmp("Interface", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, interface_name);
      get_ifaddr(interface_name, interface_addr);
      printf("inetrface: %s (%s)\n", interface_name, interface_addr);
    } else if (strncmp("Server_ID", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_name);
    }
  }
  if (tab_num == 0) {
    strcpy(draw_info[tab_num].group_name,"group1");
    draw_info[tab_num].row    = 2;
    draw_info[tab_num].column = 2;
    tab_num = 1;
  }
#if 0
  char item_s[10][64] = {"rows","hoge"};
  int i;
  while (fgets(tmpstr, 64, fp) != NULL) {
    for (i = 0;; i++) {
      int res = sscanf(tmpstr, "%s", ckitem);
      if (res) break;
      if (strncmp(&item_s[i][0], ckitem, strlen(ckitem)) == 0) {
	char tmp[64] = "server_CB.";
	strcat(tmp, &item_s[i][0]);
	sscanf(tmpstr, "%s %s", ckitem, CAT_CONF(&server_CB., client_grp[i]));
	break;
      }
    }
  }
#endif
}


int
main (int argc, char *argv[])
{
  int i, pCnt, dCnt;
  FILE *fp;

  system("killall multivnc_client >/dev/null 2>&1");
  system("vncserver -kill :1 >/dev/null 2>&1");

#ifdef ENABLE_NLS
  setlocale(LC_ALL, "");
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

//  AdvInit();

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  
  /* ǥե */
  tab_num = 1;
  strcpy(draw_info[0].group_name, "group1");
  draw_info[0].row = 2;
  draw_info[0].column = 2;
  mainwindowWidth = WINDOW_WIDTH;
  mainwindowHeight = WINDOW_HEIGHT;
  exwindowWidth = EXWINDOW_WIDTH;
  exwindowHeight = EXWINDOW_HEIGHT;
  exDB_flag = 0;
  Resend_flag = 0;

  /* եɤ߹ */
  if ((fp = fopen(CONFIG_FILE, "r")) || (fp = fopen(argv[1], "r")) != NULL) {
    read_conf(fp);
    fclose(fp);
  }

  AdvInit();

  for (i = 0; i < 16; i++)
    modifierPressed[i] = False;

  for (pCnt = 0; pCnt < TAB_MAX; pCnt++) 
    for (dCnt = 0; dCnt < TABGROUP_MAX; dCnt++)
      draw_info[pCnt].client_num[dCnt] = EMPTY;

  /* ᥤ󥦥ɥκ */
  main_window = create_main_window ();
  gtk_window_set_default_size(GTK_WINDOW(main_window), mainwindowWidth, mainwindowHeight);
  
  /* notebookåȤκ */
  notebook = gtk_notebook_new ();
  GtkWidget *main_window_viewport = lookup_widget(GTK_WIDGET(main_window), "main_window_viewport");
  gtk_widget_show (notebook);
  gtk_container_add (GTK_CONTAINER (main_window_viewport), notebook);
  gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), TRUE);
  current_page = 0;
  g_signal_connect ((gpointer) notebook, "switch_page",
                    G_CALLBACK (on_notebook_switch_page),
		    NULL);

  /* tableåȤκ */
  for (pCnt = 0; pCnt < tab_num; pCnt++) {
    makeTable (pCnt, draw_info[pCnt].row, draw_info[pCnt].column);
  }

  vnc_main (argc, argv);

  return 0;
}

/* 桼 Widget */
GtkWidget*
create_user_list (int page)
{
  GtkWidget *frame_ulist;
  GtkWidget *alignment1;
  GtkWidget *table_ulist;
  int posit = 0;
  int i, j;

  char font_name[64];
  PangoFontDescription *font_dsp;
  GdkColor color;

  frame_ulist = gtk_frame_new (NULL);
  gtk_widget_show (frame_ulist);
  gtk_container_set_border_width (GTK_CONTAINER (frame_ulist), 4);
  gtk_frame_set_label_align (GTK_FRAME (frame_ulist), 0.5, 0.5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame_ulist), GTK_SHADOW_ETCHED_OUT);

  gtk_widget_set_events (frame_ulist, GDK_EXPOSURE_MASK | GDK_ENTER_NOTIFY_MASK | GDK_BUTTON_PRESS_MASK
			     | GDK_LEAVE_NOTIFY_MASK | GDK_STRUCTURE_MASK);

  // frame color //
  gdk_color_parse("cyan", &color);
  gtk_widget_modify_bg(GTK_WIDGET(frame_ulist), GTK_STATE_NORMAL, &color);

  alignment1 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (frame_ulist), alignment1);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment1), 0, 0, 4, 4);

  table_ulist = gtk_table_new (8, 2, FALSE);
  gtk_widget_show (table_ulist);
  gtk_container_add (GTK_CONTAINER (alignment1), table_ulist);

  // font setting //
  memcpy(font_name, "\0", sizeof(font_name));
  memcpy(font_name, "IPAå 12", sizeof(font_name));
  font_dsp = pango_font_description_from_string(font_name);

  /* 1롼פ2Υ饤ȥꥹɽ */
  for (i = 0; i < draw_info[page].row; i++) {
    for (j = 0; j < draw_info[page].column; j++) {
      client_name_list[page][posit] = gtk_label_new (_("no client"));
      gtk_widget_show (client_name_list[page][posit]);
      gtk_table_attach (GTK_TABLE (table_ulist), client_name_list[page][posit], j, j+1, i, i+1,
                      (GtkAttachOptions) (GTK_EXPAND),
                      (GtkAttachOptions) (0), 0, 0);
      gtk_label_set_justify (GTK_LABEL (client_name_list[page][posit]), GTK_JUSTIFY_CENTER);
      gtk_misc_set_alignment (GTK_MISC (client_name_list[page][posit]), 0, 0.5);
      gtk_misc_set_padding (GTK_MISC (client_name_list[page][posit]), 5, 0);

      gtk_widget_modify_font (client_name_list[page][posit], font_dsp);
      gdk_color_parse("SlateGray", &color);
      gtk_widget_modify_fg(GTK_WIDGET(client_name_list[page][posit]), GTK_STATE_NORMAL, &color);
      posit++;
    }
  }

  /* 롼̾٥ */
  group_name_list[page] = gtk_label_new (_("<b>group</b>"));
  gtk_widget_show (group_name_list[page]);
  gtk_frame_set_label_widget (GTK_FRAME (frame_ulist), group_name_list[page]);
  gtk_label_set_use_markup (GTK_LABEL (group_name_list[page]), TRUE);
  gtk_label_set_justify (GTK_LABEL (group_name_list[page]), GTK_JUSTIFY_CENTER);

  // font setting //
  memcpy(font_name, "\0", sizeof(font_name));
  memcpy(font_name, "IPAå Bold 14", sizeof(font_name));
  font_dsp = pango_font_description_from_string(font_name);
  gtk_widget_modify_font (group_name_list[page], font_dsp);

  g_signal_connect ((gpointer) frame_ulist, "button_press_event",
                    G_CALLBACK (on_frame_ulist_press_event),
                    NULL);
#if 0
  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (window1, window1, "window1");
  GLADE_HOOKUP_OBJECT (window1, frame_ulist, "frame_ulist");
  GLADE_HOOKUP_OBJECT (window1, alignment1, "alignment1");
  GLADE_HOOKUP_OBJECT (window1, table_ulist, "table_ulist");
  GLADE_HOOKUP_OBJECT (window1, label04, "label04");
  GLADE_HOOKUP_OBJECT (window1, label05, "label05");
  GLADE_HOOKUP_OBJECT (window1, label06, "label06");
  GLADE_HOOKUP_OBJECT (window1, label07, "label07");
  GLADE_HOOKUP_OBJECT (window1, label08, "label08");
  GLADE_HOOKUP_OBJECT (window1, label01, "label01");
  GLADE_HOOKUP_OBJECT (window1, label02, "label02");
  GLADE_HOOKUP_OBJECT (window1, label03, "label03");
  GLADE_HOOKUP_OBJECT (window1, label09, "label09");
  GLADE_HOOKUP_OBJECT (window1, label11, "label11");
  GLADE_HOOKUP_OBJECT (window1, label10, "label10");
  GLADE_HOOKUP_OBJECT (window1, label12, "label12");
  GLADE_HOOKUP_OBJECT (window1, label13, "label13");
  GLADE_HOOKUP_OBJECT (window1, label14, "label14");
  GLADE_HOOKUP_OBJECT (window1, label15, "label15");
  GLADE_HOOKUP_OBJECT (window1, label16, "label16");
  GLADE_HOOKUP_OBJECT (window1, label_gname, "label_gname");
#endif

  return frame_ulist;
}

void makeTable( int p, int x, int y )
{
  int xCnt, yCnt;
  int index, user_data;
  char client_name[IDLENGTH];
  GtkWidget *tab[TAB_MAX];
  GtkWidget *da;
  GtkWidget *list_p;

  draw_info[p].row = x;
  draw_info[p].column = y;

  /* tableåȤκ or ꥵ */
  if (table[p] == NULL) {
    table[p] = gtk_table_new (x*2, y, FALSE);
    gtk_widget_show (table[p]);
    gtk_container_add (GTK_CONTAINER (notebook), table[p]);

  }
  else {
    gtk_table_resize (GTK_TABLE(table[p]), x*2, y);
  }

  // 桼ѹ //
  list_p = lookup_widget(GTK_WIDGET(main_window), "hbox_ulist");
  gtk_widget_hide(list_p);
  user_list[p]  = create_user_list(p);
  gtk_container_add (GTK_CONTAINER(list_p), user_list[p]);
  gtk_widget_show(list_p);

  /* label, drawing areaκ */
  for (xCnt = 0; xCnt < x; xCnt++) {
    for (yCnt = 0; yCnt < y; yCnt++) {
      index = xCnt * y + yCnt;

      /* labelåȤκ */
      if (draw_info[p].client_num[index] != EMPTY)
	strcpy(client_name, (char *)server_CB.client_grp[draw_info[p].client_num[index]]->client_ID);
      else
	strcpy(client_name, "no client");

      namelabel[p][index] = gtk_label_new(client_name);
      gtk_widget_show(namelabel[p][index]);
      gtk_table_attach (GTK_TABLE (table[p]), namelabel[p][index], yCnt, yCnt+1, xCnt*2, xCnt*2+1,
			(GtkAttachOptions) (GTK_FILL),
			(GtkAttachOptions) (GTK_FILL), 0, 0);
      gtk_widget_set_size_request (namelabel[p][index], -1, 15);

      gtk_label_set_text(GTK_LABEL(client_name_list[p][index]), client_name);

      /* 饤ΰκ */
      frame[p][index] = gtk_aspect_frame_new(NULL, 0.5, 0.5, (float)4/3, FALSE);
      gtk_frame_set_label_align(GTK_FRAME(frame[p][index]), 0.0, 0.5);

      gtk_widget_show(frame[p][index]);
      gtk_table_attach (GTK_TABLE (table[p]), frame[p][index], yCnt, yCnt+1, xCnt*2+1, xCnt*2+2,
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

      gtk_frame_set_shadow_type(GTK_FRAME(frame[p][index]), GTK_SHADOW_ETCHED_OUT);      

      /* drawing areaåȤκ */
      drawingarea[p][index] = gtk_drawing_area_new ();
      da = drawingarea[p][index];
      gtk_widget_set_events (da, GDK_EXPOSURE_MASK | GDK_ENTER_NOTIFY_MASK | GDK_BUTTON_PRESS_MASK
			     | GDK_LEAVE_NOTIFY_MASK | GDK_STRUCTURE_MASK);
      gtk_widget_show (da);
      gtk_container_add(GTK_CONTAINER(frame[p][index]), da);
      

      user_data = (p << 8) + index;
      g_signal_connect ((gpointer) da, "configure_event",
		        G_CALLBACK (on_main_drawingarea_configure_event),
		        (gpointer)user_data);
      g_signal_connect ((gpointer) da, "expose_event",
		        G_CALLBACK (on_main_drawingarea_expose_event),
		        (gpointer)user_data);
      g_signal_connect ((gpointer) da, "button_press_event",
		        G_CALLBACK (on_main_drawingarea_button_press_event),
		        (gpointer)user_data);

      set_client_color(p, index);
    }
  }

  /* user listΥ롼פ˥롼̾ղä */
  gtk_label_set_text (GTK_LABEL(group_name_list[p]), draw_info[p].group_name);

  /* notebookåȤΥ֤˥롼̾ղä */
  tab[p] = gtk_label_new (draw_info[p].group_name);
  gtk_widget_show (tab[p]);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), p),
			      tab[p]);

}


void ChangeLabel(int p, int d, char *name)
{
  int x = d / draw_info[p].column;
  int y = d % draw_info[p].column;
  GdkColor color;

  // change user list name //
  gtk_label_set_text(GTK_LABEL(client_name_list[p][d]), name);

  gtk_container_remove(GTK_CONTAINER(table[p]), namelabel[p][d]);
  namelabel[p][d] = gtk_label_new(name);
  gtk_widget_show(namelabel[p][d]);
  gtk_table_attach (GTK_TABLE (table[p]), namelabel[p][d], y, y+1, x*2, x*2+1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  set_client_color(p, d);
}
