#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <pthread.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "vncviewer.h"
#include "image_processing.h"


Display *display;
pthread_mutex_t i_mutex;
pthread_t i_thread;

/**********************************/
/* utility functions              */
/**********************************/
void RGBtoHSV(int r,int g,int b,int *h,int *s,int *v)
{
    int max,min;
    max = r   > g ? r   : g;
    max = max > b ? max : b;
    min = r   < g ? r   : g;
    min = min < b ? min : b;

    if(max == 0)
    {//ΤȤhs̤
        *h = 0;*s = 0;*v = 0;
    }
    else if (max == min)
    {//ΤȤh̤
        *h = 0;*s = 0;*v = max;
    }
    else
    {//׻Wikipedia
        if (max == r)      *h = 60 * (g - b) / (max - min);
        else if (max == g) *h = 60 * (b - r) / (max - min) + 120;
        else               *h = 60 * (r - g) / (max - min) + 240;
    }

    *h /= 2;
    while(*h < 0) *h += 180;
    while(*h >= 180) *h -= 180;
}

void tsInit(TS *ts,int length)
{
    ts->now = 0;
    ts->length = length;
}

void tsPutForward(TS *ts)
{
    ts->now++;
    if(ts->now >= ts->length) ts->now = 0;
}

int tsFromNow(TS *ts,int diff)
{
    int time;
    time = ts->now + diff;
    while(time < 0         ) time += ts->length;
    while(time >= ts->length) time -= ts->length;
    return time;
}

int tsNext(TS *ts,int time)
{
    time++;
    while(time < 0         ) time += ts->length;
    while(time >= ts->length) time -= ts->length;
    return time;
}

int tsPrev(TS *ts,int time)
{
    time--;
    while(time < 0         ) time += ts->length;
    while(time >= ts->length) time -= ts->length;
    return time;
}


/**********************************/
/* For client functions           */
/**********************************/

/*
 * 饤Ȳѥåɴؿ
 */
void *image_proc_client (void *arg)
{
    //    //
    struct client_cb *client_CB = arg;
    int h,i,j,t;

    //꡼󥭥ץ
    int screen;
    Window rootWindow;

    //ҥȥࡢ󡢥ե꡼Ƚ
    TS ts;
    int seq_hist_h[LENGTH_TIME_SEQ][MAX_HIST];  //ҥȥǼ
    int seq_matching_hist_h[LENGTH_TIME_SEQ];   //ޥå󥰷̳Ǽ
    int flag_freeze;                            //ե꡼Ƚ

    //    //
    XInitThreads();
    display = XOpenDisplay(NULL);
    screen = DefaultScreen(display);
    rootWindow = RootWindow(display, screen);
    tsInit(&ts,LENGTH_TIME_SEQ);
    memset(seq_hist_h,0,sizeof(seq_hist_h));
    memset(seq_matching_hist_h,-1,sizeof(seq_matching_hist_h));
    flag_freeze = 0;

    while (1) {
        //ᥤ롼ѿ
        XImage *image;
        XWindowAttributes attr;
        int root_w,root_h;

        //
        memset(seq_hist_h[ts.now],0,sizeof(seq_hist_h[ts.now]));
        seq_matching_hist_h[ts.now] = -1;

        //
        XGetWindowAttributes(display, rootWindow, &attr);
        root_w = attr.width;root_h = attr.height;
#if 0
        Window focus;
        int revert_to;
        char str[512];
        FILE *fs;

        XGetInputFocus(display,&focus,&revert_to);
        XGetWindowAttributes(display, focus, &attr);
        sprintf(str,"xwininfo -id %d | grep -E 'Absolute|Width|Height'",
                (int)focus);
        fs = popen(str,"r");
        fgets(str,512,fs);
        sscanf(str,"  Absolute upper-left X:  %d",&attr.x);
        fgets(str,512,fs);
        sscanf(str,"  Absolute upper-left Y:  %d",&attr.y);
        fgets(str,512,fs);
        sscanf(str,"  Width: %d",&attr.width);
        fgets(str,512,fs);
        sscanf(str,"  Height: %d",&attr.height);
        pclose(fs);

        if (attr.x+attr.width  > root_w)
            attr.width  -= (attr.x+attr.width -root_w);
        if (attr.y+attr.height > root_h)
            attr.height -= (attr.y+attr.height-root_h);
        if (attr.x < 0) {attr.width  += attr.x-1;attr.x =0;}
        if (attr.y < 0) {attr.height += attr.y-1;attr.y =0;}

        printf("attr:(%d,%d),%d,%d\n", attr.x, attr.y,attr.width,attr.height);
#endif
        if (attr.map_state != IsViewable
            || attr.width < 10 || attr.height < 10 //ɤȽ
            || (attr.depth != 16 && attr.depth != 24 && attr.depth != 32)
           )
            image = NULL;
        else
            image = XGetImage(display, rootWindow,//focus,//
                            attr.x, attr.y, attr.width, attr.height,
                            AllPlanes, ZPixmap);

        if (image == NULL)
        {
            printf("failed to get image.\n");
        }
        else
        {
            //ҥȥ׻
            for (j = 0;j < attr.height;j++)
            {
                for (i = 0;i < attr.width;i++)
                {
                    unsigned char *pix;
                    int r,g,b,h,s,v;

                    if (attr.depth == 16)
                    {
                        unsigned long buf = XGetPixel(image,i,j);
                        b = buf & 0x1F;
                        g = (buf >> 6) & 0x1F;
                        r = (buf >> 11);
                    }
                    else if (attr.depth == 24 ||attr.depth == 32)
                    {
                        pix =(unsigned char*)&image->data[(j*attr.width+i)*4];
                        r = *(pix+2);
                        g = *(pix+1);
                        b = *pix;
                        r /= 8;g /= 8;b /= 8;
                    }

                    RGBtoHSV(r,g,b,&h,&s,&v);

                    seq_hist_h[ts.now][h]++;
                }
            }
            XDestroyImage(image);

            //ҥȥ
            int sum = 0;
            for (h = 0;h < MAX_HIST;h++)
            {
                seq_hist_h[ts.now][h] *=
                     (double)NORMALIZE_HIST
                        / (attr.width * attr.height);
                sum+=seq_hist_h[ts.now][h];
            }

            //ޥå
            int intersection = 0;
            int matching_count = 0;
            for (h = 0;h < MAX_HIST;h++)
            {
                intersection +=
                    seq_hist_h[ts.now][h] < seq_hist_h[tsPrev(&ts,ts.now)][h] ?
                    seq_hist_h[ts.now][h] : seq_hist_h[tsPrev(&ts,ts.now)][h];
            }
            seq_matching_hist_h[ts.now] =
                intersection > NORMALIZE_HIST * MATCHING_RATIO ? 1:0;

            //FREEZEȽ
            for (t = 0;t < LENGTH_TIME_SEQ;t++)
            {
                if (seq_matching_hist_h[t] == 1) matching_count++;
            }
            if (matching_count == LENGTH_TIME_SEQ) flag_freeze = FREEZE;
            else flag_freeze = NORMAL;
            for (t = 0;t < LENGTH_TIME_SEQ;t++)
                printf("%d  ",seq_matching_hist_h[t]);
            printf("> %d\n",flag_freeze);
        }

        pthread_mutex_lock(&i_mutex);
        //memcpy(client_CB->hist_h,seq_hist_h[ts.now],sizeof(seq_hist_h[ts.now]));
        memcpy(client_CB->histogram_h, seq_hist_h[ts.now], sizeof(seq_hist_h[ts.now]));
        //client_CB->flag = flag_freeze;
        client_CB->client_status = flag_freeze;
	send_histgram (client_CB); //TODO
        pthread_mutex_unlock(&i_mutex);

        tsPutForward(&ts);
        sleep (C_INTERVAL);
    }
}

/*
 * ҥȥ׵ؿ
 */
void HistogramRequest (void)
{
    //TODO : Ԥäơsend_histogramؿƤӽФ
    dbg();
}

/*
 * ҥȥؿ
 */
int send_histgram (struct client_cb *client_CB)
{
    struct client_cb ccb;
    HistogramAdv histogramadv;
    int rep;

    if (client_CB->ctldsp == 0) return False;

    //pthread_mutex_lock(&i_mutex);
    memcpy(&ccb, client_CB, sizeof(struct client_cb));
    //pthread_mutex_unlock(&i_mutex);
    
    /* Create Histogram Packet */
    histogramadv.type    = rfbHistogramAdv;
    histogramadv.flag    = 0x4; //TODO
    histogramadv.status  = ccb.client_status;
    histogramadv.padding = 0x0;
    memcpy(histogramadv.histogram_h, ccb.histogram_h, MAX_HIST);
    memcpy(histogramadv.histogram_s, ccb.histogram_s, MAX_HIST);
    memcpy(histogramadv.histogram_v, ccb.histogram_v, MAX_HIST);

    //TODO
    /* Send Histogram */
    //pthread_mutex_lock(&i_mutex);
    rep = send (ccb.ctldsp, &histogramadv, sizeof(HistogramAdv), 0);
    if (rep != sizeof(HistogramAdv)) {
	err("Warning Can't send histogram data.");
	return False;
    }
    //pthread_mutex_unlock(&i_mutex);


    dbg("client_send_histogram client_ID: %s", ccb.client_ID);

    return True;
}

