#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <pthread.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "vncviewer.h"
#include "image_processing.h"


pthread_mutex_t i_mutex;
pthread_t i_thread;


/**********************************/
/* For server functions           */
/**********************************/

/*
 * вѥåɴؿ
 */
void *image_proc_server (void *arg)
{
    int h,k,n;        //ҥȥǡ饤ȡХåե롼
    struct server_cb *server_CB = arg;
    struct client_grp **client_grp;

    int global_hist_h[MAX_HIST];                //ҥȥ
    int client_hist_h[MAXCLIENT][MAX_HIST];    //饤ȥҥȥ
    int flag_exist[MAXCLIENT];                 //饤Ȥ¸
    int flag_irregular[MAXCLIENT];             //쥮顼Ƚ
    int kajou_hist_h[MAXCLIENT];               //Ψ
    int kesson_hist_h[MAXCLIENT];              //»Ψ
    int matching_hist_h[MAXCLIENT];            //Ψ

    while (1)
    {
        int num_client = 0;
        int buf_hist[NORMALIZE_HIST];
        int sum_buf_hist = 0;
        int sum_global_hist_h = 0;

        //
        memset(global_hist_h,0,sizeof(global_hist_h));
        memset(client_hist_h,0,sizeof(client_hist_h));
        memset(flag_exist,0,sizeof(flag_exist));
        memset(flag_irregular,0,sizeof(flag_irregular));
        memset(kajou_hist_h,0,sizeof(kajou_hist_h));
        memset(kesson_hist_h,0,sizeof(kesson_hist_h));
        memset(matching_hist_h,0,sizeof(matching_hist_h));

        //饤Ⱦ
        pthread_mutex_lock(&i_mutex);
        client_grp = server_CB->client_grp;
        num_client = 0;
        for (k = 0;k < MAXCLIENT;k++)
        {
            if (client_grp[k] != NULL &&
                client_grp[k]->client_status != NOSTAT )
            {
                memcpy(client_hist_h[k],client_grp[k]->histogram_h,
                       sizeof(int)*MAX_HIST);
                flag_exist[k] = 1;
                num_client++;
            }
        }
        pthread_mutex_unlock(&i_mutex);
        dbg("sum_c:%d",num_client);

        if (num_client < 3)
        {
            //ͰʾʤХ쥮顼ȽϹԤʤ
            dbg ("not checked.");
        }
        else
        {
            //ҥȥ
            dbg ("checking...");
            for (h = 0;h < MAX_HIST;h++)
            {
                memset(buf_hist,0,sizeof(buf_hist));
                sum_buf_hist = 0;
                for (k = 0;k < MAXCLIENT;k++)
                {
                    if(flag_exist[k] == 0) continue;
                    buf_hist[client_hist_h[k][h]]++;
                }
                for (n = 0;n < NORMALIZE_HIST;n++)
                {
                    sum_buf_hist += buf_hist[n];
                    if(sum_buf_hist > num_client / 2) break;
                }
                global_hist_h[h] = n;
            }
//for (h = 1;h < MAX_HIST;h++) printf("%d,",global_hist_h[h]);
//printf("\n");

            //쥮顼Ƚ
            sum_global_hist_h = 0;
            for (h = 2;h < MAX_HIST;h++) sum_global_hist_h += global_hist_h[h];
            if (sum_global_hist_h < 10)
            {
                dbg ("chaos(global_hist not enough)");
                for (k = 0;k < MAXCLIENT;k++) flag_irregular[k] = CHAOS;
            }
            else
            {
                for (k = 0;k < MAXCLIENT;k++)
                {
                    if(flag_exist[k] == 0) continue;
                    for (h = 1;h < MAX_HIST;h++)
                    {
                        int freq = client_hist_h[k][h];
                        if ( freq >= global_hist_h[h] )
                        {
                            kajou_hist_h[k] += (freq - global_hist_h[h]);
                        }else{
                            kesson_hist_h[k] += (global_hist_h[h] - freq);
                        }
                    }
                    matching_hist_h[k]
                         = (int)((1-(kajou_hist_h[k]+kesson_hist_h[k])
                                 / (double)sum_global_hist_h)*100);
                    if (matching_hist_h[k] <= 0) flag_irregular[k] = IRREGULAR;
                    else                         flag_irregular[k] = NORMAL;
                    printf("<%2d> kajou:%4d kesson:%4d matching:%4d\n",
                        k,kajou_hist_h[k],kesson_hist_h[k],matching_hist_h[k]);
                }
                int sum_regular = 0;
                for (k = 0;k < MAXCLIENT;k++)
                    if (flag_exist[k]     == 1      &&
                        flag_irregular[k] != IRREGULAR) sum_regular++;
                dbg("sum_r:%d",sum_regular);
                if (sum_regular <= num_client / 2)
                {
                    dbg ("chaos(sum_r not enough)");
                    for (k = 0;k < MAXCLIENT;k++) flag_irregular[k] = CHAOS;
                }
            }
        }

        //
        pthread_mutex_lock(&i_mutex);
        for (k = 0;k < MAXCLIENT;k++)
        {
            if (client_grp[k] != NULL &&
                client_grp[k]->client_status != NOSTAT )
            {
                dbg("(%d)flag_irregular=%d",k,flag_irregular[k]);
                client_grp[k]->client_status = flag_irregular[k];
            }
        }
        pthread_mutex_unlock(&i_mutex);

        fprintf(stderr, "image_proc_server\n");
        sleep (S_INTERVAL);
    }//end of while
}

/*
 * ҥȥؿ
 */
void GetHistogram (int clientNum, char *buf, int socket)
{
    int f_status;
    HistogramAdv *hadv = buf;
    int rep;

    dbg();

    /* إåѥåȤλĤ */
    rep = 0;
    do {
	if ((rep += recv (socket, buf + 2 + rep, sizeof(HistogramAdv) - 2 - rep, 0)) <= 0) {
	    err ();
	}
    } while (rep != sizeof(HistogramAdv)-2);
    //dbg("######## rep=%d == %d",rep, sizeof(HistogramAdv)-2);

    f_status = hadv->status;

    //TODO : flag
    pthread_mutex_lock(&i_mutex);
    if (f_status == FREEZE) {
	dbg("                                                    FREEZE");
	server_CB.client_grp[clientNum]->client_status = FREEZE;
    } 

    if (server_CB.client_grp[clientNum]->client_status == NOSTAT) {
	dbg("                                                    FIRST CONTACT");
	server_CB.client_grp[clientNum]->client_status = f_status;
    } 
#if 0
	server_CB.client_grp[clientNum]->client_status++;
	if (server_CB.client_grp[clientNum]->client_status >= 4) 
	    server_CB.client_grp[clientNum]->client_status = 0;
#endif
    dbg("now status =%d", server_CB.client_grp[clientNum]->client_status);

    memcpy(server_CB.client_grp[clientNum]->histogram_h, hadv->histogram_h, MAX_HIST);
    memcpy(server_CB.client_grp[clientNum]->histogram_s, hadv->histogram_s, MAX_HIST);
    memcpy(server_CB.client_grp[clientNum]->histogram_v, hadv->histogram_v, MAX_HIST);

    set_client_color (server_CB.client_grp[clientNum]->draw_page, server_CB.client_grp[clientNum]->draw_area);
    pthread_mutex_unlock(&i_mutex);

    dbg ("UPDATE HISTOGRAM : %s (%d)",
	    server_CB.client_grp[clientNum]->client_ID,
	    server_CB.client_grp[clientNum]->client_status
	);
}

/*
 * ҥȥ׵ؿ
 */
int request_histgram (struct client_grp *client_GRP)
{
    struct client_grp cgp;
    HistogramRequestAdv histogramrequestadv;
    int rep;

    pthread_mutex_lock(&i_mutex);
    memcpy(&cgp, client_GRP, sizeof(struct client_grp));
    pthread_mutex_unlock(&i_mutex);
    
    /* Create Histogram Packet */
    histogramrequestadv.type    = rfbHistogramRequestAdv;
    histogramrequestadv.flag    = 0x0; //TODO 0x10 or 0x100

    //TODO
    /* Send Histogram */
    pthread_mutex_lock(&i_mutex);
    rep = send (cgp.ctldsp, &histogramrequestadv, sizeof(HistogramRequestAdv), 0);
    if (rep != sizeof(HistogramRequestAdv)) {
	err ("Warning Can't send histogram request.");
	return False;
    }
    pthread_mutex_unlock(&i_mutex);


    dbg ("server_send_request_histogram client_ID: %s", cgp.client_ID);

    return True;
}

