#!/bin/bash

RM_PO="po/Makefile* po/POTFILES"
RM_SRC="src/Makefile src/Makefile.in src/.deps src/interface.?.bak"
RM_GLADE="Makefile Makefile.in COPYING INSTALL depcomp\
  aclocal.m4 auto*.cache config.* configure mkinstalldirs\
  missing install-sh stamp-h stamp-h? .deps\
  *.glade.bak *.gladep.bak"
RM_LIST="$RM_PO $RM_SRC $RM_GLADE"

clean(){
  if [ -e Makefile ]; then
    make clean
  else
    rm *.o *.a src/*.o src/*.a
  fi
}

cd ./src_server
clean
cd -
cd ./src_client
clean
cd -
cd ./vncviewer
clean
cd -

case $1 in
  all)
    cd ./src_server;\
    echo "rm $RM_LIST";\
    rm -rf $RM_LIST;\
    cd -;\
    cd ./src_client;\
    echo "rm $RM_LIST";\
    rm -rf $RM_LIST;\
    cd -;\
    cd ./vncviewer;\
    echo "rm $RM_LIST";\
    rm -rf $RM_LIST;\
    cd -
    ;;
esac

rm -f multivnc_server
rm -f multivnc_client
echo
echo '****** CLEAN_COMPLETE ******'
