#include "vncviewer_s.h"

extern IMAGEINFO *iinfo[MAXCLIENT];
extern int expandedWindowWidth;
extern int expandedWindowHeight;
extern IMAGEINFO *iinfo_ex;

void window_copy_area( GdkWindow *window, GdkGC *gc, gint x, gint y,
		       GdkWindow *source_window, gint source_x, gint source_y,
		       gint width, gint height )
{
  char *buf;
  buf = malloc( myFormat.bitsPerPixel * width * height );
  CopyDataFromScreen( buf, source_x, source_y, width, height );
  CopyDataToScreen( buf, x, y, width, height );
  free( buf );
  return;
}

void CreateImageInfo(gboolean flag)
{
  int srcW, srcH, dstW, dstH;
  int c_num;
  IMAGEINFO *iinfo_tmp;

  if (da_num >= draw_info[page].row * draw_info[page].column) return;
  if (!flag) {
    c_num = clientNum;
    if (drawingarea[page][da_num]->allocation.width < gdkimage[c_num]->width) {
      reducedWindowWidth = dstW = drawingarea[page][da_num]->allocation.width;
    } else {
      reducedWindowWidth = dstW = gdkimage[c_num]->width;
    }
    if (drawingarea[page][da_num]->allocation.height < gdkimage[c_num]->height) {
      reducedWindowHeight = dstH = drawingarea[page][da_num]->allocation.height;
    } else {
      reducedWindowHeight = dstH = gdkimage[c_num]->height;
    }
   iinfo_tmp = iinfo[c_num];
  } else {
    c_num = clientNum_ex;
    if ((drawingarea_ex->allocation.width < smallimage_ex->width) &&
	(drawingarea_ex->allocation.height < smallimage_ex->height)) {
      expandedWindowWidth = dstW = drawingarea_ex->allocation.width;
      expandedWindowHeight = dstH = drawingarea_ex->allocation.height;
    } else {
      expandedWindowWidth = dstW = smallimage_ex->width;
      expandedWindowHeight = dstH = smallimage_ex->height;
    }
    iinfo_tmp = iinfo_ex;
  }

  srcW = server_CB.client_grp[c_num]->serverInitMsg.framebufferWidth;
  srcH = server_CB.client_grp[c_num]->serverInitMsg.framebufferHeight;

  if (!iinfo_tmp) {
    if ((iinfo_tmp = malloc (sizeof(IMAGEINFO))) == NULL) {
      fprintf(stderr, "small image infomation malloc failed\n");
      exit(1);
    }
    if (!flag)
      iinfo[c_num] = iinfo_tmp;
    else
      iinfo_ex = iinfo_tmp;
  }

  if (!srcW | !srcH | !dstW | !dstH) exit (-1);
  iinfo_tmp->widthSrcToDst = ( dstW << SHIFTVAL ) / srcW;
  iinfo_tmp->widthDstToSrc = ( srcW << SHIFTVAL ) / dstW;
  iinfo_tmp->heightSrcToDst = ( dstH << SHIFTVAL ) / srcH;
  iinfo_tmp->heightDstToSrc = ( srcH << SHIFTVAL ) / dstH;

  return;
}


void DestroyImageInfo(int c_num)
{
  if (iinfo[c_num] == NULL) return;
  free(iinfo[c_num]);
  iinfo[c_num] = NULL;
}

