/*
 *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

/*
 * listen.c - listen for incoming connections
 */

#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/utsname.h>
#include <time.h>
#include <pthread.h>
#include "vncviewer_s.h"
#include "callbacks.h"

#define FLASHWIDTH 50	/* pixels */
#define FLASHDELAY 1	/* seconds */

Bool listenSpecified = False;

static Bool AllXEventsPredicate(Display *d, XEvent *ev, char *arg);

static char *displayname;
static void listensockReadyCallback(gpointer clientData, gint fd, GdkInputCondition condition);
extern GtkWidget *main_window;

extern pthread_t exproc_id;

static gboolean autoExpandCallback(gpointer data);

void
doListen()
{
  int i;
  XEvent ev;
  Display *d = XOpenDisplay(displayname);
  int lock_start_time;

  mainwindowShowFlag = 3;
  gtk_widget_show(main_window);
  show_gtkwindow(main_window);

  printf("name=%s\n",server_CB.server_ID);
  printf("port=%d\n", ntohs(server_CB.server_port));
  if ((server_CB.lsndsp = ConnectAdv ()) > 0) {
    server_CB.g_lsndsp = gdk_input_add_priority (server_CB.lsndsp, GDK_INPUT_READ, \
					(GdkInputFunction)listensockReadyCallback, NULL, INPUT_PRIORITY);
    printf("gdksock=%d\n",(int)server_CB.g_lsndsp);
  } else {
    printf("gdksockerror\n");
  }
  for (i = 0; i < MAXCLIENT; i++)
    server_CB.cast_src[i] = EMPTY;

  /* discard any X events */
  while( XCheckIfEvent( d, &ev, AllXEventsPredicate, NULL ));

  /* thread mutex initialize */
  pthread_mutex_init (&s_mutex, NULL);

  /* Create thread */
  pthread_create (&s_thread, NULL, (void *)image_proc_server, (void *)&server_CB);
  pthread_create (&exproc_id, NULL, exproc_callback, NULL);

  printf("[List of server pthread ID]\n");
  printf("  main             : %lu\n", pthread_self());
  printf("  image_proc_server: %lu\n", s_thread);
  printf("  exproc_callback  : %lu\n", exproc_id);

  lock_start_time = time(NULL);
  while( True ){
    gtk_main_iteration();
    /*************************************/
    /* 1. Control or VNC session create  */
    /* 2. Control socket receive         */
    /* 3. VNC socket receive             */
    /* 4. X Event comes                  */
    /*************************************/

    if ((server_CB.user_num != 0) && ((time(NULL) - lock_start_time) > LOCKTIME/2)) {
      CheckLockClient();
      lock_start_time = time(NULL);
    }
  }
}

void
listensockReadyCallback (gpointer clientData, gint fd, GdkInputCondition condition)
{
  struct sockaddr_in client_addr;
  int addrlen = sizeof(client_addr);
  int cnum;
  int tmpdsp;
  printf("listensockReadyCallback\n");
  printf("gint fd=%d\n",fd);

  /* remove listen socket */
  //gdk_input_remove(server_CB.g_lsndsp);

  /* add control socket */
  tmpdsp = accept(server_CB.lsndsp, (struct sockaddr*)&client_addr, (socklen_t *)&addrlen);
  if (tmpdsp < 0) {
    printf("listensockReadyCallback : accept error.\n");
    exit(1);
  }

  gdk_threads_enter();

  /* CTL接続済みのクライアント検索 */
  for (cnum = 0; cnum < MAXCLIENT; cnum++) {
    if (server_CB.client_grp[cnum] == NULL) continue;
    if (memcmp(&server_CB.client_grp[cnum]->client_ip, &client_addr.sin_addr, sizeof(CARD32)) == 0) {
      if ((server_CB.client_grp[cnum]->vncdsp == 0) && (server_CB.client_grp[cnum]->ctldsp != -1)) {
        /* ctl connection only */
        break;
      } else if ((server_CB.client_grp[cnum]->vncdsp != 0) && (server_CB.client_grp[cnum]->ctldsp != -1)){
        /* Already connect */
	char dummybuf[MAXBUF];
	while (read(tmpdsp, dummybuf, MAXBUF) == MAXBUF);
	shutdown(tmpdsp, SHUT_RDWR);
	close(tmpdsp);
	gdk_threads_leave();
	return;
      }
    }
  }


  /* 新規接続 */
  if (cnum == MAXCLIENT) {
    for (cnum = 0; cnum < MAXCLIENT; cnum++) {
      if (server_CB.client_grp[cnum] == NULL) {
        printf("client(cnum)=%d\n",cnum);
        break;
      }
    }
  }

  if (cnum >= MAXCLIENT) {
    printf("Access client too many.\n");
    server_CB.g_lsndsp = gdk_input_add_priority (server_CB.lsndsp, GDK_INPUT_READ, \
					(GdkInputFunction)listensockReadyCallback, NULL, INPUT_PRIORITY);
    gdk_threads_leave();
    return;
  }

  if (server_CB.client_grp[cnum] == NULL) {
    ConnectCTL(client_addr, tmpdsp, cnum);
    /* increment user number */
    server_CB.user_num++;
  } else if ((server_CB.client_grp[cnum]->vncdsp == 0) && (server_CB.client_grp[cnum]->ctldsp != -1)) {
    ConnectVNC(client_addr, tmpdsp, cnum);
    if ((exDB_flag) && (!chStateDB(cnum, 1))) {
      fprintf(stderr, "Can't Connect DB Server.\n");
    }
    if (strcmp((char *)server_CB.client_grp[cnum]->client_ID, (char *)server_CB.server_ID) == 0) {
      if (auto_expand_flag != 0) {
        //on_screen_expand_activate(NULL, (gpointer)cnum);
	gtk_timeout_add(5000, autoExpandCallback, (gpointer)cnum);
        auto_expand_flag = 0;
      }
    }
    /* 描画されないクライアントはVNCコネクション切断 */
    if ((!GETSEND(cnum)) && (!GETVIEW(cnum)) && (!GETMCTRL(cnum))) {
      if ((page != current_page) || (da_num >= draw_info[page].row * draw_info[page].column)) {
        CutVNC(cnum);
        SendVncMsg(cnum);
      }
    }
  }

  /* add listen socket */
  gdk_threads_leave();
  return;
}


/*
 * AllXEventsPredicate is needed to make XCheckIfEvent return all events.
 */

static Bool
AllXEventsPredicate(Display *d, XEvent *ev, char *arg)
{
  return True;
}

static gboolean autoExpandCallback(gpointer data)
{
	gdk_threads_enter();
	on_screen_expand_activate(NULL, data);
	gdk_threads_leave();
	return FALSE;
}
