/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <locale.h>
#include <errno.h>
#include <getopt.h>

#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "vncviewer_s.h"

#define ENABLE_NSL

int current_page;
int tab_num, page;
int mainwindowWidth = 800;
int mainwindowHeight = 600;
int exwindowWidth = 600;
int exwindowHeight = 400;
int exDB_flag = 0;
int Resend_flag = 1;
int multi_ttl = 1;
int mainwindowMonitor = -1;
int mainwindowShowFlag = 0;
int exwindowMonitor = -1;
int exwindowShowFlag = 0;
int auto_expand_flag = 0;
int use_myself_client = 1;
gboolean modifierPressed[16];
struct Draw_Info draw_info[TAB_MAX];
GtkWidget *main_window;
GtkWidget *notebook;
GtkWidget *table[TAB_MAX];
GtkWidget *frame[TAB_MAX][ROW_MAX * COLUMN_MAX];
GtkWidget *drawingarea[TAB_MAX][ROW_MAX * COLUMN_MAX];
GtkWidget *namelabel[TAB_MAX][ROW_MAX * COLUMN_MAX];
extern GtkWidget *main_window_viewport;
GtkWidget *user_list[TAB_MAX];
GtkWidget *client_name_list[TAB_MAX][ROW_MAX * COLUMN_MAX];
GtkWidget *group_name_list[TAB_MAX];

char server_ifname[IF_LENGTH];
char server_ifaddr[IF_LENGTH] = "0.0.0.0";
char server_name[IDLENGTH] = "";
extern int clientNum;
extern int window_ex_raise_flag;

int limited_mode = 0;

void
read_conf (FILE *fp)
{
  char tmpstr[64];
  char ckitem[32];
  int tmp_value = 0;

  tab_num = 0;
  while (fgets(tmpstr, 64, fp) != NULL) {
    int res = sscanf(tmpstr, "%s", ckitem);
    if (res < 0) break;
    if (strncmp("Group", ckitem, 5) == 0) {
      if (tab_num == TAB_MAX) continue;
      sscanf(tmpstr, "%s %s %d %d", ckitem, draw_info[tab_num].group_name,
	     &draw_info[tab_num].row, &draw_info[tab_num].column);
      if(draw_info[tab_num].row < 1) {
	draw_info[tab_num].row = 1;
      } else if (draw_info[tab_num].row > ROW_MAX) {
	draw_info[tab_num].row = ROW_MAX;
      }
      if(draw_info[tab_num].column < 1) {
	draw_info[tab_num].column = 1;
      } else if (draw_info[tab_num].column > COLUMN_MAX) {
	draw_info[tab_num].column = COLUMN_MAX;
      }
      tab_num++;
    } else if (strncmp("MainWindowSize", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d %d", ckitem, &mainwindowWidth, &mainwindowHeight);
      if (mainwindowWidth < 0) {
        mainwindowWidth = 0;
      }
      if (mainwindowHeight < 0) {
        mainwindowHeight = 0;
      }
    } else if (strncmp("ExpandedWindowSize", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d %d", ckitem, &exwindowWidth, &exwindowHeight);
      if (exwindowWidth < 0) {
        exwindowWidth = 0;
      }
      if (exwindowHeight < 0) {
        exwindowHeight = 0;
      }
    } else if (strncmp("exDB_flag", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &exDB_flag);
    } else if (strncmp("DB_Host", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Host);
    } else if (strncmp("DB_Port", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %hd", ckitem, &server_CB.DB_Port);
    } else if (strncmp("DB_Name", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Name);
    } else if (strncmp("DB_Pass", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Pass);
    } else if (strncmp("DB_Database", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_CB.DB_Database);
    } else if (strncmp("Resend_flag", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &Resend_flag);
    } else if (strncmp("Multi_TTL", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &multi_ttl);
    } else if (strncmp("Interface", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_ifname);
      if (get_ifaddr(server_ifname, server_ifaddr) != 0){
        exit(EXIT_FAILURE);
      }
      printf("inetrface: %s (%s)\n", server_ifname, server_ifaddr);
    } else if (strncmp("Server_ID", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %s", ckitem, server_name);
    } else if (strncmp("Ope_flag", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &tmp_value);
      if (tmp_value != 1){
        if ((tmp_value % 256) == 1){
          tmp_value = 0;
        }
      }
      server_CB.ope_flag = (CARD8)tmp_value;
      if (server_CB.ope_flag != 1){
        server_CB.ope_flag = 0;
      }
    } else if (strncmp("OpeState_Interval", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &tmp_value);
      server_CB.opestate_interval = (CARD16)tmp_value;
      if (server_CB.opestate_interval < MIN_OPESTATE_INTERVAL) {
        server_CB.opestate_interval = MIN_OPESTATE_INTERVAL;
      }
      if (server_CB.opestate_interval > MAX_OPESTATE_INTERVAL) {
	server_CB.opestate_interval = MAX_OPESTATE_INTERVAL;
      }
    } else if (strncmp("GetImage_Interval", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &tmp_value);
      server_CB.getimage_interval = (CARD16)tmp_value;
      if (server_CB.getimage_interval < MIN_GETIMAGE_INTERVAL) {
      	server_CB.getimage_interval = MIN_GETIMAGE_INTERVAL;
      }
      if (server_CB.getimage_interval > MAX_GETIMAGE_INTERVAL) {
	server_CB.getimage_interval = MAX_GETIMAGE_INTERVAL;
      }
    } else if (strncmp("Freeze_Count", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &tmp_value);
      if (tmp_value >= 256){
	tmp_value = MAX_FREEZE_COUNT;
      }
      server_CB.freeze_count = (CARD8)tmp_value;
      if (server_CB.freeze_count < MIN_FREEZE_COUNT) {
        server_CB.freeze_count = MIN_FREEZE_COUNT;
      }
      if (server_CB.freeze_count > MAX_FREEZE_COUNT) {
	server_CB.freeze_count = MAX_FREEZE_COUNT;
      }
    } else if (strncmp("MainWindowMonitor", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &mainwindowMonitor);
      if (mainwindowMonitor < 0) {
        mainwindowMonitor = -1;
      }
      tmp_value = gdk_screen_get_n_monitors(gdk_screen_get_default());
      if (mainwindowMonitor >= tmp_value) {
        mainwindowMonitor = -1;
      }
    } else if (strncmp("ExpandedWindowMonitor", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &exwindowMonitor);
      if (exwindowMonitor < 0) {
        exwindowMonitor = -1;
      }
      tmp_value = gdk_screen_get_n_monitors(gdk_screen_get_default());
      if (exwindowMonitor >= tmp_value) {
        exwindowMonitor = -1;
      }
    } else if (strncmp("AutoExpand", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &auto_expand_flag);
    } else if (strncmp("UseMyselfClient", ckitem, strlen(ckitem)) == 0) {
      sscanf(tmpstr, "%s %d", ckitem, &use_myself_client);
    }
  }
  if (tab_num == 0) {
    strcpy(draw_info[tab_num].group_name,"group1");
    draw_info[tab_num].row    = 2;
    draw_info[tab_num].column = 2;
    tab_num = 1;
  }
}


int
main (int argc, char *argv[])
{
  int i, pCnt, dCnt;
  FILE *fp;
  int c;

  system("killall multivnc_client >/dev/null 2>&1");
  system("vncserver -kill :1 >/dev/null 2>&1");

#ifdef ENABLE_NLS
  setlocale(LC_ALL, "");
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  XInitThreads();
  g_thread_init(NULL);
  gdk_threads_init();
  gtk_init (&argc, &argv);

  memset(&server_CB, 0, sizeof(struct server_cb));
  //  AdvInit();

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  
  /* デフォルト設定 */
  tab_num = 1;
  strcpy(draw_info[0].group_name, "group1");
  draw_info[0].row = 2;
  draw_info[0].column = 2;
  mainwindowWidth = WINDOW_WIDTH;
  mainwindowHeight = WINDOW_HEIGHT;
  exwindowWidth = EXWINDOW_WIDTH;
  exwindowHeight = EXWINDOW_HEIGHT;
  exDB_flag = 0;
  Resend_flag = 0;
  mainwindowMonitor = -1;
  exwindowMonitor = -1;
  server_CB.ope_flag = 0;
  server_CB.opestate_interval = DEFAULT_OPESTATE_INTERVAL;
  server_CB.getimage_interval = DEFAULT_GETIMAGE_INTERVAL;
  server_CB.freeze_count = LENGTH_TIME_SEQ;
  
  /* 設定ファイルの読み込み */
  if ((fp = fopen(CONFIG_FILE, "r")) || (fp = fopen(argv[1], "r")) != NULL) {
    read_conf(fp);
    fclose(fp);
  }

  /* コマンドライン引数の読み込み */
  while ((c = getopt(argc, argv, "lu:")) != -1) {
    switch (c) {
      case 'l':
        limited_mode = 1;
	break;
      case 'u':
        memset(server_name, 0, IDLENGTH);
        strncpy(server_name, optarg, IDLENGTH - 1);
        break;
      case '?':
      default:
        exit(EXIT_FAILURE);
    }
  }

  AdvInit();

  for (i = 0; i < 16; i++)
    modifierPressed[i] = False;

  for (pCnt = 0; pCnt < TAB_MAX; pCnt++) 
    for (dCnt = 0; dCnt < TABGROUP_MAX; dCnt++)
      draw_info[pCnt].client_num[dCnt] = EMPTY;

  /* メインウィンドウの作成 */
  main_window = create_main_window ();
  gtk_window_set_default_size(GTK_WINDOW(main_window), mainwindowWidth, mainwindowHeight);
  if (limited_mode != 0) {
    GtkWidget *menu = lookup_widget(main_window, "menubar");
    gtk_widget_hide(menu);
  }
  
  /* notebookウィジェットの作成 */
  notebook = gtk_notebook_new ();
  GtkWidget *main_window_viewport = lookup_widget(GTK_WIDGET(main_window), "main_window_viewport");
  gtk_widget_show (notebook);
  gtk_container_add (GTK_CONTAINER (main_window_viewport), notebook);
  gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), TRUE);
  current_page = 0;
  g_signal_connect ((gpointer) notebook, "switch_page",
                    G_CALLBACK (on_notebook_switch_page),
		    NULL);

  /* tableウィジェットの作成 */
  for (pCnt = 0; pCnt < tab_num; pCnt++) {
    makeTable (pCnt, draw_info[pCnt].row, draw_info[pCnt].column);
  }

  vnc_main (argc, argv);

  return 0;
}

/* ユーザ一覧作成用 Widget */
GtkWidget*
create_user_list (int page)
{
  GtkWidget *frame_ulist;
  GtkWidget *alignment1;
  GtkWidget *table_ulist;
  int posit = 0;
  int i, j;

  char font_name[64];
  PangoFontDescription *font_dsp;
  GdkColor color;

  frame_ulist = gtk_frame_new (NULL);
  gtk_widget_show (frame_ulist);
  gtk_container_set_border_width (GTK_CONTAINER (frame_ulist), 4);
  gtk_frame_set_label_align (GTK_FRAME (frame_ulist), 0.5, 0.5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame_ulist), GTK_SHADOW_ETCHED_OUT);

  gtk_widget_set_events (frame_ulist, GDK_EXPOSURE_MASK | GDK_ENTER_NOTIFY_MASK | GDK_BUTTON_PRESS_MASK
			     | GDK_LEAVE_NOTIFY_MASK | GDK_STRUCTURE_MASK);

  // frame color //
  gdk_color_parse("cyan", &color);
  gtk_widget_modify_bg(GTK_WIDGET(frame_ulist), GTK_STATE_NORMAL, &color);

  alignment1 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (frame_ulist), alignment1);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment1), 0, 0, 4, 4);

  table_ulist = gtk_table_new (8, 2, FALSE);
  gtk_widget_show (table_ulist);
  gtk_container_add (GTK_CONTAINER (alignment1), table_ulist);

  // font setting //
  memcpy(font_name, "\0", sizeof(font_name));
  memcpy(font_name, "IPAゴシック 12", sizeof(font_name));
  font_dsp = pango_font_description_from_string(font_name);

  /* 1グループで2列のクライアントリスト表示 */
  for (i = 0; i < draw_info[page].row; i++) {
    for (j = 0; j < draw_info[page].column; j++) {
      client_name_list[page][posit] = gtk_label_new (_("no client"));
      gtk_widget_show (client_name_list[page][posit]);
      gtk_table_attach (GTK_TABLE (table_ulist), client_name_list[page][posit], j, j+1, i, i+1,
                      (GtkAttachOptions) (GTK_EXPAND),
                      (GtkAttachOptions) (0), 0, 0);
      gtk_label_set_justify (GTK_LABEL (client_name_list[page][posit]), GTK_JUSTIFY_CENTER);
      gtk_misc_set_alignment (GTK_MISC (client_name_list[page][posit]), 0, 0.5);
      gtk_misc_set_padding (GTK_MISC (client_name_list[page][posit]), 5, 0);

      gtk_widget_modify_font (client_name_list[page][posit], font_dsp);
      gdk_color_parse("SlateGray", &color);
      gtk_widget_modify_fg(GTK_WIDGET(client_name_list[page][posit]), GTK_STATE_NORMAL, &color);
      posit++;
    }
  }

  /* グループ名ラベル */
  group_name_list[page] = gtk_label_new (_("<b>group</b>"));
  gtk_widget_show (group_name_list[page]);
  gtk_frame_set_label_widget (GTK_FRAME (frame_ulist), group_name_list[page]);
  gtk_label_set_use_markup (GTK_LABEL (group_name_list[page]), TRUE);
  gtk_label_set_justify (GTK_LABEL (group_name_list[page]), GTK_JUSTIFY_CENTER);

  // font setting //
  memcpy(font_name, "\0", sizeof(font_name));
  memcpy(font_name, "IPAゴシック Bold 14", sizeof(font_name));
  font_dsp = pango_font_description_from_string(font_name);
  gtk_widget_modify_font (group_name_list[page], font_dsp);

  g_signal_connect ((gpointer) frame_ulist, "button_press_event",
                    G_CALLBACK (on_frame_ulist_press_event),
                    NULL);

  return frame_ulist;
}

void makeTable( int p, int x, int y )
{
  int xCnt, yCnt;
  int index, user_data;
  char client_name[IDLENGTH];
  GtkWidget *tab[TAB_MAX];
  GtkWidget *da;
  GtkWidget *list_p;

  draw_info[p].row = x;
  draw_info[p].column = y;

  /* tableウィジェットの作成 or リサイズ */
  if (table[p] == NULL) {
    table[p] = gtk_table_new (x*2, y, FALSE);
    gtk_widget_show (table[p]);
    gtk_container_add (GTK_CONTAINER (notebook), table[p]);

  }
  else {
    gtk_table_resize (GTK_TABLE(table[p]), x*2, y);
  }

  // ユーザ一覧の変更 //
  list_p = lookup_widget(GTK_WIDGET(main_window), "hbox_ulist");
  gtk_widget_hide(list_p);
  user_list[p]  = create_user_list(p);
  gtk_container_add (GTK_CONTAINER(list_p), user_list[p]);
  gtk_widget_show(list_p);

  /* label, drawing areaの作成 */
  for (xCnt = 0; xCnt < x; xCnt++) {
    for (yCnt = 0; yCnt < y; yCnt++) {
      index = xCnt * y + yCnt;

      /* labelウィジェットの作成 */
      if (draw_info[p].client_num[index] != EMPTY)
	strcpy(client_name, (char *)server_CB.client_grp[draw_info[p].client_num[index]]->client_ID);
      else
	strcpy(client_name, "no client");

      namelabel[p][index] = gtk_label_new(client_name);
      gtk_widget_show(namelabel[p][index]);
      gtk_table_attach (GTK_TABLE (table[p]), namelabel[p][index], yCnt, yCnt+1, xCnt*2, xCnt*2+1,
			(GtkAttachOptions) (GTK_FILL),
			(GtkAttachOptions) (GTK_FILL), 0, 0);
      gtk_widget_set_size_request (namelabel[p][index], -1, 15);

      gtk_label_set_text(GTK_LABEL(client_name_list[p][index]), client_name);

      /* クライアント描画領域の作成 */
      frame[p][index] = gtk_aspect_frame_new(NULL, 0.5, 0.5, (float)4/3, FALSE);
      gtk_frame_set_label_align(GTK_FRAME(frame[p][index]), 0.0, 0.5);

      gtk_widget_show(frame[p][index]);
      gtk_table_attach (GTK_TABLE (table[p]), frame[p][index], yCnt, yCnt+1, xCnt*2+1, xCnt*2+2,
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

      gtk_frame_set_shadow_type(GTK_FRAME(frame[p][index]), GTK_SHADOW_ETCHED_OUT);      

      /* drawing areaウィジェットの作成 */
      drawingarea[p][index] = gtk_drawing_area_new ();
      da = drawingarea[p][index];
      gtk_widget_set_events (da, GDK_EXPOSURE_MASK | GDK_ENTER_NOTIFY_MASK | GDK_BUTTON_PRESS_MASK
			     | GDK_LEAVE_NOTIFY_MASK | GDK_STRUCTURE_MASK);
      gtk_widget_show (da);
      gtk_container_add(GTK_CONTAINER(frame[p][index]), da);
      

      user_data = (p << 8) + index;
      g_signal_connect ((gpointer) da, "configure_event",
		        G_CALLBACK (on_main_drawingarea_configure_event),
		        (gpointer)user_data);
      g_signal_connect ((gpointer) da, "expose_event",
		        G_CALLBACK (on_main_drawingarea_expose_event),
		        (gpointer)user_data);
      g_signal_connect ((gpointer) da, "button_press_event",
		        G_CALLBACK (on_main_drawingarea_button_press_event),
		        (gpointer)user_data);

      set_client_color(p, index);
    }
  }

  /* user listのグループにグループ名を付加する */
  gtk_label_set_text (GTK_LABEL(group_name_list[p]), draw_info[p].group_name);

  /* notebookウィジェットのタブにグループ名を付加する */
  tab[p] = gtk_label_new (draw_info[p].group_name);
  gtk_widget_show (tab[p]);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), p),
			      tab[p]);

}


void ChangeLabel(int p, int d, char *name)
{
  int x = d / draw_info[p].column;
  int y = d % draw_info[p].column;

  // change user list name //
  gtk_label_set_text(GTK_LABEL(client_name_list[p][d]), name);

  gtk_container_remove(GTK_CONTAINER(table[p]), namelabel[p][d]);
  namelabel[p][d] = gtk_label_new(name);
  gtk_widget_show(namelabel[p][d]);
  gtk_table_attach (GTK_TABLE (table[p]), namelabel[p][d], y, y+1, x*2, x*2+1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  set_client_color(p, d);
}

void runExpand(int flag, unsigned char *maddr)
{
	int id;

	if (flag == 0) {
		// close window_ex
		if (window_ex != NULL) {
			gdk_threads_enter();
			on_window_ex_delete_event(NULL, NULL, NULL);
			gdk_threads_leave();
		}
	} else {
		id = mac2id(maddr);
		if (id == -1) {
			return;
		}
		if (gdkimage[id] == NULL) {
			return;
		}
		printf("current_page: %d\n", current_page);
		printf("draw_page: %d\n", server_CB.client_grp[id]->draw_page);
		if (server_CB.client_grp[id]->draw_page != current_page) {
			SETVIEW(id, TRUE);
			SendAllowMsg(id, (char *)server_CB.client_grp[id]->client_ID);
		}
		if (flag == 2) {
			// window_ex show raise
			window_ex_raise_flag = 1;
		} else {
			// window_ex show
			window_ex_raise_flag = 0;
		}
		gdk_threads_enter();
		on_screen_expand_activate(NULL, (gpointer)id);
		gdk_threads_leave();
	}
}

void runList(unsigned char **maddr, int len)
{
	struct {
		int row;
		int col;
	} areapos[] = { {1, 1}, {1, 2}, {2, 2}, {2, 2},
	                {2, 3}, {2, 3}, {3, 3}, {3, 3},
	                {3, 3}, {3, 4}, {3, 4}, {3, 4},
	                {4, 4}, {4, 4}, {4, 4}, {4, 4} };
	
	int i;
	int j;
	int k;
	int id;
	int count;
	int empty_pos;
	int isMove;
	GtkWidget *widget;
	static unsigned char total = 0;

	// ユーザの存在確認
	count = 0;
	for (i = 0; i < len; i++) {
		if (mac2id(maddr[i]) != -1) {
			count++;
		}
	}
	if (count == 0) return;

	// 新しいタブの設定
	if (tab_num == TAB_MAX) return;
	total++;
	sprintf(draw_info[tab_num].group_name, "view%d", total);
	draw_info[tab_num].row = areapos[count - 1].row;
	draw_info[tab_num].column = areapos[count - 1].col;
	tab_num++;

	// GTKウィジェットの削除
	gdk_threads_enter();
	for (i = 0; i < tab_num - 1; i++) {
		widget = lookup_widget(GTK_WIDGET(main_window), "hbox_ulist");
		gtk_container_remove(GTK_CONTAINER(widget), user_list[i]);
		for (j = 0; j < draw_info[i].row * draw_info[i].column; j++) {
			gtk_container_remove(GTK_CONTAINER(frame[i][j]), drawingarea[i][j]);
			gtk_container_remove(GTK_CONTAINER(table[i]), frame[i][j]);
			gtk_container_remove(GTK_CONTAINER(table[i]), namelabel[i][j]);
		}
	}
	gdk_threads_leave();

	// ユーザの移動
	for (i = 0; i < tab_num - 1; i++) {
		for (j = 0; j < draw_info[i].row * draw_info[i].column; j++) {
			if (draw_info[i].client_num[j] == EMPTY) continue;
			for (k = 0; k < len; k++) {
				id = mac2id(maddr[k]);
				if (id == -1) continue;
				if (draw_info[i].client_num[j] == id) {
					draw_info[tab_num - 1].client_num[k] = draw_info[i].client_num[j];
					draw_info[i].client_num[j] = EMPTY;
					break;
				}
			}
		}
	}

	// ユーザの整列（タブの中）
	for (i = 0; i < tab_num; i++) {
		do {
			isMove = 0;
			empty_pos = TABGROUP_MAX;
			for (j = 0; j < TABGROUP_MAX; j++) {
				if (draw_info[i].client_num[j] == EMPTY) {
					if (empty_pos > j) {
						empty_pos = j;
					}
				} else {
					if (empty_pos < j) {
						draw_info[i].client_num[empty_pos] = draw_info[i].client_num[j];
						draw_info[i].client_num[j] = EMPTY;
						isMove = 1;
						break;
					}
				}
			}
		} while (isMove);
		for (j = 0; j < TABGROUP_MAX; j++) {
			if (draw_info[i].client_num[j] == EMPTY) {
				break;
			}
		}
		count = j;
		if (count != 0) {
			draw_info[i].row = areapos[count - 1].row;
			draw_info[i].column = areapos[count - 1].col;
		}
	}

	// ユーザの整列（空タブを詰める）
	do {
		isMove = 0;
		empty_pos = TAB_MAX;
		for (i = 0; i < tab_num; i++) {
			if (draw_info[i].client_num[0] == EMPTY) {
				if (empty_pos > i) {
					empty_pos = i;
				}
			} else {
				if (empty_pos < i) {
					memset(draw_info[empty_pos].group_name, 0, IDLENGTH);
					strncpy(draw_info[empty_pos].group_name, draw_info[i].group_name, IDLENGTH - 1);
					draw_info[empty_pos].row = draw_info[i].row;
					draw_info[empty_pos].column = draw_info[i].column;
					for (j = 0; j < draw_info[i].row * draw_info[i].column; j++) {
						draw_info[empty_pos].client_num[j] = draw_info[i].client_num[j];
						draw_info[i].client_num[j] = EMPTY;
					}
					isMove = 1;
					break;
				}
			}
		}
	} while (isMove);

	// 空タブの削除
	for (i = 0; i < TAB_MAX; i++) {
		if (draw_info[i].client_num[0] == EMPTY) {
			gdk_threads_enter();
			for (j = tab_num - 2; j >= i; j--) {
				gtk_container_remove(GTK_CONTAINER(notebook), table[j]);
				table[j] = NULL;
			}
			gdk_threads_leave();
			tab_num = i;
			break;
		}
	}

	// VNCコネクションの再接続
	gdk_threads_enter();
	for (i = 0; i < tab_num; i++) {
		for (j = 0; j < draw_info[i].row * draw_info[i].column; j++) {
			id = draw_info[i].client_num[j];
			if (id == EMPTY) continue;
			server_CB.client_grp[id]->draw_page = i;
			server_CB.client_grp[id]->draw_area = j;
			if ((i == current_page) || (GETVIEW(id)) || (GETSEND(id) || (GETMCTRL(id)))) {
				SendAllowMsg(id, (char *)server_CB.client_grp[id]->client_ID);
			} else {
				CutVNC(id);
				SendVncMsg(id);
			}
		}
		makeTable(i, draw_info[i].row, draw_info[i].column);
	}
	gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), tab_num - 1);
	show_gtkwindow(main_window);
	gdk_threads_leave();
}

void runSendScreen(int flag, unsigned char **maddr, int len)
{
  int user_cnt, src_client = 0, mcnum = 0, c_num, i, m;
  gboolean send_flag = FALSE;
  gboolean recv_flag = FALSE;
  char fullscreen_flag = 0;
  int x;
  int y;
  int sender;
  int is_send;
  extern gboolean recv_state_tmp[MAXCLIENT];
  extern gboolean send_state_tmp[MAXCLIENT];

  user_cnt = 0;
  for (x = 0; x < MAXCLIENT; x++) {
    if (server_CB.client_grp[x] == NULL) continue;
    recv_state_tmp[x] = GETRECV(x);
    send_state_tmp[x] = GETSEND(x);
    if (server_CB.user_num == ++user_cnt) break;
  }

  /* 送信元クライアントの探索 */
  if (flag){
  src_client = mac2id(maddr[0]);
  if ((src_client != -1) && (!GETSEND(src_client))) {
    send_flag = TRUE;
  }

  /* 使用できるマルチキャストグループ番号を探索 */
  for (mcnum = 0; mcnum < MAXCLIENT; mcnum++) {
    if (server_CB.cast_src[mcnum] == EMPTY) break;
  }

  /* 送信元と送信先がともに存在する時に限り, 新規にマルチキャストグループを
     生成する. 
   */
  if (send_flag) {
	for (x = 1; x < len; x++) {
	  c_num = mac2id(maddr[x]);
	  if ((c_num == -1) || (c_num == src_client)) continue;
	  if (strcmp((char *)server_CB.client_grp[c_num]->client_ID, (char *)server_CB.server_ID) == 0) continue;
	  if ((m = server_CB.client_grp[src_client]->cast_grp) != EMPTY) {
	    server_CB.cast_src[m] = EMPTY;
	    server_CB.client_grp[src_client]->cast_grp = EMPTY;
	    user_cnt = 0;
	    for (i = 0; i < MAXCLIENT; i++) {
	      if (server_CB.client_grp[i] == NULL) continue;
	      if (server_CB.client_grp[i]->recv_grp == m) {
		server_CB.client_grp[i]->recv_grp = EMPTY;
	      }
	      if (server_CB.user_num == ++user_cnt) break;
	    }
          }
	  server_CB.client_grp[c_num]->recv_grp = mcnum;
	  recv_state_tmp[c_num] = TRUE;
	  recv_flag = TRUE;
        }
    if (recv_flag) {
      send_state_tmp[src_client] = TRUE;
      server_CB.cast_src[mcnum] = src_client;
      server_CB.client_grp[src_client]->cast_grp = mcnum;
    }
  }
  } else {
    for (x = 0; x < len; x++) {
      c_num = mac2id(maddr[x]);
      if (c_num == -1) continue;
      recv_state_tmp[c_num] = FALSE;
      sender = -1;
      is_send = 0;
      for (y = 0; y < MAXCLIENT; y++) {
        if (!server_CB.client_grp[y]) continue;
	if (c_num == y) continue;
	if ((server_CB.client_grp[y]->cast_grp == server_CB.client_grp[c_num]->recv_grp) && (send_state_tmp[y] == TRUE)) {
	  sender = y;
	}
	if ((server_CB.client_grp[y]->recv_grp == server_CB.client_grp[c_num]->recv_grp) && recv_state_tmp[y] == TRUE) {
	  is_send = 1;
	  break;
	}
      }
      if ((!is_send) && (sender != -1)) {
        send_state_tmp[sender] = FALSE;
      }
    }
  }

  /*
    送信元クライアントの設定
   */
  gdk_threads_enter();
  user_cnt = 0;
  for (c_num = 0; c_num < MAXCLIENT; c_num++) {
    if (server_CB.client_grp[c_num] == NULL) continue;
    if ((send_state_tmp[c_num] && !GETSEND(c_num)) || (!send_state_tmp[c_num] && GETSEND(c_num))) {
      SETSEND(c_num, send_state_tmp[c_num]);
      if (GETSEND(c_num)) {
	int pchild;
	int shm_id;
	int shm_key = mcnum;
        server_CB.cstdsp[mcnum] = CreateMultiSockToSend (server_CB.casting_ip[mcnum], server_CB.casting_port);

	printf("mcnum=%d %d\n",mcnum,shm_key);
	do {
	  shm_id = shmget ((key_t)shm_key, sizeof(struct Shm_asym), 0666 | IPC_CREAT);
	  if (shm_id == -1) {
	    fprintf(stderr, "error : shm_id errno=%d key(grp)=%d clientNum=%d\n",errno,shm_key,c_num);
	    shm_key++;
	    printf("err:mcnum=%d %d\n",mcnum,shm_key);
	  }
	} while (shm_id < 0);
	
	shm_asym[c_num] = (struct Shm_asym *)shmat(shm_id, 0, 0);
	if ((int)shm_asym[c_num] == -1) {
	  fprintf(stderr, "error : shm_asym[%d]\n",c_num);
	  return;
	}
	bzero(shm_asym[c_num], sizeof(struct Shm_asym));
	(*shm_asym[c_num]).ave_delay = 0;
	server_CB.client_grp[c_num]->shm_id = shm_id;

	if ((pchild = fork()) == 0) {
	  /* Child */
	  SendCast(c_num);
	  exit (0);
	}
	server_CB.client_grp[c_num]->calcrate_tag = \
	  gtk_timeout_add (CALC_INTERVAL, (GtkFunction)calcRateCallback, (gpointer)c_num);
	if (Resend_flag)
	  server_CB.client_grp[c_num]->resend_tag = \
	    gtk_timeout_add (RESEND_INTERVAL, (GtkFunction)resendCallback, (gpointer)c_num);
	calcRateCallback ((gpointer)c_num);
	SendAllowMsg(c_num, (char *)server_CB.client_grp[c_num]->client_ID);
      } else {
	(*shm_asym[c_num]).flag = CAST_STOP;
	int shmctlck;
	int res = shmdt(shm_asym[c_num]);
	shmctlck = shmctl(server_CB.client_grp[c_num]->shm_id, IPC_RMID, 0);
	printf("shm_deleted.(%d) ctlck=%d(errno=%d) client=%d grp=%d\n", \
	    res,shmctlck,errno,c_num,server_CB.client_grp[c_num]->cast_grp);
	server_CB.cast_src[server_CB.client_grp[c_num]->cast_grp] = EMPTY;
	shm_asym[c_num] = NULL;

	gtk_timeout_remove (server_CB.client_grp[c_num]->calcrate_tag);
	if (Resend_flag)
	  gtk_timeout_remove (server_CB.client_grp[c_num]->resend_tag);
        shutdown (server_CB.cstdsp[server_CB.client_grp[c_num]->cast_grp], SHUT_RDWR);
        close (server_CB.cstdsp[server_CB.client_grp[c_num]->cast_grp]);
	server_CB.client_grp[c_num]->cast_grp = EMPTY;
        if ((server_CB.client_grp[c_num]->draw_page != current_page) && (!GETVIEW(c_num)) && (!GETMCTRL(c_num))) {
          CutVNC(c_num);
          SendVncMsg(c_num);
        }
      }
    }
    if (server_CB.user_num == ++user_cnt) break;
  }
  gdk_threads_leave();

  /*
    送信先クライアントの設定, 各クライアントに通知
   */
  user_cnt = 0;
  for (c_num = 0; c_num < MAXCLIENT; c_num++) {
    if (server_CB.client_grp[c_num] == NULL) continue;
    if ((!recv_state_tmp[c_num] && GETRECV(c_num)) || (recv_state_tmp[c_num] && !GETRECV(c_num))) {
      SETRECV(c_num, recv_state_tmp[c_num]);
      if (!GETRECV(c_num)) {
        server_CB.client_grp[c_num]->recv_grp = EMPTY;
      }
      SendCastMsg(GETRECV(c_num), c_num, fullscreen_flag);
      exprocSendStatusChangedMsg(c_num, makeClientStatus(c_num));
    }
    if (server_CB.user_num == ++user_cnt) break;
  }

  /*
    送信元クライアントの画像データを要求
   */
  user_cnt = 0;
  for (c_num = 0; c_num < MAXCLIENT; c_num++) {
    if (server_CB.client_grp[c_num] == NULL) continue;
    if (GETSEND(c_num)) {
      gdk_threads_enter();
      clientNum = c_num;
      if (SendAllFramebufferUpdateRequestSpecified(server_CB.client_grp[c_num]->vncdsp) == False) {
	printf("error : SendAllFramebufferUpdateRequest\n");
      }
      gdk_threads_leave();
    }
    if (server_CB.user_num == ++user_cnt) break;
  }
}

void runOperate(int flag, unsigned char **maddr, int len)
{
	int id;
	int ownID;
	int i;

	if (len <= 0) {
		return;
	}
	
	if (flag == 0) {
		for (i = 0; i < len; i++) {
			id = mac2id(maddr[i]);
			if ((id == -1) || (!GETCTRL(id))) {
				continue;
			}
			gdk_threads_enter();
			on_screen_ctrl_activate(NULL, (gpointer)id);
			on_window_ex_delete_event(NULL, NULL, NULL);
			gdk_threads_leave();
		}
	} else {
		id = mac2id(maddr[0]);
		if ((id == -1) || (GETCTRL(id))) {
			return;
		}
		if (server_CB.client_grp[id]->draw_page != current_page) {
			SETVIEW(id, TRUE);
			SendAllowMsg(id, (char *)server_CB.client_grp[id]->client_ID);
		}
		gdk_threads_enter();
		on_screen_ctrl_activate(NULL, (gpointer)id);
		gdk_threads_leave();
		ownID = id;
		for (i = 1; i < len; i++) {
			id = mac2id(maddr[i]);
			if ((id == -1) || (id == ownID)) {
				continue;
			}
			SETMCTRL(id, TRUE);
			if (server_CB.client_grp[id]->draw_page != current_page) {
				SendAllowMsg(id, (char *)server_CB.client_grp[id]->client_ID);
			}
    			exprocSendStatusChangedMsg(id, makeClientStatus(id));
		}
	}
}

void runLock(int flag, unsigned char *maddr)
{
	int id;

	id = mac2id(maddr);
	if (id == -1) {
		return;
	}
	if ((GETLOCK(id)?1:0) != (flag?1:0)) {
		gdk_threads_enter();
		on_screen_lock_activate(NULL, (gpointer)id);
		gdk_threads_leave();
	}
}

void runDisconnect(unsigned char *maddr)
{
	int id;

	id = mac2id(maddr);
	if (id == -1) {
		return;
	}

    // controlSocketCallback()のクライアント消去処理に合わせる
    clientNum = id;
    gdk_threads_enter();
    /* クライアント消去 */
    if ((exDB_flag) && (!chStateDB(clientNum, 0))) {
      fprintf(stderr, "Can't Connect DB Server.\n");
    }

    // 画面送信を停止
    if (GETSEND(clientNum)) {
      // remove reciever
      int i;
      for (i = 0; i < MAXCLIENT; i++) {
        if (server_CB.client_grp[i] == NULL) continue;
	if (!GETRECV(i)) continue;
        if (server_CB.client_grp[i]->recv_grp != server_CB.client_grp[clientNum]->cast_grp) continue;
	server_CB.client_grp[i]->recv_grp = EMPTY;
        SETRECV(i, FALSE);
        SendCastMsg(GETRECV(i), i, 0);
        exprocSendStatusChangedMsg(i, makeClientStatus(i));
      }
      // remove sender
      int c_num = clientNum;
      (*shm_asym[c_num]).flag = CAST_STOP;
      int shmctlck;
      int res = shmdt(shm_asym[c_num]);
      shmctlck = shmctl(server_CB.client_grp[c_num]->shm_id, IPC_RMID, 0);
      printf("shm_deleted.(%d) ctlck=%d(errno=%d) client=%d grp=%d\n", \
        res,shmctlck,errno,c_num,server_CB.client_grp[c_num]->cast_grp);
      server_CB.cast_src[server_CB.client_grp[c_num]->cast_grp] = EMPTY;
      shm_asym[c_num] = NULL;

      gtk_timeout_remove (server_CB.client_grp[c_num]->calcrate_tag);
      if (Resend_flag)
        gtk_timeout_remove (server_CB.client_grp[c_num]->resend_tag);
      shutdown (server_CB.cstdsp[server_CB.client_grp[c_num]->cast_grp], SHUT_RDWR);
      close (server_CB.cstdsp[server_CB.client_grp[c_num]->cast_grp]);
    }
    // 画面操作を停止
    if (GETCTRL(clientNum)) {
      int i;
      for (i = 0; i < MAXCLIENT; i++) {
        if (server_CB.client_grp[i] == NULL) continue;
	if (!GETMCTRL(i)) continue;
        SETMCTRL(i, FALSE);
        exprocSendStatusChangedMsg(i, makeClientStatus(i));
        if ((server_CB.client_grp[i]->draw_page != current_page) && (!GETSEND(i))) {
          CutVNC(i);
          SendVncMsg(i);
        }
      }
    }

    if (server_CB.client_grp[clientNum]->g_vncdsp != 0) {
      int p,d;
      GdkRectangle gdkrect;

      DestroyImageInfo(clientNum);
      p = server_CB.client_grp[clientNum]->draw_page;
      d = server_CB.client_grp[clientNum]->draw_area;
      draw_info[p].client_num[d] = EMPTY;
      if (draw_info[p].row * draw_info[p].column > d) {
	ChangeLabel(p, d, "no client");
	gdk_draw_rectangle(gdkpixmap[p][d], drawingarea[p][d]->style->white_gc, TRUE,
			   0, 0, drawingarea[p][d]->allocation.width,
			   drawingarea[p][d]->allocation.height);
	gdkrect.x = 0;
	gdkrect.y = 0;
	gdkrect.width = drawingarea[p][d]->allocation.width;
	gdkrect.height = drawingarea[p][d]->allocation.height;
	gtk_widget_draw(drawingarea[p][d], &gdkrect);
      }
      if (gdkimage[clientNum]) {
	gdk_image_destroy(gdkimage[clientNum]);
	gdkimage[clientNum] = NULL;
      }
      if (smallimage[clientNum]) {
	gdk_image_destroy(smallimage[clientNum]);
	smallimage[clientNum] = NULL;
      }
      printf("Init cnum=%d\n",clientNum);
      CutVNC(clientNum);
    }

    if ((clientNum == clientNum_ex) && (window_ex != NULL)) {
      gtk_widget_destroy(window_ex);
      window_ex = NULL;
      exprocSendWindowChangedMsg(1, 2);
    }
    gdk_input_remove(server_CB.client_grp[clientNum]->g_ctldsp);
    shutdown(server_CB.client_grp[clientNum]->ctldsp, SHUT_RDWR);
    close(server_CB.client_grp[clientNum]->ctldsp);
    exprocSendStatusChangedMsg(clientNum, 0);
    bzero (server_CB.client_grp[clientNum], sizeof(struct client_grp));
    free(server_CB.client_grp[clientNum]);
    server_CB.client_grp[clientNum] = NULL;
    server_CB.user_num--;
    gdk_threads_leave();

}

