#include "vncviewer_s.h"
#include "callbacks.h"
#include <sys/socket.h>
#include <resolv.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <errno.h>
#include <mysql.h>

#include <unistd.h>
#include <sys/shm.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <signal.h>

typedef struct _GdkIOClosure GdkIOClosure;
struct _GdkIOClosure
{
  GdkInputFunction function;
  GdkInputCondition condition;
  GdkDestroyNotify notify;
  gpointer data;
};

static void controlSocketCallback(gpointer clientData, gint fd, GdkInputCondition condition);
static void vncSocketCallback(gpointer clientData, gint fd, GdkInputCondition condition);
static Bool CheckDrawingarea(int);
static Bool DiscoverDrawingarea(int);
void CheckLockClient(void);

int getClientFromCtldsp (int fd);
int getClientFromVncdsp (int fd);
void SendCastMsg (char flag, int clientNum, char fullscreen);
int ConnectMyself ();
Bool AuthDB (char *client_ID);
void SendOpeStateDecisionMsg (int clientNum);
int mac2id(unsigned char *maddr);
unsigned char makeClientStatus(int clientNum);
void exprocSendStatusChangedMsg(int clientNum, unsigned char status);
void* exproc_callback(void *args);
static void exprocMsgRegister(unsigned char *msg, int len);
static void exprocMsgExpand(unsigned char *msg, int len);
static void exprocMsgList(unsigned char *msg, int len);
static void exprocMsgSendscreen(unsigned char *msg, int len);
static void exprocMsgOperate(unsigned char *msg, int len);
static void exprocMsgLock(unsigned char *msg, int len);
static void exprocMsgDisconnect(unsigned char *msg, int len);
static gboolean timeoutVncConnectCallback(gpointer data);

extern int multi_ttl;
extern GtkWidget *main_window;
GtkWidget *dialog_IDinput;

extern char server_name[IDLENGTH];

/* shared memory */
long *shm_sec;
long *shm_usec;
struct timeval timenow;
struct Shm_asym *shm_asym[MAXCLIENT];

/* semaphore */
int semaphore;
struct sembuf semb;
union semun {
  int val;
  struct semid_ds *buf;
  unsigned short *array;
  struct seminfo *__buf;
};

/* exproc */
pthread_t exproc_id;
unsigned int exproc_ip = 0;
unsigned short exproc_port = 0;

int
SendAdv ()
{
  int sockadv;
  int pchild;
  int shm_id_s;
  int shm_id_u;
  
  shm_id_s = shmget ((key_t)1111, sizeof(long), 0666 | IPC_CREAT);
  if (shm_id_s == -1) {
    fprintf(stderr, "error : shm_id_s\n");
    exit (1);
  }
  shm_id_u = shmget ((key_t)2222, sizeof(long), 0666 | IPC_CREAT);
  if (shm_id_u == -1) {
    fprintf(stderr, "error : shm_id_u\n");
    exit (1);
  }
  shm_sec = (long *)shmat(shm_id_s, 0, 0);
  if ((int)shm_sec == -1) {
    fprintf(stderr, "error : shm_sec\n");
    exit (1);
  }
  shm_usec = (long *)shmat(shm_id_u, 0, 0);
  if ((int)shm_usec == -1) {
    fprintf(stderr, "error : shm_usec\n");
    exit (1);
  }
  
  sockadv = CreateMultiSockToSend (server_CB.advertise_ip, server_CB.advertise_port); 

  if ((pchild = fork()) == 0) {
    /* child */
    struct sockaddr_in adv;
    ServerAdv serveradv;

    /* Make Advertise Packet */
    serveradv.type = rfbServerAdv;
    serveradv.length = sizeof(ServerAdv);
    serveradv.server_port = server_CB.server_port;
    memcpy(serveradv.server_ID, server_CB.server_ID, IDLENGTH);

    /* Initialize address/port structure */
    bzero(&adv, sizeof(struct sockaddr_in));
    adv.sin_family = AF_INET;
    adv.sin_port = server_CB.advertise_port;
    adv.sin_addr.s_addr = server_CB.advertise_ip;

    while (1) {
      sleep(INTERVAL);	/*interval*/
      if (getppid() == 1) exit(-1);
      gettimeofday (&server_CB.basetime, 0);
      (*shm_sec) = server_CB.basetime.tv_sec;
      (*shm_usec) = server_CB.basetime.tv_usec;
      sendto(sockadv, &serveradv, serveradv.length, 0, (struct sockaddr *)&adv, sizeof(adv));
    }
  }

  return sockadv;
}


int
ConnectAdv ()
{
  int sockfd;
  struct sockaddr_in self;
  int optval = 1;

  /* Create listen socket */
  if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0 ) {
    fprintf(stderr, programName);
    perror(":sockfd : socket");
    return False;
  }

  if (setsockopt (sockfd, SOL_SOCKET, SO_REUSEADDR, &optval, sizeof (optval)) < 0) {
    fprintf(stderr, programName);
    perror(":sendfd : so_reuseaddr");
    shutdown(sockfd, SHUT_RDWR);
    close(sockfd);
    return False;
  }

  /* Initialize address/port structure */
  bzero(&self, sizeof(struct sockaddr_in));
  self.sin_family = AF_INET;
  self.sin_port = server_CB.server_port;
  self.sin_addr.s_addr = inet_addr(server_ifaddr);

  /* Assign a port number to the socket */
  if (bind(sockfd, (struct sockaddr*)&self, sizeof(self)) != 0) {
    fprintf(stderr, programName);
    perror(":sockfd : bind");
    shutdown(sockfd, SHUT_RDWR);
    close(sockfd);
    return False;
  }

  /* Make it a "listening socket" */
  if (listen(sockfd, MAXCON) != 0) {
    fprintf(stderr, programName);
    perror(":sockfd : listen");
    shutdown(sockfd, SHUT_RDWR);
    close(sockfd);
    return False;
  }

  /* Connect Myself */
  if (use_myself_client != 0) {
    if (ConnectMyself() < 0) {
      fprintf(stderr, programName);
      perror(":sendAdv: ");
      shutdown(sockfd, SHUT_RDWR);
      close(sockfd);
      return False;
    }
  }

  /* Send Advertise */
  if (SendAdv() < 0) {
    fprintf(stderr, programName);
    perror(":sendAdv: ");
    shutdown(sockfd, SHUT_RDWR);
    close(sockfd);
    return False;
  }

  return sockfd;
}

void
AdvInit ()
{
  int i;

  //bzero(&server_CB, sizeof(struct server_cb));
  if (strlen(server_name) == 0) {
    /* Input Server_ID */
    dialog_IDinput = (GtkWidget *)create_dialog_IDinput();
    gtk_widget_show(dialog_IDinput);
    show_gtkwindow(dialog_IDinput);
    gtk_grab_add(dialog_IDinput);
    gdk_threads_enter();
    gtk_main();
    gdk_threads_leave();
  } else {
    memcpy((char *)server_CB.server_ID, server_name, IDLENGTH);
    printf("server id: %s (%s)\n", server_CB.server_ID, server_name);
  }
  server_CB.server_port = htons(SERVER_PORT);
  server_CB.advertise_ip = inet_addr(ADVERTISE_IP);
  server_CB.advertise_port = htons(ADVERTISE_PORT);

  /* Casting_ip/port Initialize */
  for (i=0; i < MAXCLIENT-2; i++) {
    char tmp_ip[32];
    CARD32 int_ip;
    bzero (tmp_ip, 32);
    sprintf (tmp_ip, "%s%d", DEFAULT_IP, i+1);
    int_ip = inet_addr(tmp_ip);
    memcpy (&server_CB.casting_ip[i], &int_ip, sizeof(CARD32));
  }
  server_CB.casting_port = htons(SERVER_PORT);

  //sem_init ();
}

int
ConnectMyself ()
{
  char tmp[256] = "multivnc_client -d 1 -i lo --nonotice -u \"";
  strcat (tmp, (char *)server_CB.server_ID);
  strcat (tmp, "\" -s \"");
  strcat (tmp, (char *)server_CB.server_ID);
  strcat (tmp, "\" -q ");
  strcat (tmp, " &");
  printf("tmp=%s\n",tmp);

  return system(tmp);
}
  
void
ConnectCTL (struct sockaddr_in client_addr, int ctldsp, int cnum)
{
  printf("************ ConnectCTL ******************\n");
  printf("cnum=%d\n",cnum);
  server_CB.client_grp[cnum] = malloc(sizeof(struct client_grp));
  bzero(server_CB.client_grp[cnum], sizeof(struct client_grp));
  server_CB.client_grp[cnum]->client_status = NOSTAT;
  server_CB.client_grp[cnum]->ctldsp = ctldsp;
  server_CB.client_grp[cnum]->client_ip = client_addr.sin_addr.s_addr;
  server_CB.client_grp[cnum]->client_port = client_addr.sin_port;

  printf("%s:%d connected\n", inet_ntoa(client_addr.sin_addr), ntohs(client_addr.sin_port));
  printf("ctldsp=%d\n",(int)server_CB.client_grp[cnum]->ctldsp);
  printf("clientip=%s\n",inet_ntoa(client_addr.sin_addr));
  printf("clientport=%d\n",ntohs(client_addr.sin_port));

  server_CB.client_grp[cnum]->g_ctldsp = gdk_input_add_priority (server_CB.client_grp[cnum]->ctldsp, 
      GDK_INPUT_READ, (GdkInputFunction)controlSocketCallback, NULL, INPUT_PRIORITY);
  server_CB.client_grp[cnum]->vncconnect_tag = gtk_timeout_add(30000, timeoutVncConnectCallback, cnum);

  printf("ConnectCTL=%d\n",(int)server_CB.client_grp[cnum]);
  printf("ctl=%d, g_ctl=%d\nvnc=%d, g_vnc=%d\n",(int)server_CB.client_grp[cnum]->ctldsp,
      (int)server_CB.client_grp[cnum]->g_ctldsp,(int)server_CB.client_grp[cnum]->vncdsp,
      (int)server_CB.client_grp[cnum]->g_vncdsp);
  printf("************ END ******************\n");
}


void
ConnectVNC (struct sockaddr_in client_addr, int vncdsp, int cnum)
{
  sem_lock ();
  printf("************ ConnectVNC ******************\n");
  printf("cnum=%d\n",cnum);
  server_CB.client_grp[cnum]->vncdsp = vncdsp;
  
  printf("%s:%d connected\n", inet_ntoa(client_addr.sin_addr), ntohs(client_addr.sin_port));
  printf("vncdsp=%d\n",(int)server_CB.client_grp[cnum]->vncdsp);
  printf("vncclientip=%s\n",inet_ntoa(client_addr.sin_addr));
  printf("vncclientport=%d\n",ntohs(client_addr.sin_port));

  printf("connectVNC rfbsock from:%d to:%d\n",rfbsock,vncdsp);
  rfbsock = vncdsp;
  server_CB.processingNum = cnum;
  if (InitialiseRFBConnection() == False) {
    printf("InitialiseRFBConnection_error\n");
    return;
  }

  SetVisualAndCmap();
  ToplevelInitBeforeRealization();

  if (gdkimage[cnum] == NULL) {
    gdkimage[cnum] = gdk_image_new (GDK_IMAGE_FASTEST, gdkvis,
				    server_CB.client_grp[cnum]->serverInitMsg.framebufferWidth,
				    server_CB.client_grp[cnum]->serverInitMsg.framebufferHeight);
  }
  if (smallimage[cnum] == NULL) {
    smallimage[cnum] = gdk_image_new (GDK_IMAGE_FASTEST, gdkvis,
				      server_CB.client_grp[cnum]->serverInitMsg.framebufferWidth,
				      server_CB.client_grp[cnum]->serverInitMsg.framebufferHeight);
  }

  DesktopInitAfterRealization();
  SetFormatAndEncodings();

  if (!CheckDrawingarea(cnum)) {
    server_CB.client_grp[cnum]->cast_grp = EMPTY;
    server_CB.client_grp[cnum]->recv_grp = EMPTY;
    if (!DiscoverDrawingarea(cnum)) {
      if (tab_num == TAB_MAX) return;
      else {
	strcpy(draw_info[tab_num].group_name, "new group");
	server_CB.client_grp[cnum]->draw_page = page = tab_num;
	server_CB.client_grp[cnum]->draw_area = da_num = 0;
	makeTable(page, 2, 2);
	ChangeLabel(page, 0, (char *)server_CB.client_grp[cnum]->client_ID);
	tab_num++;
      }
    }
  } else {
    page = server_CB.client_grp[cnum]->draw_page;
    da_num = server_CB.client_grp[cnum]->draw_area;
  }

  clientNum = draw_info[page].client_num[da_num] = cnum;
  CreateImageInfo(FALSE);
  if (((gdkpixmap[page][da_num]) && (page == current_page) && (da_num < draw_info[page].row * draw_info[page].column))
      || (GETSEND(cnum)) || (GETVIEW(cnum)))
    SendAllFramebufferUpdateRequest();

  if (server_CB.client_grp[cnum]->vncdsp != 0) {
    server_CB.client_grp[cnum]->g_vncdsp = gdk_input_add_priority (server_CB.client_grp[cnum]->vncdsp, GDK_INPUT_READ, \
							  (GdkInputFunction)vncSocketCallback, NULL, INPUT_PRIORITY);
  }

  add_to_dialog_viewset(cnum);

  if (server_CB.client_grp[cnum]->vncconnect_tag != 0) {
    gtk_timeout_remove(server_CB.client_grp[cnum]->vncconnect_tag);
    server_CB.client_grp[cnum]->vncconnect_tag = 0;
  }

  printf("ConnectVNC=%d\n",(int)server_CB.client_grp[cnum]);
  printf("ctl=%d, g_ctl=%d\nvnc=%d, g_vnc=%d\n",(int)server_CB.client_grp[cnum]->ctldsp,
      (int)server_CB.client_grp[cnum]->g_ctldsp,(int)server_CB.client_grp[cnum]->vncdsp,
      (int)server_CB.client_grp[cnum]->g_vncdsp);
  printf("************ END ******************\n");
  sem_unlock ();
}

static void
gdk_io_destroy (gpointer data)
{
  GdkIOClosure *closure = data;

  if (closure->notify)
    closure->notify(closure->data);

  g_free(closure);
}

#define READ_CONDITION (G_IO_IN | G_IO_HUP | G_IO_ERR)
#define WRITE_CONDITION (G_IO_OUT | G_IO_ERR)
#define EXCEPTION_CONDITION (G_IO_PRI)

static gboolean
gdk_io_invoke (GIOChannel   *source,
	       GIOCondition condition,
	       gpointer     data)
{
  GdkIOClosure *closure = data;
  GdkInputCondition gdk_cond = 0;

  if (condition & READ_CONDITION)
    gdk_cond |= GDK_INPUT_READ;
  if (condition & WRITE_CONDITION)
    gdk_cond |= GDK_INPUT_WRITE;
  if (condition & EXCEPTION_CONDITION)
    gdk_cond |= GDK_INPUT_EXCEPTION;

  if (closure->condition & gdk_cond)
    closure->function(closure->data, g_io_channel_unix_get_fd(source), gdk_cond);

  return TRUE;
}

gint
gdk_input_add_priority (gint              source,
			GdkInputCondition condition,
			GdkInputFunction  function,
			gpointer          data,
			gint              priority)
{
  guint result;
  GdkIOClosure *closure = g_new(GdkIOClosure, 1);
  GIOChannel *channel;
  GIOCondition cond = 0;

  closure->function = function;
  closure->condition = condition;
  closure->notify = NULL;
  closure->data = data;

  if (condition & GDK_INPUT_READ)
    cond |= READ_CONDITION;
  if (condition & GDK_INPUT_WRITE)
    cond |= WRITE_CONDITION;
  if (condition & GDK_INPUT_EXCEPTION)
    cond |= EXCEPTION_CONDITION;

  channel = g_io_channel_unix_new(source);
  result = g_io_add_watch_full(channel, priority, cond, gdk_io_invoke,
			       closure, gdk_io_destroy);
  g_io_channel_unref(channel);

  return result;
}

void
controlSocketCallback (gpointer clientData, gint fd, GdkInputCondition condition)
{
  gdk_threads_enter();
  clientNum = getClientFromCtldsp (fd);
  if (clientNum == EMPTY) {
    gdk_threads_leave();
    return;
  }
  gdk_input_remove(server_CB.client_grp[clientNum]->g_ctldsp);
  int socket = server_CB.client_grp[clientNum]->ctldsp;
  char buf[4096];
  bzero (buf, 4096);

  if (recv (socket, buf, 2, 0) <= 0) {
    printf("session closed\n");

    /* クライアント消去 */
    if ((exDB_flag) && (!chStateDB(clientNum, 0))) {
      fprintf(stderr, "Can't Connect DB Server.\n");
    }

    // 画面送信を停止
    if (GETSEND(clientNum)) {
      // remove reciever
      int i;
      for (i = 0; i < MAXCLIENT; i++) {
        if (server_CB.client_grp[i] == NULL) continue;
	if (!GETRECV(i)) continue;
        if (server_CB.client_grp[i]->recv_grp != server_CB.client_grp[clientNum]->cast_grp) continue;
	server_CB.client_grp[i]->recv_grp = EMPTY;
        SETRECV(i, FALSE);
        SendCastMsg(GETRECV(i), i, 0);
        exprocSendStatusChangedMsg(i, makeClientStatus(i));
      }
      // remove sender
      int c_num = clientNum;
      (*shm_asym[c_num]).flag = CAST_STOP;
      int shmctlck;
      int res = shmdt(shm_asym[c_num]);
      shmctlck = shmctl(server_CB.client_grp[c_num]->shm_id, IPC_RMID, 0);
      printf("shm_deleted.(%d) ctlck=%d(errno=%d) client=%d grp=%d\n", \
        res,shmctlck,errno,c_num,server_CB.client_grp[c_num]->cast_grp);
      server_CB.cast_src[server_CB.client_grp[c_num]->cast_grp] = EMPTY;
      shm_asym[c_num] = NULL;

      gtk_timeout_remove (server_CB.client_grp[c_num]->calcrate_tag);
      if (Resend_flag)
        gtk_timeout_remove (server_CB.client_grp[c_num]->resend_tag);
      shutdown (server_CB.cstdsp[server_CB.client_grp[c_num]->cast_grp], SHUT_RDWR);
      close (server_CB.cstdsp[server_CB.client_grp[c_num]->cast_grp]);
    }
    // 画面操作を停止
    if (GETCTRL(clientNum)) {
      int i;
      for (i = 0; i < MAXCLIENT; i++) {
        if (server_CB.client_grp[i] == NULL) continue;
	if (!GETMCTRL(i)) continue;
        SETMCTRL(i, FALSE);
        exprocSendStatusChangedMsg(i, makeClientStatus(i));
        if ((server_CB.client_grp[i]->draw_page != current_page) && (!GETSEND(i))) {
          CutVNC(i);
          SendVncMsg(i);
        }
      }
    }

    if (server_CB.client_grp[clientNum]->g_vncdsp != 0) {
      int p,d;
      GdkRectangle gdkrect;

      DestroyImageInfo(clientNum);
      p = server_CB.client_grp[clientNum]->draw_page;
      d = server_CB.client_grp[clientNum]->draw_area;
      draw_info[p].client_num[d] = EMPTY;
      if (draw_info[p].row * draw_info[p].column > d) {
	ChangeLabel(p, d, "no client");
	gdk_draw_rectangle(gdkpixmap[p][d], drawingarea[p][d]->style->white_gc, TRUE,
			   0, 0, drawingarea[p][d]->allocation.width,
			   drawingarea[p][d]->allocation.height);
	gdkrect.x = 0;
	gdkrect.y = 0;
	gdkrect.width = drawingarea[p][d]->allocation.width;
	gdkrect.height = drawingarea[p][d]->allocation.height;
	gtk_widget_draw(drawingarea[p][d], &gdkrect);
      }
      if (gdkimage[clientNum]) {
	gdk_image_destroy(gdkimage[clientNum]);
	gdkimage[clientNum] = NULL;
      }
      if (smallimage[clientNum]) {
	gdk_image_destroy(smallimage[clientNum]);
	smallimage[clientNum] = NULL;
      }
      printf("Init cnum=%d\n",clientNum);
      CutVNC(clientNum);
    }

    if ((clientNum == clientNum_ex) && (window_ex != NULL)) {
      gtk_widget_destroy(window_ex);
      window_ex = NULL;
      exprocSendWindowChangedMsg(1, 2);
    }
    gdk_input_remove(server_CB.client_grp[clientNum]->g_ctldsp);
    shutdown(server_CB.client_grp[clientNum]->ctldsp, SHUT_RDWR);
    close(server_CB.client_grp[clientNum]->ctldsp);
    exprocSendStatusChangedMsg(clientNum, 0);
    bzero (server_CB.client_grp[clientNum], sizeof(struct client_grp));
    free(server_CB.client_grp[clientNum]);
    server_CB.client_grp[clientNum] = NULL;
    server_CB.user_num--;
    gdk_threads_leave();
    return;
  }
 
  switch (buf[0]) {

    case rfbClientAdv:
      printf("rfbClientAdv\n");
      if (recv (socket, buf, IDLENGTH, 0) <= 0) {
        printf("error rfbClientAdv \n");
      }
      memcpy (server_CB.client_grp[clientNum]->client_ID, buf, IDLENGTH);
      if (recv (socket, buf, MACADDR_SIZE, 0) <= 0) {
        printf("error rfbClientAdv \n");
      }
      memcpy (server_CB.client_grp[clientNum]->client_macaddr, buf, MACADDR_SIZE);
      printf("Client : %s\n",server_CB.client_grp[clientNum]->client_ID);
      fprintf(stderr, "Control packet receive\n");

      exprocSendStatusChangedMsg(clientNum, makeClientStatus(clientNum));
      /* Database Authentication */
      SendAllowMsg (clientNum, (char *)server_CB.client_grp[clientNum]->client_ID);
      break;

    case rfbClientExist:
      // server_CB.client_grp[clientNum]->state &= ~LOCKSTATE | (buf[1] & LOCKSTATE);

      gettimeofday(&timenow, 0);
      struct timeval tmptime;
      tmptime.tv_usec = timenow.tv_usec - (*shm_usec);
      if (tmptime.tv_usec < 0) tmptime.tv_usec += ((timenow.tv_sec - (*shm_sec)) * 1000000);
      server_CB.client_grp[clientNum]->r_time = tmptime.tv_usec;

      if (buf[1] & RESENDSTATE) SETRESEND (clientNum, 1);
      break;

    case rfbHistogramAdv:
      GetHistogram(clientNum, buf, socket);
      break;

    case rfbOperateStateDecisionRequestAdv:
      printf("rfbOperateStateDecisionRequestAdv\n");
      SendOpeStateDecisionMsg(clientNum);
      break;

    default:
      err("Unknown Message Type");
      printf("client:%d, type %d\n", clientNum, buf[0]);
      break;
  } 
  set_client_color (server_CB.client_grp[clientNum]->draw_page, server_CB.client_grp[clientNum]->draw_area);
  server_CB.client_grp[clientNum]->g_ctldsp = gdk_input_add_priority (server_CB.client_grp[clientNum]->ctldsp,
		        GDK_INPUT_READ, (GdkInputFunction)controlSocketCallback, NULL, INPUT_PRIORITY);
  gdk_threads_leave();
  return;
}

void
vncSocketCallback (gpointer clientData, gint fd, GdkInputCondition condition)
{
  // need to lock for input callback
  gdk_threads_enter();
  sem_lock ();
  clientNum = getClientFromVncdsp (fd);
  if (clientNum == EMPTY) {
    gdk_threads_leave();
    return;
  }
  gdk_input_remove(server_CB.client_grp[clientNum]->g_vncdsp);
  page = server_CB.client_grp[clientNum]->draw_page;
  da_num = server_CB.client_grp[clientNum]->draw_area;
  /* 非表示クライアントの画像データは破棄 */
  if ((!GETSEND(clientNum)) && (!GETVIEW(clientNum)) && (!GETMCTRL(clientNum))) {
    if ((page != current_page) || (draw_info[page].row * draw_info[page].column <= da_num) || 
	(gdkpixmap[page][da_num] == NULL)) {
      char dummybuf[MAXBUF];
      while (read(server_CB.client_grp[clientNum]->vncdsp, dummybuf, MAXBUF) == MAXBUF);
      server_CB.client_grp[clientNum]->g_vncdsp = gdk_input_add_priority (server_CB.client_grp[clientNum]->vncdsp, \
						   GDK_INPUT_READ, (GdkInputFunction)vncSocketCallback, NULL, INPUT_PRIORITY);
      gdk_threads_leave();
      return;
    }
  }

  if (server_CB.client_grp[clientNum]->vncdsp != 0) {
    rfbsock = server_CB.client_grp[clientNum]->vncdsp;
  }
  
  reducedWindowWidth = drawingarea[page][da_num]->allocation.width;
  reducedWindowHeight = drawingarea[page][da_num]->allocation.height;
  CreateImageInfo(FALSE);
  memcpy(&si, &(server_CB.client_grp[clientNum]->serverInitMsg), sizeof(si));
  if (HandleRFBServerMessage() < 0) {
    printf("#########error#########\n");
  }
  sem_unlock ();

  if (server_CB.client_grp[clientNum]->vncdsp != 0) {
    server_CB.client_grp[clientNum]->g_vncdsp = gdk_input_add_priority (server_CB.client_grp[clientNum]->vncdsp, \
						GDK_INPUT_READ, (GdkInputFunction)vncSocketCallback, NULL, INPUT_PRIORITY);
  }

  gdk_threads_leave();
  g_thread_yield();
  return;
}

int
getClientFromCtldsp (int fd)
{
  int cnt;
  int max = server_CB.user_num;

  for (cnt = 0; cnt < MAXCLIENT; cnt++) {
    if (server_CB.client_grp[cnt] == NULL) continue;
    if (server_CB.client_grp[cnt]->ctldsp == fd)
      return cnt;
  }
  fprintf (stderr, "getClientFromCtldsp search error, user_num : %d, fd : %d\n", max, fd);
  return EMPTY;
}

int
getClientFromVncdsp (int fd)
{
  int cnt;
  int max = server_CB.user_num;

  for (cnt = 0; cnt < MAXCLIENT; cnt++) {
    if (server_CB.client_grp[cnt] == NULL) continue;
    if (server_CB.client_grp[cnt]->vncdsp == fd)
      return cnt;
  }
  fprintf (stderr, "getClientFromVncdsp search error, user_num : %d, fd : %d\n", max, fd);
  return EMPTY;
}

Bool 
AuthDB (char *client_ID)
{

  /* client authentication */
  printf("AuthDB=%s\n",client_ID);    

  MYSQL *myData;
  MYSQL_RES *res;
  int num;
  
  char Tmpquery[64] = "select * from student where id = '";
  strcat(Tmpquery, client_ID);
  strcat(Tmpquery, "'");
  printf("%s\n", Tmpquery);
  
  printf("host=%s, port=%d, name=%s, pass=%s, database=%s\n", \
      server_CB.DB_Host,server_CB.DB_Port,server_CB.DB_Name,server_CB.DB_Pass,server_CB.DB_Database);
  if ((myData = mysql_init((MYSQL *)0)) && \
      mysql_real_connect (myData, (char *)server_CB.DB_Host, (char *)server_CB.DB_Name, \
      (char *)server_CB.DB_Pass, (char *)server_CB.DB_Database, server_CB.DB_Port, NULL, 0)) {
    num = mysql_query (myData, Tmpquery);
    if (num != 0) {
      printf("Can't connect SQL-server\n");
    } else {
      res = mysql_store_result(myData);
      if (mysql_num_rows(res) > 0) {
        /* success */
        mysql_close(myData);
        return True;
      }
    }
    mysql_close(myData);
  }
  
  /* failure */
  printf("Failure\n");
  return False;
}

Bool 
chStateDB(int clientNum, int flag)
{
  MYSQL *myData;
  char Tmpquery[64];
  int num;

  if (flag) strcpy(Tmpquery, "update student set joinnow = 't' where joinnow = 'f' and id = '");
  else strcpy(Tmpquery, "update student set joinnow = 'f' where joinnow = 't' and id = '");
  strcat(Tmpquery, (char *)server_CB.client_grp[clientNum]->client_ID);
  strcat(Tmpquery, "'");

  printf("%s\n",Tmpquery);
  
  if ((myData = mysql_init((MYSQL *)0)) && \
      mysql_real_connect (myData, (char *)server_CB.DB_Host, (char *)server_CB.DB_Name, \
      (char *)server_CB.DB_Pass, (char *)server_CB.DB_Database, server_CB.DB_Port, NULL, 0)) {
    num = mysql_query (myData, Tmpquery);
    if (num == 0) {
      /* success */
      mysql_close(myData);
      return True;
    }
    mysql_close(myData);
  }
  
  /* failure */
  printf("Failure\n");
  return False;
}


static Bool
CheckDrawingarea(int client)
{
  int pCnt, dCnt;

  for (pCnt = 0; pCnt < tab_num; pCnt++) {
    for (dCnt = 0; dCnt < TABGROUP_MAX; dCnt++) {
      if (draw_info[pCnt].client_num[dCnt] == client) return True;
    }
  }

  return False;
}


static Bool
DiscoverDrawingarea(int client)
{
  int pCnt, dCnt, area;

  for (pCnt = 0; pCnt < tab_num; pCnt++) {
    area = draw_info[pCnt].row * draw_info[pCnt].column;
    for (dCnt = 0; dCnt < area; dCnt++) {
      if (draw_info[pCnt].client_num[dCnt] == EMPTY) {
	ChangeLabel(pCnt, dCnt, (char *)server_CB.client_grp[client]->client_ID);
	server_CB.client_grp[client]->draw_page = page = pCnt;
	server_CB.client_grp[client]->draw_area = da_num = dCnt;
	return True;
      }
    }
  }

  return False;
}

int
CreateMultiSockToSend (unsigned int ip, int port)
{
  int sockadv;
  struct sockaddr_in adv;
  struct ip_mreq stMreq;
  u_long TTLadv = multi_ttl;
  int optval = 1;

  /* Create advertise socket */
  if ( (sockadv= socket(AF_INET, SOCK_DGRAM, 0)) < 0 ) {
    fprintf(stderr, "%s : CreateMultiSockToSend : socket\n", programName);
    Cleanup();
    exit (1);
  }

  if (setsockopt (sockadv, SOL_SOCKET, SO_REUSEADDR, &optval, sizeof (optval)) < 0) {
    fprintf(stderr, "%s : CreateMultiSockToSend : so_reuseaddr\n", programName);
    shutdown(sockadv, SHUT_RDWR);
    close(sockadv);
    Cleanup();
    exit (1);
  }

  /* Initialize address/port structure */
  bzero(&adv, sizeof(struct sockaddr_in));
  adv.sin_family = AF_INET;
  adv.sin_port = port;
  adv.sin_addr.s_addr = ip;

  stMreq.imr_multiaddr.s_addr = adv.sin_addr.s_addr;
  stMreq.imr_interface.s_addr = inet_addr(server_ifaddr);

  if (setsockopt(sockadv, IPPROTO_IP, IP_MULTICAST_IF, (char *) &stMreq.imr_interface.s_addr, sizeof(stMreq.imr_interface.s_addr)) < 0) {
    fprintf(stderr, "%s : CreateMultiSockToSend : ip_multicast_if\n", programName);
    shutdown(sockadv, SHUT_RDWR);
    close(sockadv);
    Cleanup();
    exit (1);
  }


  if (setsockopt(sockadv, IPPROTO_IP, IP_ADD_MEMBERSHIP, (char *) &stMreq, sizeof(stMreq)) < 0) {
    fprintf(stderr, "%s : CreateMultiSockToSend : ip_add_membership\n", programName);
    shutdown(sockadv, SHUT_RDWR);
    close(sockadv);
    Cleanup();
    exit (1);
  }

  if (setsockopt(sockadv, IPPROTO_IP, IP_MULTICAST_TTL, (char *) &TTLadv, sizeof(TTLadv)) < 0) {
    fprintf(stderr, "%s : CreateMultiSockToSend : ip_multicast_ttl\n", programName);
    shutdown(sockadv, SHUT_RDWR);
    close(sockadv);
    Cleanup();
    exit (1);
  }

  return sockadv;
}

void
CutVNC (int clientNum)
{
  if (server_CB.client_grp[clientNum]->vncdsp) {
    printf("CutVNC cnum=%d\n",clientNum);
    bzero(&zlibStream[clientNum][0], sizeof(z_stream)*4);
    bzero(&zlibStreamActive[clientNum][0], sizeof(Bool)*4);
    gdk_input_remove(server_CB.client_grp[clientNum]->g_vncdsp);
    shutdown(server_CB.client_grp[clientNum]->vncdsp, SHUT_RDWR);
    close(server_CB.client_grp[clientNum]->vncdsp);
    server_CB.client_grp[clientNum]->vncdsp = 0;
  }
}

void 
SendCastMsg (char flag, int clientNum, char fullscreen)
{
  CastAdv castadv;
  int len;
  int i;

  bzero(&castadv, sizeof(CastAdv));
  castadv.type = rfbCastAdv;
  castadv.flag = flag;
  castadv.casting_ip = server_CB.casting_ip[server_CB.client_grp[clientNum]->recv_grp];
  castadv.casting_port = server_CB.casting_port;
  castadv.fullscreen = fullscreen;
  memcpy(&castadv.pixelFormat, &myFormat, sizeof(rfbPixelFormat));

  for (i = 0; i < MAXCLIENT; i++) {
    if (server_CB.client_grp[i]->cast_grp == server_CB.client_grp[clientNum]->recv_grp) {
      memcpy (castadv.src_ID, server_CB.client_grp[i]->client_ID, IDLENGTH);
      memcpy (&castadv.serverInitMsg, &server_CB.client_grp[i]->serverInitMsg, sizeof(rfbServerInitMsg));
      break;
    }
  }

  len = write (server_CB.client_grp[clientNum]->ctldsp, &castadv, sizeof(CastAdv));
}

void 
SendLockMsg (char flag, int clientNum)
{
  LockAdv lockadv;

  bzero(&lockadv, sizeof(LockAdv));
  lockadv.type = rfbLockAdv;
  lockadv.flag = flag;
  lockadv.locktime = LOCKTIME;

  write (server_CB.client_grp[clientNum]->ctldsp, &lockadv, sizeof(LockAdv));
}

void
SendAllowMsg (int clientNum, char *buf)
{
  AllowAdv allowadv;

  allowadv.type = rfbAllowAdv; 
  allowadv.flag = (exDB_flag) ? AuthDB (buf) : 1;

  send (server_CB.client_grp[clientNum]->ctldsp, &allowadv, sizeof(AllowAdv), 0);
}
  
void
SendVncMsg (int clientNum)
{
  VncConnAdv vncconnadv;

  vncconnadv.type = rfbVncConnAdv; 
  vncconnadv.flag = STAT_CUT;

  send (server_CB.client_grp[clientNum]->ctldsp, &vncconnadv, sizeof(VncConnAdv), 0);
}

void
CheckLockClient(void)
{
  int c_num, user_cnt = 0;

  for (c_num = 0; c_num < MAXCLIENT; c_num++) {
    if (server_CB.client_grp[c_num] == NULL) continue;
    if (GETLOCK(c_num))
      SendLockMsg(1, c_num);
    if (server_CB.user_num == ++user_cnt) return;
  }
}

void
sem_init ()
{
  /* セマフォの作成と初期化 */
  semaphore = semget ((key_t)9999, 1, 0666|IPC_CREAT);
  if (semaphore == -1) {
    fprintf(stderr, "semget error\n");
    exit (1);
  }
  {
    union semun semunion;

    semunion.val = 1;
    if (semctl(semaphore, 0, SETVAL, semunion) == -1) {
      fprintf(stderr, "semctl_init error\n");
      exit (1);
    }
  }

  semb.sem_num = 0;
  semb.sem_op = -1;
  semb.sem_flg = SEM_UNDO;
}

void
sem_lock ()
{
  return;
  /* セマフォの取得 */
  errno = 0;
  if (semop (semaphore, &semb, 1) == -1) {
    fprintf(stderr, "semop_wait error %d\n",errno);
    sem_init ();
  }
}

void
sem_unlock ()
{
  return;
  /* セマフォの解放 */
  semb.sem_op = 1;
  if (semop (semaphore, &semb, 1) == -1) {
    fprintf(stderr, "semop_signal error\n");
  }
}

void SendOpeStateDecisionMsg (int clientNum)
{
  OperateStateDecisionAdv osdadv;

  memset(&osdadv, 0, sizeof(OperateStateDecisionAdv));
  osdadv.type = rfbOperateStateDecisionAdv;
  osdadv.flag = server_CB.ope_flag;
  osdadv.getimage_interval = htons(server_CB.getimage_interval);
  osdadv.freeze_count = server_CB.freeze_count;

  send(server_CB.client_grp[clientNum]->ctldsp, &osdadv, sizeof(OperateStateDecisionAdv), 0);
}

int mac2id(unsigned char *maddr)
{
	int i;

	for (i = 0; i < MAXCLIENT; i++) {
		if (!server_CB.client_grp[i]) {
			continue;
		}
		if (memcmp(server_CB.client_grp[i]->client_macaddr, maddr, MACADDR_SIZE)) {
			continue;
		}
		return i;
	}
	return -1;
}

unsigned char makeClientStatus(int clientNum)
{
	unsigned char status = 0x00;

	if (!server_CB.client_grp[clientNum]) {
		return status;
	} else {
		status |= 0x01;
	}
	if (GETRECV(clientNum)) {
		status |= 0x02;
	}
	if ((GETCTRL(clientNum)) || (GETMCTRL(clientNum))) {
		status |= 0x04;
	}
	if (GETLOCK(clientNum)) {
		status |= 0x08;
	}
	switch (server_CB.client_grp[clientNum]->client_status) {
	case FREEZE:
		status |= 0x10;
		break;
	case IRREGULAR:
		status |= 0x20;
		break;
	case CHAOS:
		status |= 0x30;
		break;
	default:
		break;
	}

	return status;
}

void exprocSendStatusChangedMsg(int clientNum, unsigned char status)
{
	char buf[9];
	int sock;
	struct sockaddr_in addr;

	if ((exproc_ip == 0) || (exproc_port == 0)) {
		return;
	}

	buf[0] = EXPROC_MSG_STATUS_CHANGED;
	buf[1] = 1;
	memcpy(&buf[2], server_CB.client_grp[clientNum]->client_macaddr, MACADDR_SIZE);
	buf[8] = status;
	
	sock = socket(AF_INET, SOCK_STREAM, 0);

	// set linger for send queue clear
	struct linger li;
	li.l_onoff  = 1;
	li.l_linger = 5;
	setsockopt(sock, SOL_SOCKET, SO_LINGER, (char*) &li, sizeof(li));

	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = exproc_port;
	addr.sin_addr.s_addr = exproc_ip;
	connect(sock, (struct sockaddr *)&addr, sizeof(addr));

	send(sock, buf, sizeof(buf), 0);
	shutdown(sock, SHUT_RDWR);
	close(sock);
}

void exprocSendWindowChangedMsg(unsigned char windowID, unsigned char status)
{
	char buf[4];
	int sock;
	struct sockaddr_in addr;

	if ((exproc_ip == 0) || (exproc_port == 0)) {
		return;
	}

	buf[0] = EXPROC_MSG_WINDOW_CHANGED;
	buf[1] = 0;
	buf[2] = windowID;
	buf[3] = status;
	
	sock = socket(AF_INET, SOCK_STREAM, 0);
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = exproc_port;
	addr.sin_addr.s_addr = exproc_ip;
	connect(sock, (struct sockaddr *)&addr, sizeof(addr));

	send(sock, buf, sizeof(buf), 0);
	shutdown(sock, SHUT_RDWR);
	close(sock);
}

void* exproc_callback(void *args)
{
	int exproc_sock;
	int peer_sock;
	struct sockaddr_in host_addr;
	struct sockaddr_in peer_addr;
	int opt;
	int len;
	unsigned char buf[1024];

	/* block all signal in this thread */
	sigset_t set;
	sigfillset(&set);
	pthread_sigmask(SIG_SETMASK, &set, NULL);

	exproc_sock = socket(AF_INET, SOCK_STREAM, 0);
	memset(&host_addr, 0, sizeof(host_addr));
	host_addr.sin_family = AF_INET;
	host_addr.sin_port = htons(EXPROC_PORT);
	host_addr.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
	
	opt = 1;
	if (setsockopt(exproc_sock, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt))) {
		fprintf(stderr, "--exproc_callback--  setsockopt() failed.\n");
		return (void *)-1;
	}
	
	if (bind(exproc_sock, (struct sockaddr *)&host_addr, sizeof(host_addr))) {
		fprintf(stderr, "--exproc_callback--  bind() failed.\n");
		return (void *)-1;
	}
	if (listen(exproc_sock, 1)) {
		fprintf(stderr, "--exproc_callback--  listen() failed.\n");
		return (void *)-1;
	}
	
	while (1) {
		memset(&peer_addr, 0, sizeof(peer_addr));
		len = sizeof(peer_addr);
		peer_sock = accept(exproc_sock, (struct sockaddr *)&peer_addr, (socklen_t *)&len);
		if (peer_sock < 0) {
			fprintf(stderr, "--exproc_callback--  accept() failed.\n");
			return (void *)-1;
		}
		while (1) {
			memset(buf, 0, sizeof(buf));
			len = recv(peer_sock, buf, sizeof(buf), 0);
			if (len <= 0) {
				break;
			}
			switch (buf[0]) {
			case EXPROC_MSG_REGISTER:
				exprocMsgRegister(buf, len);
				break;
			case EXPROC_MSG_EXPAND:
				exprocMsgExpand(buf, len);
				break;
			case EXPROC_MSG_LIST:
				exprocMsgList(buf, len);
				break;
			case EXPROC_MSG_SENDSCREEN:
				exprocMsgSendscreen(buf, len);
				break;
			case EXPROC_MSG_OPERATE:
				exprocMsgOperate(buf, len);
				break;
			case EXPROC_MSG_LOCK:
				exprocMsgLock(buf, len);
				break;
			case EXPROC_MSG_DISCONNECT:
				exprocMsgDisconnect(buf, len);
				break;
			case EXPROC_MSG_STATUS_CHANGED:
			case EXPROC_MSG_WINDOW_CHANGED:
			default:
				break;
			}
		}
		shutdown(peer_sock, SHUT_RDWR);
		close(peer_sock);
	}
	shutdown(exproc_sock, SHUT_RDWR);
	close(exproc_sock);
}

void exprocMsgRegister(unsigned char *msg, int len)
{
	int flag;
	unsigned int ip;
	unsigned short port;
	int i;
	
	// MSG-ID + Flag + IP-Addr + Port
	if (len < 8) {
		return;
	}

	flag = msg[1];
	ip = *(unsigned int *)&(msg[2]);
	port = *(unsigned short *)&(msg[6]);
	
	if (flag) {
		if ((exproc_ip == 0) && (exproc_port == 0)) {
			exproc_ip = ip;
			exproc_port = port;
			for (i = 0; i < MAXCLIENT; i++) {
				if (server_CB.client_grp[i]) {
					exprocSendStatusChangedMsg(i, makeClientStatus(i));
				}
			}
		}
	} else {
		if ((exproc_ip = ip) && (exproc_port == port)) {
			exproc_ip = 0;
			exproc_port = 0;
		}
	}
}

void exprocMsgExpand(unsigned char *msg, int len)
{
	unsigned char maddr[MACADDR_SIZE];
	int flag;
	
	// MSG-ID + Flag + MAC-Addr
	if (len < 2 + MACADDR_SIZE) {
		return;
	}

	flag = msg[1];

	memset(maddr, 0, sizeof(maddr));
	memcpy(maddr, &(msg[2]), MACADDR_SIZE);

	runExpand(flag, maddr);
}

void exprocMsgList(unsigned char *msg, int len)
{
	unsigned char **maddr;
	int count;
	int i;
	int err;

	// MSG-ID + Count
	if (len < 2) {
		return;
	}
	
	count = msg[1];

	// MSG-ID + Count + (MAC-Addr * Count)
	if (len < 2 + count * MACADDR_SIZE) {
		return;
	}

	maddr = (unsigned char **)malloc(count * sizeof(unsigned char *));
	if (!maddr) {
		return;
	}
	memset(maddr, 0, count * sizeof(unsigned char *));
	err = 0;
	for (i = 0; i < count; i++) {
		maddr[i] = (unsigned char *)malloc(MACADDR_SIZE);
		if (!maddr[i]) {
			err = 1;
			break;
		}
		memset(maddr[i], 0, sizeof(MACADDR_SIZE));
		memcpy(maddr[i], &(msg[2 + i * MACADDR_SIZE]), MACADDR_SIZE);
	}
	
	if (!err) {
		runList(maddr, count);
	}
	
	for (i = 0; i < count; i++) {
		free(maddr[i]);
	}
	free(maddr);
}

void exprocMsgSendscreen(unsigned char *msg, int len)
{
	unsigned char **maddr;
	int flag;
	int count;
	int i;
	int err;

	// MSG-ID + Flag + Count
	if (len < 3) {
		return;
	}
	
	flag = msg[1];
	count = msg[2];

	// MSG-ID + Flag + Count + (MAC-Addr * Count)
	if (len < 3 + count * MACADDR_SIZE) {
		return;
	}

	maddr = (unsigned char **)malloc(count * sizeof(unsigned char *));
	if (!maddr) {
		return;
	}
	memset(maddr, 0, count * sizeof(unsigned char *));
	err = 0;
	for (i = 0; i < count; i++) {
		maddr[i] = (unsigned char *)malloc(MACADDR_SIZE);
		if (!maddr[i]) {
			err = 1;
			break;
		}
		memset(maddr[i], 0, sizeof(MACADDR_SIZE));
		memcpy(maddr[i], &(msg[3 + i * MACADDR_SIZE]), MACADDR_SIZE);
	}
	
	if (!err) {
		runSendScreen(flag, maddr, count);
	}
	
	for (i = 0; i < count; i++) {
		free(maddr[i]);
	}
	free(maddr);
}

void exprocMsgOperate(unsigned char *msg, int len)
{
	unsigned char **maddr;
	int flag;
	int count;
	int i;
	int err;

	// MSG-ID + Flag + Count
	if (len < 3) {
		return;
	}
	
	flag = msg[1];
	count = msg[2];

	// MSG-ID + Flag + Count + (MAC-Addr * Count)
	if (len < 3 + count * MACADDR_SIZE) {
		return;
	}

	maddr = (unsigned char **)malloc(count * sizeof(unsigned char *));
	if (!maddr) {
		return;
	}
	memset(maddr, 0, count * sizeof(unsigned char *));
	err = 0;
	for (i = 0; i < count; i++) {
		maddr[i] = (unsigned char *)malloc(MACADDR_SIZE);
		if (!maddr[i]) {
			err = 1;
			break;
		}
		memset(maddr[i], 0, sizeof(MACADDR_SIZE));
		memcpy(maddr[i], &(msg[3 + i * MACADDR_SIZE]), MACADDR_SIZE);
	}
	
	if (!err) {
		runOperate(flag, maddr, count);
	}
	
	for (i = 0; i < count; i++) {
		free(maddr[i]);
	}
	free(maddr);
}

void exprocMsgLock(unsigned char *msg, int len)
{
	unsigned char maddr[MACADDR_SIZE];
	int flag;
	int count;
	int i;

	// MSG-ID + Flag + Count
	if (len < 3) {
		return;
	}
	
	flag = msg[1];
	count = msg[2];

	// MSG-ID + Flag + Count + (MAC-Addr * Count)
	if (len < 3 + count * MACADDR_SIZE) {
		return;
	}

	for (i = 0; i < count; i++) {
		memset(maddr, 0, sizeof(maddr));
		memcpy(maddr, &(msg[3 + i * MACADDR_SIZE]), MACADDR_SIZE);
		runLock(flag, maddr);
	}
}

void exprocMsgDisconnect(unsigned char *msg, int len)
{
	unsigned char maddr[MACADDR_SIZE];
	
	// MSG-ID + MAC-Addr
	if (len < 1 + MACADDR_SIZE) {
		return;
	}

	memset(maddr, 0, sizeof(maddr));
	memcpy(maddr, &(msg[1]), MACADDR_SIZE);

	runDisconnect(maddr);
}

static gboolean timeoutVncConnectCallback(gpointer data)
{
	int num = (int)data;
	if (server_CB.client_grp[num] != NULL) {
		printf("timeout vncconnect: cnum=%d\n", num);
		runDisconnect(server_CB.client_grp[num]->client_macaddr);
	}
	return FALSE;
}

